#!/usr/bin/env node
/*
Copyright Jesus Perez <jesusprubio gmail com>
          Sergio Garcia <s3rgio.gr gmail com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* eslint-disable no-console */

'use strict';

const Bluebox = require('../');
const async = require('async');

const options = {};
const bluebox = new Bluebox(options);
const shodanKey = '';

const finalReport = {};
const targetHost = '';
const moduleOptions = {
  ip: targetHost,
  target: targetHost,
  targets: targetHost,
  srcHost: 'iface:<The name of your network interface>',
};


async.series([
  callback => {
    const action = 'shodanHost';

    if (shodanKey) {
      bluebox.shodanKey = shodanKey;
      console.log('Searching host in Shodan...');

      bluebox.runModule(action, moduleOptions, (err, result) => {
        if (err) {
          callback(err);
        } else {
          finalReport[action] = result;
          callback(null);
        }
      });
    } else {
      console.error('No Shodan Key found.');
      callback(null);
    }
  },
  callback => {
    const action = 'sipScan';

    console.log('SIP scanning...');
    bluebox.runModule(action, moduleOptions, (err, result) => {
      if (err) {
        callback(err);
      } else {
        console.log(`${result[0].service} ${result[0].version} found.`);
        finalReport[action] = result;
        callback(null);
      }
    });
  },
  callback => {
    const action = 'exploitSearch';

    moduleOptions.query = `${finalReport.sipScan[0].service} ${finalReport.sipScan[0].version}`;
    console.log(`Looking for exploits for ${moduleOptions.query}...`);
    bluebox.runModule(action, moduleOptions, (err, result) => {
      if (err) {
        callback(err);
      } else {
        finalReport[action] = result;
        callback(null);
      }
    });
  },
  callback => {
    const action = 'sipBruteExt100';

    bluebox.runModule(action, moduleOptions, (err, result) => {
      if (err) {
        callback(err);
      } else {
        if (result.vulnerable) {
          console.log('The host is vulnerable to CVE-2011-2536 / AST-2011-011');
        } else {
          console.log('The host is NOT vulnerable to CVE-2011-2536 / AST-2011-011');
        }
        finalReport[action] = result;
        callback(null);
      }
    });
  },
  callback => {
    const action = 'sipBruteExt404';

    bluebox.runModule(action, moduleOptions, (err, result) => {
      if (err) {
        callback(err);
      } else {
        if (result.vulnerable) {
          console.log('The host is vulnerable to CVE-2009-3727 / AST-2009-008');
        } else {
          console.log('The host is NOT vulnerable to CVE-2009-3727 / AST-2009-008');
        }
        finalReport[action] = result;
        callback(null);
      }
    });
  },
  callback => {
    const action = 'sipUnauthCall';

    bluebox.runModule(action, moduleOptions, (err, result) => {
      if (err) {
        callback(err);
      } else {
        if (result.vulnerable) {
          console.log('[sipUnauthCall] Host vulnerable');
        }
        finalReport[action] = result;
        callback(null);
      }
    });
  },
],
err => {
  if (err) {
    console.error(err);
  } else {
    console.log(finalReport);
  }
});
