# node-exploitsearch-client

![Travis-ci status](https://api.travis-ci.org/jesusprubio/node-exploitsearch-client.svg)

A [Node.js](https://nodejs.org) library for accessing the [Exploitsearch.net](http://www.exploitsearch.net/) site API.

![Demo](https://raw.githubusercontent.com/jesusprubio/node-exploitsearch-client/master/artifacts/demo.gif)


## Use

```javascript
const ExploitSearch = require('exploitsearch');


const client = new ExploitSearch({
  timeout: 10000,
  // We only want exploits.
  exploits: true,
});


client.search('freepbx', (err, res) => {
  if (err) {
    console.log('Error:');
    console.log(err);

    process.exit(1);
  } else {
    console.log('Response:');
    console.log(res);
  }
});
```

More examples are included in the [**tests**](./test).


## API

The constructor is returned. It accepts an options object with next properties:
- `timeout` - Connection timeout in ms. (default: 5000)
- `exploits` - Only return vulnerabilities with public exploits. (default: false)
NOTE: Both are public, so you can change them when you want.

### Methods
#### `search(queryString, callback)`
Make a request to the API.
- `queryString`- The string to make the search.
- `callback` - We follow the [Error-first callback](http://thenodeway.io/posts/understanding-error-first-callbacks/) paradigm.


## Developer guide

- Use [GitHub pull requests](https://help.github.com/articles/using-pull-requests).
- Conventions:
 - We use [ESLint](http://eslint.org/) and [Airbnb](https://github.com/airbnb/javascript) style guide.
 - Please run `gulp lint` to be sure your code fits with it.


## License

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
