/*!
 * libnmap
 * Copyright(c) 2013-2016 Jason Gerfen <jason.gerfen@gmail.com>
 * License: MIT
 */

var nmap = require('../')
  , timeout = 1024 * 1024
  , chai = require('chai')
  , should = chai.should()
  , expect = chai.expect
  , ifaces = require('os').networkInterfaces();

describe('nmap', function() {
  describe('discovery method', function() {

    this.timeout(timeout);

    it('validate report', function(done) {

      nmap.discover(function(err, report) {

        /* If 'subnet' doesn't exist in os.networkInterfaces() expect errors */
        for (var adapter in ifaces) {
          if (!ifaces[adapter][0].internal) {
            if (!ifaces[adapter][0].hasOwnProperty('subnet')) {
              try {
                done();
              } catch(error) {
                done(error);
              }
            } else {
              try {
                should.not.exist(err);
                should.exist(report);
              } catch(error) {
                done(error);
              }
            }
          }
        }
      });
    });
  });
});
