/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.shaperpack;

import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class CanonicalPath {
    private ArrayList<Point2D> majorPoints;
    private ArrayList<Point2D> minorPoints;
    private double ratio;

    public CanonicalPath(ArrayList<Point2D> majorPoints, ArrayList<Point2D> minorPoints, double ratio) {
        if (majorPoints.size() != minorPoints.size()) {
            throw new IllegalArgumentException("Sizes of major and minor must be equal");
        }
        this.majorPoints = majorPoints;
        this.minorPoints = minorPoints;
        this.ratio = ratio;
    }

    public GeneralPath getPath(int width, int height, Insets insets) {
        int ys;
        GeneralPath path = new GeneralPath();
        if (this.majorPoints.size() < 2) {
            return path;
        }
        int xs = insets == null ? 0 : insets.left;
        int n = ys = insets == null ? 0 : insets.top;
        if (insets != null) {
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        path.moveTo((float)((double)xs + (double)width * this.majorPoints.get(0).getX()), (float)((double)ys + (double)height * this.majorPoints.get(0).getY()));
        for (int i = 1; i < this.majorPoints.size(); ++i) {
            path.quadTo((float)((double)xs + (double)width * this.minorPoints.get(i - 1).getX()), (float)((double)ys + (double)height * this.minorPoints.get(i - 1).getY()), (float)((double)xs + (double)width * this.majorPoints.get(i).getX()), (float)((double)ys + (double)height * this.majorPoints.get(i).getY()));
        }
        path.quadTo((float)((double)xs + (double)width * this.minorPoints.get(this.minorPoints.size() - 1).getX()), (float)((double)ys + (double)height * this.minorPoints.get(this.minorPoints.size() - 1).getY()), (float)((double)xs + (double)width * this.majorPoints.get(0).getX()), (float)((double)ys + (double)height * this.majorPoints.get(0).getY()));
        return path;
    }

    public ArrayList<Point2D> getMajorPoints() {
        return this.majorPoints;
    }

    public ArrayList<Point2D> getMinorPoints() {
        return this.minorPoints;
    }

    public double getRatio() {
        return this.ratio;
    }
}

