/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.shaperpack;

import java.awt.geom.Point2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jvnet.substance.shaperpack.CanonicalPath;

public class ShaperRepository {
    public static CanonicalPath read(InputStream stream) {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(stream);
            double ratio = dis.readDouble();
            int pointCount = dis.readInt();
            ArrayList<Point2D> major = new ArrayList<Point2D>();
            ArrayList<Point2D> minor = new ArrayList<Point2D>();
            for (int i = 0; i < pointCount; ++i) {
                Point2D.Double currMajor = new Point2D.Double(dis.readDouble(), dis.readDouble());
                Point2D.Double currMinor = new Point2D.Double(dis.readDouble(), dis.readDouble());
                major.add(currMajor);
                minor.add(currMinor);
            }
            return new CanonicalPath(major, minor, ratio);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static void write(OutputStream stream, CanonicalPath path) {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(stream);
            ArrayList<Point2D> major = path.getMajorPoints();
            ArrayList<Point2D> minor = path.getMinorPoints();
            dos.writeDouble(path.getRatio());
            dos.writeInt(major.size());
            for (int i = 0; i < major.size(); ++i) {
                Point2D currMajor = major.get(i);
                dos.writeDouble(currMajor.getX());
                dos.writeDouble(currMajor.getY());
                Point2D currMinor = minor.get(i);
                dos.writeDouble(currMinor.getX());
                dos.writeDouble(currMinor.getY());
            }
        }
        catch (Exception exc) {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Exception exc2) {
                // empty catch block
            }
        }
    }
}

