/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgController;

import bluepot.pkgModel.Model;
import bluepot.pkgView.View;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Randomiser
implements Runnable {
    View view;
    Model model;
    Vector names;

    public Randomiser(Model model, View view) {
        this.model = model;
        this.view = view;
        this.names = new Vector();
        this.loadNameList();
    }

    public void loadNameList() {
        this.names.clear();
        File nameList = new File("data/config.ser");
        if (nameList.exists()) {
            try {
                String strLine;
                FileInputStream fstream = new FileInputStream(this.model.getSettings().getRandomNameFolder());
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((strLine = br.readLine()) != null) {
                    this.names.add(strLine);
                }
                in.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Model.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void run() {
        long sleepLength = this.model.getSettings().getRandomMinutes() * 1000 * 60;
        try {
            Thread.sleep(sleepLength);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Randomiser.class.getName()).log(Level.SEVERE, null, ex);
        }
        block8: while (true) {
            if (!this.model.getSettings().isRandomEnabled()) {
                continue;
            }
            this.loadNameList();
            String[] namesList = this.randomNames();
            if (namesList.length > 0) {
                Vector[] classesList = null;
                if (this.model.getSettings().isRandomDeviceClass()) {
                    classesList = this.randomDeviceClass();
                }
                int i = 0;
                while (true) {
                    if (i >= namesList.length) continue block8;
                    if (!this.model.getSensor(i).isLocked()) {
                        int major = 0;
                        int minor = 0;
                        if (this.model.getSettings().isRandomDeviceClass()) {
                            major = (Integer)classesList[0].get(i);
                            minor = (Integer)classesList[1].get(i);
                        }
                        try {
                            if (this.model.getSettings().isRandomDeviceClass()) {
                                this.model.setLocalDeviceClass(i, major, minor);
                            }
                            this.model.setLocalDeviceName(i, namesList[i]);
                            this.model.resetTableData();
                            this.view.fireMainTableDataChanged();
                            this.model.applyTableData();
                            this.view.fireSmallTableDataChanged();
                            this.view.updateSensors();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Randomiser.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    try {
                        Thread.sleep(sleepLength / (long)this.model.getNoOfDevices());
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Randomiser.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    ++i;
                }
            }
            try {
                Thread.sleep(sleepLength);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Randomiser.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    public Vector[] randomDeviceClass() {
        Vector<Integer> majorList = new Vector<Integer>();
        Vector<Integer> minorList = new Vector<Integer>();
        for (int i = 0; i < this.model.getNoOfDevices(); ++i) {
            Random generator = new Random();
            int noOfMajor = this.model.getMajorClassesList().length;
            int r = generator.nextInt(noOfMajor);
            String majorName = this.model.getMajorClassesList()[r];
            int major = this.model.getMajorClassInt(majorName);
            int noOfMinor = this.model.getMinorClassesList(majorName).length;
            r = generator.nextInt(noOfMinor);
            String minorName = this.model.getMinorClassesList(majorName)[r];
            int minor = this.model.getMinorClassInt(majorName, minorName);
            minorList.add(minor);
            majorList.add(major);
        }
        Vector[] majorMinor = new Vector[]{majorList, minorList};
        return majorMinor;
    }

    public String[] randomNames() {
        Random generator = new Random();
        HashSet randomNumbersName = new HashSet();
        for (int i = 0; i < this.model.getNoOfDevices(); ++i) {
            Boolean unique = false;
            while (!unique.booleanValue()) {
                int oldSize = randomNumbersName.size();
                int r = generator.nextInt(this.names.size());
                randomNumbersName.add(this.names.get(r));
                int newSize = randomNumbersName.size();
                if (newSize <= oldSize) continue;
                unique = true;
            }
        }
        return randomNumbersName.toArray(new String[this.model.getNoOfDevices()]);
    }
}

