/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgModel.Modules;

import bluepot.pkgModel.AttackData.AttackModule;
import bluepot.pkgModel.Model;
import bluepot.pkgModel.ObserverMessage;
import com.intel.bluetooth.BlueCoveImpl;
import java.io.IOException;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRegistrationException;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;

public class L2CAPServer
extends Observable
implements Runnable {
    private int id;
    private Object dongleID;
    private Model model;
    private AttackModule attackModule;
    private boolean running = false;
    private boolean isStopped = false;

    public boolean isRunning() {
        return this.running;
    }

    public L2CAPServer(Model model, int id, Object dongleID, AttackModule attackModule) {
        this.id = id;
        this.dongleID = dongleID;
        this.model = model;
        this.attackModule = attackModule;
    }

    private Connection keepOpeningConnection(String url) {
        Connection connection;
        try {
            connection = Connector.open((String)url);
        }
        catch (ServiceRegistrationException ex) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex1) {
                Logger.getLogger(L2CAPServer.class.getName()).log(Level.SEVERE, null, ex1);
            }
            connection = this.keepOpeningConnection(url);
        }
        catch (IOException ex) {
            System.out.println("serious error");
            return null;
        }
        return connection;
    }

    public void run() {
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BlueCoveImpl.setThreadBluetoothStackID((Object)this.dongleID);
        this.setChanged();
        this.notifyObservers(new ObserverMessage(this.id, "[L2CAP] Server starting.."));
        UUID L2CAP = new UUID(256L);
        String url = "btl2cap://localhost:" + L2CAP;
        L2CAPConnectionNotifier service = null;
        service = (L2CAPConnectionNotifier)this.keepOpeningConnection(url);
        this.setChanged();
        this.notifyObservers(new ObserverMessage(this.id, "[L2CAP] Server started"));
        this.running = true;
        while (!this.isStopped) {
            L2CAPConnection con = null;
            try {
                con = service.acceptAndOpen();
            }
            catch (IOException ex) {
                Logger.getLogger(L2CAPServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.setChanged();
            try {
                this.notifyObservers(new ObserverMessage(this.id, "[L2CAP] Received connection from " + RemoteDevice.getRemoteDevice((Connection)con)));
            }
            catch (IOException ex) {
                Logger.getLogger(L2CAPServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            byte[] buffer = new byte[80];
            int bytesread = 0;
            try {
                bytesread = con.receive(buffer);
            }
            catch (IOException ex) {
                Logger.getLogger(L2CAPServer.class.getName()).log(Level.SEVERE, null, ex);
            }
            String received = new String(buffer, 0, bytesread);
            try {
                con.close();
            }
            catch (IOException ex) {
                Logger.getLogger(L2CAPServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

