/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgModel.Sensor;

import bluepot.pkgModel.AttackData.AttackData;
import bluepot.pkgModel.AttackData.AttackList;
import bluepot.pkgModel.AttackData.AttackModule;
import bluepot.pkgModel.ConfigureSensors.SensorTableRow;
import bluepot.pkgModel.Model;
import bluepot.pkgModel.Modules.L2CAPServer;
import bluepot.pkgModel.Modules.OBEXServer;
import bluepot.pkgModel.Modules.RFCOMMServer;
import com.intel.bluetooth.BlueCoveImpl;
import java.io.IOException;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;

public class Sensor
implements Runnable {
    private int id;
    private String deviceName;
    private Object dongleID;
    private Thread obexThread;
    private OBEXServer obexRunnable;
    private boolean running = false;
    private RFCOMMServer rfcommRunnable;
    private Thread rfcommThread;
    private L2CAPServer l2capRunnable;
    private Thread l2capThread;
    private boolean locked;
    private String address;
    private boolean OBEX = true;
    private boolean L2CAP = true;
    private boolean RFCOMM = true;
    private int major;
    private int minor;
    private boolean enabled = false;
    private int discoverable;
    private String friendlyName;
    private Model model;
    private AttackData attackData = new AttackData();

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isRunning() {
        return this.running;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public int getDiscoverable() {
        return this.discoverable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public int getIdNumber() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean isL2CAP() {
        return this.L2CAP;
    }

    public void setL2CAP(boolean L2CAP) {
        this.L2CAP = L2CAP;
    }

    public boolean isOBEX() {
        return this.OBEX;
    }

    public void setOBEX(boolean OBEX) {
        this.OBEX = OBEX;
    }

    public boolean isRFCOMM() {
        return this.RFCOMM;
    }

    public void setRFCOMM(boolean RFCOMM) {
        this.RFCOMM = RFCOMM;
    }

    public AttackData getAttackData() {
        return this.attackData;
    }

    public Sensor(int id, String deviceName, Model model) throws BluetoothStateException {
        this.id = id;
        this.deviceName = deviceName;
        this.model = model;
        this.constructor();
    }

    public Sensor(Object dongleID, String deviceName, Model model) throws BluetoothStateException {
        this.id = 0;
        this.dongleID = dongleID;
        this.deviceName = deviceName;
        this.model = model;
        this.constructor();
    }

    private void constructor() {
        AttackModule obexAttackModule = new AttackModule();
        obexAttackModule.add("connect", new AttackList());
        obexAttackModule.add("filercvd", new AttackList());
        obexAttackModule.add("timeout", new AttackList());
        obexAttackModule.add("get", new AttackList());
        obexAttackModule.add("setpath", new AttackList());
        obexAttackModule.add("delete", new AttackList());
        obexAttackModule.add("timeout", new AttackList());
        AttackModule l2capAttackModule = new AttackModule();
        AttackModule rfcommAttackModule = new AttackModule();
        rfcommAttackModule.add("connect", new AttackList());
        rfcommAttackModule.add("command", new AttackList());
        this.attackData.addModule("obexpush", obexAttackModule);
        this.attackData.addModule("rfcomm", rfcommAttackModule);
        this.attackData.addModule("l2cap", l2capAttackModule);
    }

    public void run() {
        if (this.id > 0) {
            BlueCoveImpl.setConfigProperty((String)"bluecove.deviceID", (String)Integer.toString(this.id));
            BlueCoveImpl.useThreadLocalBluetoothStack();
            try {
                this.dongleID = BlueCoveImpl.getThreadBluetoothStackID();
            }
            catch (BluetoothStateException ex) {
                // empty catch block
            }
        }
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BlueCoveImpl.setThreadBluetoothStackID((Object)this.dongleID);
        try {
            BlueCoveImpl.useThreadLocalBluetoothStack();
            this.friendlyName = LocalDevice.getLocalDevice().getFriendlyName();
            this.discoverable = LocalDevice.getLocalDevice().getDiscoverable();
            this.major = LocalDevice.getLocalDevice().getDeviceClass().getMajorDeviceClass();
            this.minor = LocalDevice.getLocalDevice().getDeviceClass().getMinorDeviceClass();
        }
        catch (BluetoothStateException ex) {
            this.model.log(org.apache.log4j.Level.FATAL, "BluetoothStateException id: " + this.id + "\n" + "deviceName: " + this.deviceName + "\n" + "dongleId: " + this.dongleID);
            BlueCoveImpl.shutdownThreadBluetoothStack();
            BlueCoveImpl.shutdown();
            System.out.println(ex.toString());
            System.out.println("boo2");
            System.exit(1);
        }
        catch (Exception ex) {
            this.model.log(org.apache.log4j.Level.FATAL, "something terrible happened");
            BlueCoveImpl.shutdownThreadBluetoothStack();
            BlueCoveImpl.shutdown();
            System.out.println("boo1");
            System.exit(1);
        }
        try {
            this.address = LocalDevice.getLocalDevice().getBluetoothAddress();
        }
        catch (BluetoothStateException ex) {
            Logger.getLogger(Sensor.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.model.updateTableRow(this.id);
        this.running = true;
    }

    public void applySettings(SensorTableRow sensorTableRow) {
        this.setFriendlyDeviceName(sensorTableRow.getFriendlyName());
        this.setMajor(sensorTableRow.getMajor());
        this.setMinor(sensorTableRow.getMinor());
        this.setDeviceClass(this.major, this.minor);
        this.setDiscoverable(sensorTableRow.getDiscoverable());
        this.setLocked(sensorTableRow.isLocked());
        this.setOBEX(sensorTableRow.isOBEX());
        this.setRFCOMM(sensorTableRow.isRFCOMM());
        this.setL2CAP(sensorTableRow.isL2CAP());
        this.model.updateTableRow(this.id);
    }

    public void updateSettings(SensorTableRow sensorTableRow) {
        if (this.friendlyName.isEmpty() || !this.friendlyName.equals(sensorTableRow.getFriendlyName())) {
            // empty if block
        }
        this.setFriendlyDeviceName(sensorTableRow.getFriendlyName());
        this.locked = sensorTableRow.isLocked();
        this.OBEX = sensorTableRow.isOBEX();
        this.RFCOMM = sensorTableRow.isRFCOMM();
        this.L2CAP = sensorTableRow.isL2CAP();
        boolean majorminor = false;
        if (this.major != sensorTableRow.getMajor()) {
            this.setMajor(sensorTableRow.getMajor());
            majorminor = true;
        }
        if (this.minor != sensorTableRow.getMinor()) {
            this.setMinor(sensorTableRow.getMinor());
            majorminor = true;
        }
        if (majorminor) {
            this.setDeviceClass(this.major, this.minor);
            majorminor = false;
        }
        if (this.discoverable != sensorTableRow.getDiscoverable()) {
            this.setDiscoverable(sensorTableRow.getDiscoverable());
        }
        this.model.updateTableRow(this.id);
    }

    public void startListeners(Observer view) {
        if (this.RFCOMM) {
            this.startRFCOMMServer(view);
            while (!this.rfcommRunnable.isRunning()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Sensor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (this.L2CAP) {
            this.startL2CAP(view);
            while (!this.l2capRunnable.isRunning()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Sensor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (this.OBEX) {
            this.startOBEXServer(view);
            while (!this.obexRunnable.isRunning()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Sensor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void startRFCOMMServer(Observer view) {
        this.rfcommRunnable = new RFCOMMServer(this.model, this.id, this.dongleID, this.attackData.getModule("rfcomm"));
        this.rfcommRunnable.addObserver(view);
        this.rfcommThread = new Thread(this.rfcommRunnable);
        this.rfcommThread.start();
    }

    public void startL2CAP(Observer view) {
        this.l2capRunnable = new L2CAPServer(this.model, this.id, this.dongleID, this.attackData.getModule("l2cap"));
        this.l2capRunnable.addObserver(view);
        this.l2capThread = new Thread(this.l2capRunnable);
        this.l2capThread.start();
    }

    public void startOBEXServer(Observer view) {
        this.obexRunnable = new OBEXServer(this.model, this.id, this.dongleID, this.attackData.getModule("obexpush"));
        this.obexRunnable.addObserver(view);
        this.obexThread = new Thread(this.obexRunnable);
        this.obexThread.start();
    }

    public String getLocalDeviceID() {
        return Integer.toString(this.id);
    }

    public String getLocalDeviceName() {
        return this.friendlyName;
    }

    public String getLocalDeviceVisibility() throws BluetoothStateException {
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BlueCoveImpl.setThreadBluetoothStackID((Object)this.dongleID);
        return Model.discoverableIntToString(LocalDevice.getLocalDevice().getDiscoverable());
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public void setDiscoverable(int i) {
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BlueCoveImpl.setThreadBluetoothStackID((Object)this.dongleID);
        this.discoverable = i;
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            if (!localDevice.setDiscoverable(10390323)) {
                System.out.println("weird error - please explain");
            }
        }
        catch (BluetoothStateException ex) {
            System.out.println("TRYING TO SET DISCOVERABLE ERROR - " + ex.toString());
            Logger.getLogger(Sensor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setFriendlyDeviceName(String s) {
        try {
            s = s.replaceAll("\\s", "\\ ");
            String cmd = "hciconfig hci" + this.deviceName + " name " + s;
            Process result = Runtime.getRuntime().exec(cmd);
            try {
                int fff = result.waitFor();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Sensor.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.friendlyName = s;
        }
        catch (IOException ex) {
            this.model.log(org.apache.log4j.Level.ERROR, "IOException Failed changing device " + this.id + "'s name to " + s);
        }
        this.model.log(org.apache.log4j.Level.INFO, "Changed device " + this.id + "'s name to " + s);
    }

    public void setDeviceClass(int major, int minor) {
        try {
            this.setMajor(major);
            this.setMinor(minor);
            int deviceClass = major + minor;
            String cmd = "hciconfig hci" + this.deviceName + " class 0x" + Integer.toString(deviceClass, 16).toUpperCase();
            Process result = Runtime.getRuntime().exec(cmd);
            try {
                int ffff = result.waitFor();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Sensor.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.model.log(org.apache.log4j.Level.INFO, "Changed device " + this.id + "'s class to " + Integer.toString(deviceClass));
        }
        catch (IOException ex) {
            Logger.getLogger(Sensor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

