/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.ControlPanel;

import bluepot.pkgModel.Config.Settings;
import bluepot.pkgModel.Model;
import bluepot.pkgView.View;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class Configuration
extends JPanel {
    Model model;
    View view;
    private final JFileChooser randomNameFileChooser;
    private final JFileChooser rcvdFolderChooser;
    private final JTextField randomTxtNameLocation;
    private final JTextField rcvdTxtDirectory;
    private final JCheckBox randomChckEnabled;
    private final JTextField randomTxtEvery;
    private final JCheckBox rcvdChkShouldEmail;
    private final JTextField rcvdTxtTo;
    private final JTextField rcvdTxtFrom;
    private final JTextField rcvdTxtSubject;
    private final JTextField emailTxtHost;
    private final JTextField emailTxtUser;
    private final JPasswordField emailTxtPassword;
    private final JTextField emailTxtPort;
    private final JCheckBox randomChckDeviceClass;
    private final JTextArea txtObexGetResponse;
    private final JTextField txtRfcommIdResponse;
    private final JTextField txtRfcommPhoneBookResponse;
    private final JTextField txtRfcommSMSResponse;

    public Configuration(View view, Model model) {
        super(new MigLayout("wrap 1"));
        this.model = model;
        this.view = view;
        Settings settings = model.getSettings();
        JPanel randomPanel = new JPanel(new MigLayout("wrap 2"));
        randomPanel.setBorder(new TitledBorder("Randomiser"));
        JLabel randomDesc = new JLabel("The randomiser will randomly alter a sensors state when the user specifies. Device name, class and other features will change, unless they are \"locked\" to the user's specification");
        JLabel randomEnable = new JLabel("Enable randomiser");
        JLabel randomDeviceClass = new JLabel("Randomise Device Classess");
        JLabel randomNameLocation = new JLabel("Random Name List File");
        JLabel randomEvery = new JLabel("Randomise sensors every ");
        JLabel randomMinutes = new JLabel(" minutes");
        this.randomChckEnabled = new JCheckBox();
        this.randomChckEnabled.setSelected(settings.isRandomEnabled());
        this.randomChckDeviceClass = new JCheckBox();
        this.randomChckDeviceClass.setSelected(settings.isRandomDeviceClass());
        this.randomTxtNameLocation = new JTextField(35);
        this.randomTxtNameLocation.setText(settings.getRandomNameFolder());
        this.randomTxtNameLocation.setEditable(false);
        JButton randomLoadName = new JButton("Load..");
        randomLoadName.addActionListener(new loadActionListener());
        this.randomTxtEvery = new JTextField(5);
        this.randomTxtEvery.setText(Integer.toString(settings.getRandomMinutes()));
        this.randomNameFileChooser = new JFileChooser(settings.getRandomNameFolder());
        randomPanel.add((Component)randomDesc, "span 2");
        randomPanel.add(randomEnable);
        randomPanel.add(this.randomChckEnabled);
        randomPanel.add(randomDeviceClass);
        randomPanel.add(this.randomChckDeviceClass);
        randomPanel.add(randomNameLocation);
        randomPanel.add((Component)this.randomTxtNameLocation, "split 2");
        randomPanel.add(randomLoadName);
        randomPanel.add(randomEvery);
        randomPanel.add((Component)this.randomTxtEvery, "split 2");
        randomPanel.add(randomMinutes);
        this.add(randomPanel);
        JPanel rcvdFiles = new JPanel(new MigLayout("wrap 2"));
        rcvdFiles.setBorder(new TitledBorder("System Settings"));
        JLabel rcvdDesc = new JLabel("Set up how files are dealt with when they are recieved");
        JLabel rcvdDirectory = new JLabel("Recieved Files Directory");
        JLabel rcvdMaxFileSize = new JLabel("Maximum File Size");
        JLabel rcvdKbytes = new JLabel("Kilobytes");
        JLabel rcvdShouldEmailFiles = new JLabel("Forward files recieved via email?");
        JLabel rcvdEmailTo = new JLabel("To");
        JLabel rcvdEmailFrom = new JLabel("From");
        JLabel rcvdEmailSubject = new JLabel("Subject");
        this.rcvdTxtDirectory = new JTextField(35);
        this.rcvdTxtDirectory.setText(settings.getSaveFolder());
        this.rcvdTxtDirectory.setEditable(false);
        this.rcvdFolderChooser = new JFileChooser(settings.getSaveFolder());
        this.rcvdFolderChooser.setFileSelectionMode(1);
        JButton rcvdBtnDirectory = new JButton("Choose..");
        rcvdBtnDirectory.addActionListener(new chooseActionListener());
        this.rcvdChkShouldEmail = new JCheckBox();
        this.rcvdChkShouldEmail.setSelected(settings.isEmailEnabled());
        this.rcvdTxtTo = new JTextField(20);
        this.rcvdTxtTo.setText(settings.getEmailTo());
        this.rcvdTxtFrom = new JTextField(20);
        this.rcvdTxtFrom.setText(settings.getEmailFrom());
        this.rcvdTxtSubject = new JTextField(25);
        this.rcvdTxtSubject.setText(settings.getEmailSubject());
        ImageIcon icnExclam = new ImageIcon("icons/exclamation.png");
        ImageIcon icnTick = new ImageIcon("icons/tick.png");
        rcvdFiles.add((Component)rcvdDesc, "span 2");
        rcvdFiles.add(rcvdDirectory);
        rcvdFiles.add((Component)this.rcvdTxtDirectory, "split 2");
        rcvdFiles.add(rcvdBtnDirectory);
        rcvdFiles.add(rcvdShouldEmailFiles);
        rcvdFiles.add(this.rcvdChkShouldEmail);
        rcvdFiles.add(rcvdEmailTo);
        rcvdFiles.add(this.rcvdTxtTo);
        rcvdFiles.add(rcvdEmailFrom);
        rcvdFiles.add(this.rcvdTxtFrom);
        rcvdFiles.add(rcvdEmailSubject);
        rcvdFiles.add(this.rcvdTxtSubject);
        this.add(rcvdFiles);
        JPanel emailConfig = new JPanel(new MigLayout("wrap 2"));
        emailConfig.setBorder(new TitledBorder("Email Server"));
        JLabel emailDesc = new JLabel("Configure SMTP server to send emails with. Required only to send attachments by email");
        JLabel emailHost = new JLabel("SMTP Host");
        JLabel emailPort = new JLabel(":");
        JLabel emailUsername = new JLabel("SMTP Username");
        JLabel emailPassword = new JLabel("SMTP Password");
        this.emailTxtHost = new JTextField(20);
        this.emailTxtHost.setText(settings.getSmtpHost());
        this.emailTxtUser = new JTextField(15);
        this.emailTxtUser.setText(settings.getSmtpUser());
        this.emailTxtPassword = new JPasswordField(15);
        this.emailTxtPassword.setText(settings.getSmtpPassword());
        this.emailTxtPort = new JTextField(4);
        this.emailTxtPort.setText(Integer.toString(settings.getSmtpPort()));
        emailConfig.add((Component)emailDesc, "span 2");
        emailConfig.add(emailHost);
        emailConfig.add((Component)this.emailTxtHost, "split 3");
        emailConfig.add(emailPort);
        emailConfig.add(this.emailTxtPort);
        emailConfig.add(emailUsername);
        emailConfig.add(this.emailTxtUser);
        emailConfig.add(emailPassword);
        emailConfig.add(this.emailTxtPassword);
        this.add(emailConfig);
        JPanel otherConfig = new JPanel(new MigLayout("wrap 2"));
        otherConfig.setBorder(new TitledBorder("Exploit Responses"));
        JLabel obexGetResponse = new JLabel("OBEX Get Response");
        this.txtObexGetResponse = new JTextArea(5, 60);
        this.txtObexGetResponse.setText(model.getSettings().getRespOBEXGet());
        otherConfig.add((Component)obexGetResponse, "wrap");
        otherConfig.add((Component)this.txtObexGetResponse, "wrap");
        JLabel rfcommIdResponse = new JLabel("RFCOMM Manufacturer Response: ");
        this.txtRfcommIdResponse = new JTextField(30);
        this.txtRfcommIdResponse.setText(model.getSettings().getRespID());
        otherConfig.add(rfcommIdResponse);
        otherConfig.add(this.txtRfcommIdResponse);
        JLabel rfcommPhonebookResponse = new JLabel("RFCOMM Model Response: ");
        this.txtRfcommPhoneBookResponse = new JTextField(30);
        this.txtRfcommPhoneBookResponse.setText(model.getSettings().getRespPhone());
        otherConfig.add(rfcommPhonebookResponse);
        otherConfig.add(this.txtRfcommPhoneBookResponse);
        JLabel rfcommSMSResponse = new JLabel("RFCOMM Revision Response: ");
        this.txtRfcommSMSResponse = new JTextField(30);
        this.txtRfcommSMSResponse.setText(model.getSettings().getRespSMS());
        otherConfig.add(rfcommSMSResponse);
        otherConfig.add(this.txtRfcommSMSResponse);
        this.add(otherConfig);
        JButton saveSetting = new JButton("Save Settings");
        saveSetting.addActionListener(new saveActionListener());
        JButton resetSetting = new JButton("Reset Settings");
        this.add((Component)saveSetting, "split 2");
    }

    public class saveActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            int number = Integer.parseInt(Configuration.this.randomTxtEvery.getText());
            Configuration.this.model.getSettings().setEmailEnabled(Configuration.this.rcvdChkShouldEmail.isSelected());
            Configuration.this.model.getSettings().setEmailFrom(Configuration.this.rcvdTxtFrom.getText());
            Configuration.this.model.getSettings().setEmailSubject(Configuration.this.rcvdTxtSubject.getText());
            Configuration.this.model.getSettings().setEmailTo(Configuration.this.rcvdTxtTo.getText());
            Configuration.this.model.getSettings().setRandomEnabled(Configuration.this.randomChckEnabled.isEnabled());
            Configuration.this.model.getSettings().setRandomMinutes(number);
            Configuration.this.model.getSettings().setRandomNameFolder(Configuration.this.randomTxtNameLocation.getText());
            Configuration.this.model.getSettings().setSaveFolder(Configuration.this.rcvdTxtDirectory.getText());
            Configuration.this.model.getSettings().setSmtpHost(Configuration.this.emailTxtHost.getText());
            Configuration.this.model.getSettings().setSmtpPassword(new String(Configuration.this.emailTxtPassword.getPassword()));
            Configuration.this.model.getSettings().setSmtpUser(Configuration.this.emailTxtUser.getText());
            Configuration.this.model.getSettings().setRandomDeviceClass(Configuration.this.randomChckDeviceClass.isSelected());
            Configuration.this.model.getSettings().setSmtpPort(Integer.parseInt(Configuration.this.emailTxtPort.getText()));
            Configuration.this.model.getSettings().setRespID(Configuration.this.txtRfcommIdResponse.getText());
            Configuration.this.model.getSettings().setRespOBEXGet(Configuration.this.txtObexGetResponse.getText());
            Configuration.this.model.getSettings().setRespPhone(Configuration.this.txtRfcommPhoneBookResponse.getText());
            Configuration.this.model.getSettings().setRespSMS(Configuration.this.txtRfcommSMSResponse.getText());
            Configuration.this.model.saveConfiguration();
        }
    }

    public class chooseActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            int returnVal = Configuration.this.rcvdFolderChooser.showOpenDialog(Configuration.this);
            if (returnVal == 0) {
                Configuration.this.rcvdTxtDirectory.setText(Configuration.this.rcvdFolderChooser.getSelectedFile().toString());
            }
        }
    }

    public class loadActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            int returnVal = Configuration.this.randomNameFileChooser.showOpenDialog(Configuration.this);
            if (returnVal == 0) {
                Configuration.this.randomTxtNameLocation.setText(Configuration.this.randomNameFileChooser.getSelectedFile().toString());
            }
        }
    }
}

