/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.Sensors.Overview;

import bluepot.pkgModel.Model;
import bluepot.pkgView.Sensors.Overview.ChangeMajorClassListener;
import bluepot.pkgView.Sensors.Overview.DevicesTableModel;
import bluepot.pkgView.Sensors.Overview.JTableSensors;
import bluepot.pkgView.Sensors.Overview.RowEditorModel;
import bluepot.pkgView.View;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTitledPanel;

public class OverviewConfig
extends JPanel {
    int sensorId;
    View view;
    Model model;
    private DevicesTableModel tableModel;
    private final JComboBox cmbMajorClass;
    private RowEditorModel rowEditorModel;
    private JButton btnSave = new JButton("Save & Apply");
    private JButton btnReset = new JButton("Reset");
    private final JComboBox cmbVisibleList;
    private final JTableSensors devicesTable;

    public OverviewConfig(int sensorId, View view, Model model) {
        this.setLayout(new MigLayout("wrap 1"));
        this.sensorId = sensorId;
        this.view = view;
        this.model = model;
        Font smallFont = new Font("Arial", 0, 9);
        this.rowEditorModel = new RowEditorModel(model);
        JPanel deviceJPanelContent = new JPanel(new MigLayout("wrap 3"));
        this.tableModel = new DevicesTableModel(model, view);
        this.devicesTable = new JTableSensors(view, this.tableModel, this.rowEditorModel);
        this.devicesTable.setAutoResizeMode(4);
        this.devicesTable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.devicesTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.devicesTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.devicesTable.getColumnModel().getColumn(5).setPreferredWidth(5);
        this.devicesTable.setColumnSelectionAllowed(false);
        this.devicesTable.setDragEnabled(false);
        this.devicesTable.setCellSelectionEnabled(false);
        this.devicesTable.setRowSelectionAllowed(true);
        JScrollPane scrollPane = new JScrollPane(this.devicesTable);
        this.devicesTable.setMinimumSize(new Dimension(900, 20 + model.getNoOfDevices() * 19));
        this.devicesTable.setMaximumSize(new Dimension(900, 20 + model.getNoOfDevices() * 19));
        scrollPane.setMaximumSize(new Dimension(900, 20 + model.getNoOfDevices() * 19));
        scrollPane.setMinimumSize(new Dimension(900, 20 + model.getNoOfDevices() * 19));
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        TableColumn visibilityColumn = this.devicesTable.getColumnModel().getColumn(2);
        String[] visibleList = new String[]{"Full", "Limited", "Invisible"};
        this.cmbVisibleList = new JComboBox<String>(visibleList);
        visibilityColumn.setCellEditor(new DefaultCellEditor(this.cmbVisibleList));
        TableColumn majorColumn = this.devicesTable.getColumnModel().getColumn(3);
        String[] majorClassesList = model.getMajorClassesList();
        this.cmbMajorClass = new JComboBox<String>(majorClassesList);
        this.cmbMajorClass.addActionListener(new ChangeMajorClassListener(model, this));
        majorColumn.setCellEditor(new DefaultCellEditor(this.cmbMajorClass));
        deviceJPanelContent.add((Component)scrollPane, "span 3, w 100%");
        deviceJPanelContent.add(this.btnSave);
        deviceJPanelContent.add(this.btnReset);
        JXTitledPanel configureSensors = new JXTitledPanel("Configure Sensors");
        configureSensors.add((Component)deviceJPanelContent);
        this.add((Component)configureSensors, "width 100%");
    }

    public DevicesTableModel getTableModel() {
        return this.tableModel;
    }

    public void setMinorClasses(String[] minorClasses) {
        TableColumn minorColumn = this.devicesTable.getColumnModel().getColumn(4);
    }

    public JButton getBtnReset() {
        return this.btnReset;
    }

    public JButton getBtnSave() {
        return this.btnSave;
    }
}

