/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.StatFactory;

import bluepot.pkgModel.AttackData.Attack;
import bluepot.pkgModel.AttackData.AttackData;
import bluepot.pkgModel.AttackData.AttackList;
import bluepot.pkgModel.AttackData.AttackModule;
import bluepot.pkgModel.Model;
import bluepot.pkgView.StatFactory.ListManager;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

public class GraphOverall {
    private Minute startTime;
    private Model model;
    private Millisecond biggestTime;
    private TimeSeries dataOBEX = new TimeSeries((Comparable)((Object)"OBEX"));
    private TimeSeries dataL2CAP = new TimeSeries((Comparable)((Object)"L2CAP"));
    private TimeSeries dataRFCOMM = new TimeSeries((Comparable)((Object)"RFCOMM"));
    private ListManager listManager;

    public GraphOverall(Model model, ListManager listManager) {
        this.startTime = new Minute(Calendar.getInstance().getTime());
        this.model = model;
        this.listManager = listManager;
        this.biggestTime = new Millisecond(new Date(0L));
    }

    public void updateData() {
        Millisecond tmpBiggestTime = this.biggestTime;
        AttackData[] attackDataStore = new AttackData[this.model.getNoOfDevices()];
        for (int i = 0; i < this.model.getNoOfDevices(); ++i) {
            attackDataStore[i] = this.model.readAttackData(i);
        }
        for (int i = 0; i < attackDataStore.length; ++i) {
            String[] listOfModules = null;
            listOfModules = new String[attackDataStore[i].getListOfAttacks().length];
            listOfModules = attackDataStore[i].getListOfAttacks();
            for (int j = 0; j < listOfModules.length; ++j) {
                String[] listOfAttacks = null;
                AttackModule attackModule = attackDataStore[i].getModule(listOfModules[j]);
                listOfAttacks = new String[attackModule.getListOfAttacks().length];
                listOfAttacks = attackModule.getListOfAttacks();
                if (listOfAttacks.length <= 0) continue;
                for (int k = 0; k < listOfAttacks.length; ++k) {
                    AttackList attackList = attackModule.get(listOfAttacks[k]);
                    List<Attack> tmpArrayList = Collections.synchronizedList(attackList.getArrayList());
                    for (Attack attack : tmpArrayList) {
                        int plusone;
                        TimeSeriesDataItem tmp;
                        Date d = attack.getTime();
                        Minute rtp = new Minute(d);
                        Millisecond comp = new Millisecond(d);
                        if (comp.compareTo((Object)tmpBiggestTime) > 0) {
                            tmpBiggestTime = comp;
                        }
                        if (comp.compareTo((Object)this.biggestTime) <= 0) continue;
                        this.listManager.addAttack(attack);
                        if (listOfModules[j].equals("obexpush")) {
                            if (this.dataOBEX.getDataItem((RegularTimePeriod)rtp) == null) {
                                this.dataOBEX.add((RegularTimePeriod)rtp, 1.0);
                                continue;
                            }
                            tmp = this.dataOBEX.getDataItem((RegularTimePeriod)rtp);
                            plusone = tmp.getValue().intValue() + 1;
                            this.dataOBEX.addOrUpdate((RegularTimePeriod)rtp, (double)plusone);
                            continue;
                        }
                        if (listOfModules[j].equals("l2cap")) {
                            if (this.dataL2CAP.getDataItem((RegularTimePeriod)rtp) == null) {
                                this.dataL2CAP.add((RegularTimePeriod)rtp, 1.0);
                                continue;
                            }
                            tmp = this.dataL2CAP.getDataItem((RegularTimePeriod)rtp);
                            plusone = tmp.getValue().intValue() + 1;
                            this.dataL2CAP.addOrUpdate((RegularTimePeriod)rtp, (double)plusone);
                            continue;
                        }
                        if (!listOfModules[j].equals("rfcomm")) continue;
                        if (this.dataRFCOMM.getDataItem((RegularTimePeriod)rtp) == null) {
                            this.dataRFCOMM.add((RegularTimePeriod)rtp, 1.0);
                            continue;
                        }
                        tmp = this.dataRFCOMM.getDataItem((RegularTimePeriod)rtp);
                        plusone = tmp.getValue().intValue() + 1;
                        this.dataRFCOMM.addOrUpdate((RegularTimePeriod)rtp, (double)plusone);
                    }
                }
            }
        }
        Minute endTime = new Minute(Calendar.getInstance().getTime());
        if (this.dataOBEX.getDataItem((RegularTimePeriod)endTime) == null) {
            this.dataOBEX.add((RegularTimePeriod)endTime, 0.0);
        }
        if (this.dataL2CAP.getDataItem((RegularTimePeriod)endTime) == null) {
            this.dataL2CAP.add((RegularTimePeriod)endTime, 0.0);
        }
        if (this.dataRFCOMM.getDataItem((RegularTimePeriod)endTime) == null) {
            this.dataRFCOMM.add((RegularTimePeriod)endTime, 0.0);
        }
        this.biggestTime = tmpBiggestTime;
    }

    public JFreeChart getChart() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(this.dataOBEX);
        dataset.addSeries(this.dataL2CAP);
        dataset.addSeries(this.dataRFCOMM);
        JFreeChart rtn = ChartFactory.createTimeSeriesChart((String)"Overall Activity", (String)"Time", (String)"Hits", (XYDataset)dataset, (boolean)true, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)rtn.getPlot();
        XYItemRenderer r = plot.getRenderer();
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rtn.setBorderVisible(false);
        rtn.setBackgroundPaint(null);
        rtn.setAntiAlias(true);
        return rtn;
    }
}

