/*
 * Decompiled with CFR 0.152.
 */
package bluepot.pkgView.StatFactory;

import bluepot.pkgModel.AttackData.Attack;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

public class ListManager {
    HashMap<String, Integer> attackerInstances = new HashMap();
    Stack recentAttackers = new Stack();

    public void addAttack(Attack attack) {
        this.recentAttackers.push(new AttackerAndTime(attack.getAttacker(), attack.getTime().getTime()));
        String attacker = attack.getAttacker();
        if (this.attackerInstances.get(attacker) == null) {
            this.attackerInstances.put(attack.getAttacker(), 1);
        } else {
            int attackerCount = this.attackerInstances.get(attack.getAttacker());
            this.attackerInstances.put(attack.getAttacker(), ++attackerCount);
        }
    }

    public int getNoOfAttackers() {
        return this.attackerInstances.size();
    }

    public int getNoOfAttacks() {
        return this.recentAttackers.size();
    }

    public String getRecentAttackers(int count) {
        int i;
        Stack temp = (Stack)this.recentAttackers.clone();
        String rtn = "<html><ol>";
        for (i = 0; i < count && temp.size() > 0; ++i) {
            AttackerAndTime data = (AttackerAndTime)temp.pop();
            rtn = rtn + "<li>" + data.getAttacker() + "</li>";
        }
        while (i < count) {
            rtn = rtn + "<li>-               </li>";
            ++i;
        }
        rtn = rtn + "</ol></html>";
        return rtn;
    }

    public String getTopVolumeAttackers(int count) {
        int i;
        LinkedHashMap sortedData = new LinkedHashMap();
        sortedData = (LinkedHashMap)ListManager.sortByValue(this.attackerInstances);
        Iterator it = sortedData.keySet().iterator();
        String rtn = "<html><ol>";
        for (i = 0; it.hasNext() && i < count; ++i) {
            String attacker = (String)it.next();
            rtn = rtn + "<li>" + attacker + "</li>";
        }
        while (i < count) {
            rtn = rtn + "<li>-               </li>";
            ++i;
        }
        rtn = rtn + "</ol></html>";
        return rtn;
    }

    static Map sortByValue(Map map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static class ValueComparer
    implements Comparator {
        private Map _data = null;

        public ValueComparer(Map data) {
            this._data = data;
        }

        public int compare(Object o1, Object o2) {
            String e1 = (String)this._data.get(o1);
            String e2 = (String)this._data.get(o2);
            return e1.compareTo(e2);
        }
    }

    private class AttackerAndTime {
        String attacker;
        Long time;

        public AttackerAndTime(String attacker, Long time) {
            this.attacker = attacker;
            this.time = time;
        }

        public String getAttacker() {
            return this.attacker;
        }

        public Long getTime() {
            return this.time;
        }
    }
}

