/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.impl;

import com.paterva.maltego.graph.table.io.api.PropertyToColumnMap;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ArrayUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PropertyToColumnMapImpl
implements PropertyToColumnMap {
    private Map<Integer, PropertyDescriptor> _columnPropertyMap = new LinkedHashMap<Integer, PropertyDescriptor>();
    private PropertyChangeSupport _support = new PropertyChangeSupport(this);

    @Override
    public void put(int n, PropertyDescriptor propertyDescriptor) {
        if (this.contains(n)) {
            this.setProperty(n, propertyDescriptor);
        } else {
            this._columnPropertyMap.put(n, propertyDescriptor);
        }
        this.firePropertyChanged("mappingChanged", null, null);
    }

    @Override
    public void remove(int ... nArray) {
        boolean bl = false;
        for (int n : nArray) {
            PropertyDescriptor propertyDescriptor = this._columnPropertyMap.remove(n);
            bl = bl || propertyDescriptor != null;
        }
        if (bl) {
            this.firePropertyChanged("mappingChanged", null, null);
        }
    }

    @Override
    public boolean contains(int n) {
        return this._columnPropertyMap.containsKey(n);
    }

    @Override
    public int[] getColumns() {
        Integer[] integerArray = this._columnPropertyMap.keySet().toArray(new Integer[this._columnPropertyMap.size()]);
        return ArrayUtilities.toPrimitiveArray((Integer[])integerArray);
    }

    @Override
    public int getColumnCount() {
        return this._columnPropertyMap.size();
    }

    private void setProperty(int n, PropertyDescriptor propertyDescriptor) {
        Integer n2 = n;
        PropertyDescriptor propertyDescriptor2 = this._columnPropertyMap.get(n2);
        if (!(propertyDescriptor2 == propertyDescriptor || propertyDescriptor2 != null && propertyDescriptor2.equals(propertyDescriptor))) {
            Integer n3 = this.getColumn(propertyDescriptor);
            if (n3 != null) {
                this._columnPropertyMap.put(n3, propertyDescriptor2);
            }
            this._columnPropertyMap.put(n2, propertyDescriptor);
        }
    }

    private Integer getColumn(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            return null;
        }
        Integer n = null;
        Set<Map.Entry<Integer, PropertyDescriptor>> set = this._columnPropertyMap.entrySet();
        for (Map.Entry<Integer, PropertyDescriptor> entry : set) {
            if (!propertyDescriptor.equals(entry.getValue())) continue;
            n = entry.getKey();
            return n;
        }
        return null;
    }

    @Override
    public PropertyDescriptor getProperty(int n) {
        if (!this.contains(n)) {
            throw new IllegalArgumentException("Column not mapped.");
        }
        return this._columnPropertyMap.get(n);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._support.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        this._support.firePropertyChange(string, object, object2);
    }
}

