/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryEvent;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryListener;

public abstract class EditorViewFactory {
    private static List<Factory> viewFactoryFactories = new ArrayList<Factory>(3);
    private final JTextComponent component;
    private final Document doc;
    private ListenerList<EditorViewFactoryListener> listenerList = new ListenerList();

    public static void registerFactory(Factory factory) {
        viewFactoryFactories.add(factory);
        Collections.sort(viewFactoryFactories, new Comparator<Factory>(){

            @Override
            public int compare(Factory f0, Factory f1) {
                return f0.importance() - f1.importance();
            }
        });
    }

    public static List<Factory> factories() {
        return Collections.unmodifiableList(viewFactoryFactories);
    }

    protected EditorViewFactory(JTextComponent component) {
        assert (component != null) : "Null component prohibited";
        this.component = component;
        this.doc = component.getDocument();
    }

    protected final JTextComponent textComponent() {
        return this.component;
    }

    protected final Document document() {
        return this.doc;
    }

    protected void initProperties(Map<String, Object> properties) {
    }

    public abstract void restart(int var1, int var2);

    public abstract int nextViewStartOffset(int var1);

    public abstract EditorView createView(int var1, int var2);

    public abstract int viewEndOffset(int var1, int var2);

    public abstract void finish();

    public void addEditorViewFactoryListener(EditorViewFactoryListener listener) {
        this.listenerList.add((EventListener)listener);
    }

    public void removeEditorViewFactoryListener(EditorViewFactoryListener listener) {
        this.listenerList.remove((EventListener)listener);
    }

    protected void fireEvent(List<Change> changes) {
        this.fireEvent(changes, 0);
    }

    protected void fireEvent(List<Change> changes, int priority) {
        EditorViewFactoryEvent evt = new EditorViewFactoryEvent(this, changes, priority);
        for (EditorViewFactoryListener listener : this.listenerList.getListeners()) {
            listener.viewFactoryChanged(evt);
        }
    }

    public static Change createChange(int startOffset, int endOffset) {
        return new Change(startOffset, endOffset);
    }

    public static List<Change> createSingleChange(int startOffset, int endOffset) {
        return Collections.singletonList(EditorViewFactory.createChange(startOffset, endOffset));
    }

    public static interface Factory {
        public EditorViewFactory createEditorViewFactory(JTextComponent var1);

        public int importance();
    }

    public static final class Change {
        private int startOffset;
        private int endOffset;

        Change(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String toString() {
            return "<" + this.getStartOffset() + "," + this.getEndOffset() + ">";
        }
    }
}

