/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public final class ViewUtils {
    private static final double ROUND_FRACTION = 8.0;
    private static final Logger LOG = Logger.getLogger(ViewUtils.class.getName());

    private ViewUtils() {
    }

    public static Rectangle2D.Double shape2Bounds(Shape s) {
        Rectangle2D r = s instanceof Rectangle2D ? (Rectangle2D)s : s.getBounds2D();
        return new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static Rectangle2D.Double shape2RelBounds(Shape s, double x, double y) {
        Rectangle2D.Double r = ViewUtils.shape2Bounds(s);
        r.x = x - r.x;
        r.y = y - r.y;
        return r;
    }

    public static Rectangle2D shapeAsRect(Shape s) {
        Rectangle2D r = s instanceof Rectangle2D ? (Rectangle2D)s : s.getBounds2D();
        return r;
    }

    public static Rectangle toRect(Rectangle2D r2d) {
        Rectangle r = new Rectangle();
        r.setRect(r2d);
        return r;
    }

    public static void fillRect(Graphics2D g, Rectangle2D r) {
        g.fillRect((int)r.getX(), (int)r.getY(), (int)Math.ceil(r.getWidth()), (int)Math.ceil(r.getHeight()));
    }

    public static void applyBackgroundAttributes(AttributeSet attributes, Color defaultBackground, Graphics2D graphics) {
        Color c;
        if (attributes != null && (c = (Color)attributes.getAttribute(StyleConstants.Background)) != null) {
            defaultBackground = c;
        }
        graphics.setColor(defaultBackground);
    }

    public static void applyForegroundAttributes(AttributeSet attributes, Font defaultFont, Color defaultForeground, Graphics2D graphics) {
        if (attributes != null) {
            Color c = (Color)attributes.getAttribute(StyleConstants.Foreground);
            if (c != null) {
                defaultForeground = c;
            }
            defaultFont = ViewUtils.getFont(attributes, defaultFont);
        }
        graphics.setColor(defaultForeground);
        graphics.setFont(defaultFont);
    }

    public static Font getFont(AttributeSet attributes, Font defaultFont) {
        if (attributes != null) {
            String fontName = (String)attributes.getAttribute(StyleConstants.FontFamily);
            Boolean bold = (Boolean)attributes.getAttribute(StyleConstants.Bold);
            Boolean italic = (Boolean)attributes.getAttribute(StyleConstants.Italic);
            Integer fontSizeInteger = (Integer)attributes.getAttribute(StyleConstants.FontSize);
            if (fontName != null || bold != null || italic != null || fontSizeInteger != null) {
                if (fontName == null) {
                    fontName = defaultFont.getFontName();
                }
                int fontStyle = defaultFont.getStyle();
                if (bold != null) {
                    fontStyle &= 0xFFFFFFFE;
                    if (bold.booleanValue()) {
                        fontStyle |= 1;
                    }
                }
                if (italic != null) {
                    fontStyle &= 0xFFFFFFFD;
                    if (italic.booleanValue()) {
                        fontStyle |= 2;
                    }
                }
                int fontSize = fontSizeInteger != null ? fontSizeInteger.intValue() : defaultFont.getSize();
                defaultFont = new Font(fontName, fontStyle, fontSize);
            }
        }
        return defaultFont;
    }

    public static int getOtherAxis(int axis) {
        return axis == 0 ? 1 : 0;
    }

    public static String toStringAxis(int axis) {
        return axis == 0 ? "X" : "Y";
    }

    public static void repaint(JComponent component, Rectangle2D r) {
        component.repaint((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public static String toString(Color c) {
        return c != null ? "RGB[" + c.getRed() + ';' + c.getGreen() + ';' + c.getBlue() + ']' : "<NULL>";
    }

    public static String toString(Rectangle2D r) {
        return "XYWH[" + r.getX() + ';' + r.getY() + ';' + r.getWidth() + ';' + r.getHeight() + ']';
    }

    public static String toString(Shape s) {
        if (s instanceof Rectangle2D) {
            return ViewUtils.toString((Rectangle2D)s);
        }
        return ViewUtils.appendPath(new StringBuilder(200), 0, s.getPathIterator(null)).toString();
    }

    public static String toStringHex8(int i) {
        String s = Integer.toHexString(i);
        while (s.length() < 8) {
            s = "0" + s;
        }
        return s;
    }

    public static String toStringId(Object o) {
        return o != null ? ViewUtils.toStringHex8(System.identityHashCode(o)) : "<NULL>";
    }

    public static String toStringNameId(Object o) {
        if (o == null) {
            return "<NULL>";
        }
        String className = o.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className + "@" + ViewUtils.toStringId(o);
    }

    public static String toStringPrec1(double d) {
        String s = Double.toString(d);
        int dotIndex = s.indexOf(46);
        if (dotIndex >= 0 && dotIndex < s.length() - 2) {
            s = s.substring(0, dotIndex + 2);
        }
        return s;
    }

    public static String toString(AttributeSet attributes) {
        Color backColor;
        Color foreColor;
        boolean nonFirst = false;
        StringBuilder sb = new StringBuilder(200);
        String fontName = (String)attributes.getAttribute(StyleConstants.FontFamily);
        Boolean bold = (Boolean)attributes.getAttribute(StyleConstants.Bold);
        Boolean italic = (Boolean)attributes.getAttribute(StyleConstants.Italic);
        Integer fontSizeInteger = (Integer)attributes.getAttribute(StyleConstants.FontSize);
        if (fontName != null || bold != null || italic != null || fontSizeInteger != null) {
            sb.append("Font[");
            sb.append(fontName != null ? '\"' + fontName + '\"' : Character.valueOf('?')).append(',');
            if (bold != null || italic != null) {
                if (bold != null) {
                    sb.append('B');
                }
                if (italic != null) {
                    sb.append('I');
                }
            } else {
                sb.append('?');
            }
            sb.append(',');
            sb.append(fontSizeInteger != null ? fontSizeInteger : 63);
            sb.append("], ");
            nonFirst = true;
        }
        if ((foreColor = (Color)attributes.getAttribute(StyleConstants.Foreground)) != null) {
            if (nonFirst) {
                sb.append(", ");
            }
            sb.append("fg=").append(ViewUtils.toString(foreColor));
            nonFirst = true;
        }
        if ((backColor = (Color)attributes.getAttribute(StyleConstants.Background)) != null) {
            if (nonFirst) {
                sb.append(", ");
            }
            sb.append("bg=").append(ViewUtils.toString(backColor));
            nonFirst = true;
        }
        return sb.toString();
    }

    private static StringBuilder appendPath(StringBuilder sb, int indent, PathIterator pathIterator) {
        double[] coords = new double[6];
        while (!pathIterator.isDone()) {
            int endIndex;
            String typeStr;
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 4: {
                    typeStr = "SEG_CLOSE";
                    endIndex = 0;
                    break;
                }
                case 3: {
                    typeStr = "SEG_CUBICTO";
                    endIndex = 6;
                    break;
                }
                case 1: {
                    typeStr = "SEG_LINETO";
                    endIndex = 2;
                    break;
                }
                case 0: {
                    typeStr = "SEG_MOVETO";
                    endIndex = 2;
                    break;
                }
                case 2: {
                    typeStr = "SEG_QUADTO";
                    endIndex = 4;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid type=" + type);
                }
            }
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
            sb.append(typeStr).append(": ");
            int i = 0;
            while (i < endIndex) {
                sb.append("[").append(coords[i++]).append(",").append(coords[i++]).append("] ");
            }
            sb.append('\n');
            pathIterator.next();
        }
        return sb;
    }

    public static String toString(JComponent component) {
        if (component == null) {
            return "<NULL>";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(ViewUtils.toStringNameId(component));
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            sb.append(" doc: ").append(ViewUtils.toString(textComponent.getDocument()));
        }
        return sb.toString();
    }

    public static String toString(Document doc) {
        if (doc == null) {
            return "<NULL>";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(ViewUtils.toStringNameId(doc));
        sb.append(", Length=").append(doc.getLength());
        sb.append(", Version=").append(DocumentUtilities.getDocumentVersion((Document)doc));
        sb.append(", StreamDesc:");
        Object streamDesc = doc.getProperty("stream");
        if (streamDesc != null) {
            sb.append(streamDesc);
        } else {
            sb.append("<NULL>");
        }
        return sb.toString();
    }

    public static void checkFragmentBounds(int p0, int p1, int startOffset, int length) {
        if (p0 < startOffset || p0 > p1 || p1 > startOffset + length) {
            throw new IllegalArgumentException("Illegal bounds: <" + p0 + "," + p1 + "> outside of <" + startOffset + "," + (startOffset + length) + ">");
        }
    }

    public static float ceilFractions(float f) {
        return (float)(Math.ceil((double)f * 8.0) / 8.0);
    }

    public static float ceilFractions(double d) {
        return (float)(Math.ceil(d * 8.0) / 8.0);
    }

    public static float floorFractions(float f) {
        return (float)(Math.floor((double)f * 8.0) / 8.0);
    }

    public static float floorFractions(double d) {
        return (float)(Math.floor(d * 8.0) / 8.0);
    }
}

