/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.core.ui.sampler.SamplesOutputStream;

abstract class Sampler
implements Runnable,
ActionListener {
    private static final int SAMPLER_RATE = 10;
    private static final double MAX_AVERAGE = 30.0;
    private static final double MAX_STDDEVIATION = 40.0;
    private static final int MAX_SAMPLING_TIME = 300;
    private static final int MAX_SAMPLES = 30000;
    private final String name;
    private Timer timer;
    private ByteArrayOutputStream out;
    private SamplesOutputStream samplesStream;
    private long startTime;
    private long nanoTimeCorrection;
    private long samples;
    private long laststamp;
    private double max;
    private double min = 9.223372036854776E18;
    private double sum;
    private double devSquaresSum;
    private volatile boolean stopped;
    private volatile boolean running;

    Sampler(String n) {
        this.name = n;
    }

    protected abstract ThreadMXBean getThreadMXBean();

    protected abstract void saveSnapshot(byte[] var1) throws IOException;

    protected abstract void printStackTrace(Throwable var1);

    protected abstract void openProgress(int var1);

    protected abstract void closeProgress();

    protected abstract void progress(int var1);

    private void updateStats(long timestamp) {
        if (this.laststamp != 0L) {
            double diff = (double)(timestamp - this.laststamp) / 1000000.0;
            ++this.samples;
            this.sum += diff;
            this.devSquaresSum += (diff - 10.0) * (diff - 10.0);
            if (diff > this.max) {
                this.max = diff;
            } else if (diff < this.min) {
                this.min = diff;
            }
        }
        this.laststamp = timestamp;
    }

    @Override
    public synchronized void run() {
        assert (!this.running);
        this.running = true;
        final ThreadMXBean threadBean = this.getThreadMXBean();
        this.out = new ByteArrayOutputStream(65536);
        try {
            this.samplesStream = new SamplesOutputStream(this.out, this, 30000);
        }
        catch (IOException ex) {
            this.printStackTrace(ex);
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.nanoTimeCorrection = this.startTime * 1000000L - System.nanoTime();
        this.timer = new Timer(this.name);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Sampler sampler = Sampler.this;
                synchronized (sampler) {
                    if (Sampler.this.stopped) {
                        return;
                    }
                    try {
                        ThreadInfo[] infos = threadBean.dumpAllThreads(false, false);
                        long timestamp = System.nanoTime() + Sampler.this.nanoTimeCorrection;
                        Sampler.this.samplesStream.writeSample(infos, timestamp, Thread.currentThread().getId());
                        Sampler.this.updateStats(timestamp);
                    }
                    catch (Throwable ex) {
                        Sampler.this.printStackTrace(ex);
                    }
                }
            }
        }, 10L, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        try {
            assert (this.running);
            assert (!this.stopped);
            this.stopped = true;
            this.timer.cancel();
            if ("cancel".equals(e.getActionCommand()) || this.samples < 1L) {
                return;
            }
            double average = this.sum / (double)this.samples;
            double std_deviation = Math.sqrt(this.devSquaresSum / (double)this.samples);
            boolean writeCommand = "write".equals(e.getActionCommand());
            if (writeCommand) {
                Object[] params = new Object[]{this.startTime, "Samples", this.samples, "Average", average, "Minimum", this.min, "Maximum", this.max, "Std. deviation", std_deviation};
                Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Snapshot statistics", params);
                if (average > 30.0 || std_deviation > 40.0) {
                    return;
                }
            }
            this.samplesStream.close();
            this.samplesStream = null;
            if (writeCommand) {
                DataOutputStream dos = (DataOutputStream)e.getSource();
                dos.write(this.out.toByteArray());
                dos.close();
                return;
            }
            this.saveSnapshot(this.out.toByteArray());
        }
        catch (Exception ex) {
            this.printStackTrace(ex);
        }
        finally {
            this.out = null;
            this.samplesStream = null;
        }
    }

    public static void main(String ... args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: <port> <snapshot.npss>");
            System.out.println();
            System.out.println("First of all start your application with following parameters:");
            System.out.println("  -Dcom.sun.management.jmxremote.authenticate=false");
            System.out.println("  -Dcom.sun.management.jmxremote.ssl=false");
            System.out.println("  -Dcom.sun.management.jmxremote.port=<port>");
            System.out.println("Then you can start this sampler with correct port and file to write snapshot to.");
            System.exit(1);
        }
        String u = args[0];
        try {
            u = "service:jmx:rmi:///jndi/rmi://localhost:" + Integer.parseInt(args[0]) + "/jmxrmi";
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        System.err.println("Connecting to " + u);
        JMXServiceURL url = new JMXServiceURL(u);
        JMXConnector jmxc = null;
        Throwable ex = null;
        for (int i = 0; i < 100; ++i) {
            try {
                jmxc = JMXConnectorFactory.connect(url, null);
                break;
            }
            catch (IOException e) {
                ex = e;
                System.err.println("Connection failed. Will retry in 300ms.");
                Thread.sleep(300L);
                continue;
            }
        }
        if (jmxc == null) {
            ex.printStackTrace();
            System.err.println("Cannot connect to " + u);
            System.exit(3);
        }
        MBeanServerConnection server = jmxc.getMBeanServerConnection();
        final ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Threading", ThreadMXBean.class);
        final File output = new File(args[1]);
        class CLISampler
        extends Sampler {
            CLISampler() {
                super("");
            }

            @Override
            protected ThreadMXBean getThreadMXBean() {
                return threadMXBean;
            }

            @Override
            protected void saveSnapshot(byte[] arr) throws IOException {
                FileOutputStream os = new FileOutputStream(output);
                os.write(arr);
                os.close();
            }

            @Override
            protected void printStackTrace(Throwable ex) {
                ex.printStackTrace();
                System.exit(2);
            }

            @Override
            protected void openProgress(int steps) {
            }

            @Override
            protected void closeProgress() {
            }

            @Override
            protected void progress(int i) {
                System.out.print("#");
                System.out.flush();
            }
        }
        CLISampler s = new CLISampler();
        s.run();
        System.out.println("Press enter to generate sample into " + output);
        System.in.read();
        s.actionPerformed(new ActionEvent(s, 0, ""));
        System.out.println();
        System.out.println("Sample written to " + output);
        System.exit(0);
    }
}

