/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageFromFileCallback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

class ImageFromFileThread
extends Thread {
    private Object _source;
    private ImageFromFileCallback _cb;

    public ImageFromFileThread(File file, ImageFromFileCallback imageFromFileCallback) {
        this._source = file;
        this._cb = imageFromFileCallback;
    }

    public ImageFromFileThread(InputStream inputStream, ImageFromFileCallback imageFromFileCallback) {
        this._source = inputStream;
        this._cb = imageFromFileCallback;
    }

    @Override
    public void run() {
        try {
            BufferedImage bufferedImage = null;
            bufferedImage = this._source instanceof File ? ImageFromFileThread.getImage((File)this._source) : ImageFromFileThread.getImage((InputStream)this._source);
            if (bufferedImage != null && (bufferedImage.getWidth(null) > 240 || bufferedImage.getHeight(null) > 240)) {
                bufferedImage = ImageUtils.smartSize((BufferedImage)bufferedImage, (double)240.0);
            }
            this._cb.imageFromFileReady(this, bufferedImage);
        }
        catch (IOException iOException) {
            this._cb.imageFromFileFailed(this, iOException);
        }
    }

    public static BufferedImage getImage(File file) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getImage(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return bufferedImage;
    }
}

