/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageFromUrlCallback;
import com.paterva.maltego.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

class ImageFromUrlThread
extends Thread {
    private URL _url;
    private ImageFromUrlCallback _cb;

    public ImageFromUrlThread(URL uRL, ImageFromUrlCallback imageFromUrlCallback) {
        this._url = uRL;
        this._cb = imageFromUrlCallback;
    }

    @Override
    public void run() {
        try {
            BufferedImage bufferedImage = ImageFromUrlThread.getImage(this._url);
            if (bufferedImage != null && (bufferedImage.getWidth(null) > 240 || bufferedImage.getHeight(null) > 240)) {
                bufferedImage = ImageUtils.smartSize((BufferedImage)bufferedImage, (double)240.0);
            }
            this._cb.imageFromUrlReady(this, bufferedImage);
        }
        catch (Exception exception) {
            this._cb.imageFromUrlFailed(this, exception);
        }
    }

    public static BufferedImage getImage(URL uRL) throws IOException {
        return ImageIO.read(uRL);
    }
}

