/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageID;
import com.paterva.maltego.imgfactory.impl.ImageIconContainer;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;

class ImageIconMemoryCache
implements ImageIconContainer {
    private HashMap<ImageID, ImageData> _cache = new HashMap();

    @Override
    public boolean contains(ImageID imageID) {
        return this._cache.containsKey(imageID);
    }

    @Override
    public ImageIcon get(ImageID imageID) {
        ImageData imageData = this._cache.get(imageID);
        imageData.accessTime = new Date();
        return imageData.imageIcon;
    }

    @Override
    public void put(ImageID imageID, ImageIcon imageIcon) {
        ImageData imageData = new ImageData(imageIcon, new Date());
        this._cache.put(imageID, imageData);
    }

    @Override
    public void remove(ImageID imageID, boolean bl) {
        if (!bl) {
            this._cache.remove(imageID);
        } else {
            Iterator<Map.Entry<ImageID, ImageData>> iterator = this._cache.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getKey().Key.equals(imageID.Key)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void clear() {
        this._cache.clear();
    }

    public void removeOlderThan(Date date, ArrayList<ImageID> arrayList, ArrayList<ImageIcon> arrayList2) {
        Iterator<ImageID> iterator = this._cache.keySet().iterator();
        while (iterator.hasNext()) {
            ImageID imageID = iterator.next();
            ImageData imageData = this._cache.get(imageID);
            if (!imageData.accessTime.before(date)) continue;
            iterator.remove();
            arrayList.add(imageID);
            arrayList2.add(imageData.imageIcon);
        }
    }

    public String getStatus() {
        long l = 0L;
        int n = 0;
        for (Map.Entry<ImageID, ImageData> entry : this._cache.entrySet()) {
            Image image = entry.getValue().imageIcon.getImage();
            if (!(image instanceof BufferedImage)) continue;
            BufferedImage bufferedImage = (BufferedImage)image;
            ++n;
            l += (long)bufferedImage.getData().getDataBuffer().getSize();
        }
        StringBuilder stringBuilder = new StringBuilder("Memory Cache\n============\n");
        stringBuilder.append("Images = ");
        stringBuilder.append(this._cache.size());
        stringBuilder.append("\n");
        stringBuilder.append("Buffered = ");
        stringBuilder.append(n);
        stringBuilder.append("\n");
        stringBuilder.append("Buffered size = ");
        stringBuilder.append(l);
        stringBuilder.append("B = ");
        stringBuilder.append(l / 1024L);
        stringBuilder.append("KB = ");
        stringBuilder.append(l / 1024L / 1024L);
        stringBuilder.append("MB");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private class ImageData {
        ImageIcon imageIcon;
        Date accessTime;

        public ImageData(ImageIcon imageIcon, Date date) {
            this.imageIcon = imageIcon;
            this.accessTime = date;
        }
    }
}

