/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.ex;

import com.paterva.maltego.util.ui.PasswordUtil;
import com.paterva.maltego.util.ui.dialog.FileController;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

class ExportFileController<TData>
extends FileController {
    private JCheckBox _encryptCheckBox;

    public ExportFileController() {
        super(1, "Maltego Archive", new String[]{"mtz"});
    }

    protected JFileChooser createComponent() {
        JFileChooser jFileChooser = super.createComponent();
        this._encryptCheckBox = PasswordUtil.addEncryptOption((JFileChooser)jFileChooser, (boolean)false);
        return jFileChooser;
    }

    public void validate() throws WizardValidationException {
        String string = null;
        File file = this.getSelectedFile();
        if (file == null || file.isDirectory()) {
            string = "Please choose a file name";
        } else if (file.exists()) {
            if (!file.canWrite()) {
                string = "The selected file is not writable";
            } else {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)"The file exists. Do you want to overwrite it?", "File Exists", 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) != NotifyDescriptor.OK_OPTION) {
                    string = " ";
                }
            }
        } else {
            try {
                if (file.createNewFile()) {
                    file.delete();
                } else {
                    string = "The directory is not writable";
                }
            }
            catch (IOException iOException) {
                string = "The directory is not writable";
            }
        }
        if (string != null) {
            throw new WizardValidationException((JComponent)this.component(), string, string);
        }
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        super.readSettings(wizardDescriptor);
        boolean bl = (Boolean)wizardDescriptor.getProperty("encrypt");
        this._encryptCheckBox.setSelected(bl);
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        super.storeSettings(wizardDescriptor);
        wizardDescriptor.putProperty("encrypt", (Object)this._encryptCheckBox.isSelected());
    }
}

