/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class KeymapModel {
    private static final Logger LOG = Logger.getLogger(KeymapModel.class.getName());
    private static final Logger UI_LOG = Logger.getLogger("org.netbeans.ui.options");
    private static ArrayList<KeymapManager> managers = null;
    private Map<String, Set<ShortcutAction>> categoryToActions = new HashMap<String, Set<ShortcutAction>>();
    private Map<String, Map<ShortcutAction, Set<String>>> keyMaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Map<String, Map<ShortcutAction, Set<String>>> keyMapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Map<ShortcutAction, CompoundAction> sharedActions = new HashMap<ShortcutAction, CompoundAction>();
    private Map<String, String> profilesMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends KeymapManager> getKeymapManagerInstances() {
        if (managers != null) {
            return managers;
        }
        ArrayList al = new ArrayList(Lookup.getDefault().lookupAll(KeymapManager.class));
        al.trimToSize();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Dumping registered KeymapManagers: ");
            for (KeymapManager m : al) {
                LOG.fine("    KeymapManager: " + KeymapModel.s2s(m));
            }
            LOG.fine("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        Class<KeymapModel> clazz = KeymapModel.class;
        synchronized (KeymapModel.class) {
            if (managers == null) {
                managers = al;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            assert (managers != null);
            return managers;
        }
    }

    public Set<String> getActionCategories() {
        HashSet<String> result = new HashSet<String>();
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            result.addAll(keymapManager.getActions().keySet());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<ShortcutAction> getActions(String category) {
        if (!this.categoryToActions.containsKey(category)) {
            Set<ShortcutAction> actions = new HashSet<ShortcutAction>();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Set<ShortcutAction> s = keymapManager.getActions().get(category);
                if (s == null) continue;
                actions = this.mergeActions(actions, s, keymapManager.getName());
            }
            this.categoryToActions.put(category, actions);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Category '" + category + "' actions (" + actions.size() + "), KeymapModel=" + this + ":");
                for (ShortcutAction shortcutAction : actions) {
                    LOG.fine("    id='" + shortcutAction.getId() + "', did='" + shortcutAction.getDelegatingActionId() + ", " + KeymapModel.s2s(shortcutAction));
                }
                LOG.fine("---------------------------");
            }
        }
        return this.categoryToActions.get(category);
    }

    public void refreshActions() {
        this.categoryToActions = new HashMap<String, Set<ShortcutAction>>();
        this.sharedActions = new HashMap<ShortcutAction, CompoundAction>();
        this.keyMaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.keyMapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.refreshActions();
        }
    }

    public String getCurrentProfile() {
        String profileName = null;
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            String res = keymapManager.getCurrentProfile();
            if (res == null) continue;
            profileName = res;
            break;
        }
        if (profileName == null) {
            profileName = "NetBeans";
        }
        Map<String, String> map = this.getProfilesMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(profileName)) continue;
            return entry.getKey();
        }
        return profileName;
    }

    public void setCurrentProfile(String profile) {
        String prev = this.getCurrentProfile();
        if (!prev.equals(profile)) {
            LogRecord rec = new LogRecord(Level.CONFIG, "KEYMAP_SET_PROFILE");
            rec.setParameters(new Object[]{profile, prev});
            rec.setResourceBundle(NbBundle.getBundle(KeymapModel.class));
            rec.setResourceBundleName(KeymapModel.class.getPackage().getName() + ".Bundle");
            rec.setLoggerName(UI_LOG.getName());
            UI_LOG.log(rec);
        }
        profile = this.displayNameToName(profile);
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.setCurrentProfile(profile);
        }
    }

    public List<String> getProfiles() {
        return new ArrayList<String>(this.getProfilesMap().keySet());
    }

    public boolean isCustomProfile(String profile) {
        profile = this.displayNameToName(profile);
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            boolean res = keymapManager.isCustomProfile(profile);
            if (!res) continue;
            return true;
        }
        return false;
    }

    public Map<ShortcutAction, Set<String>> getKeymap(String profile) {
        if (!this.keyMaps.containsKey(profile = this.displayNameToName(profile))) {
            this.ensureActionsLoaded();
            Map<ShortcutAction, Set<String>> res = new HashMap<ShortcutAction, Set<String>>();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Map<ShortcutAction, Set<String>> mm = keymapManager.getKeymap(profile);
                res = this.mergeShortcuts(res, mm);
            }
            this.keyMaps.put(profile, res);
        }
        return this.keyMaps.get(profile);
    }

    public Map<ShortcutAction, Set<String>> getKeymapDefaults(String profile) {
        if (!this.keyMapDefaults.containsKey(profile = this.displayNameToName(profile))) {
            this.ensureActionsLoaded();
            Map<ShortcutAction, Set<String>> res = new HashMap<ShortcutAction, Set<String>>();
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                Map<ShortcutAction, Set<String>> mm = keymapManager.getDefaultKeymap(profile);
                res = this.mergeShortcuts(res, mm);
            }
            this.keyMapDefaults.put(profile, res);
        }
        return this.keyMapDefaults.get(profile);
    }

    public void deleteProfile(String profile) {
        profile = this.displayNameToName(profile);
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.deleteProfile(profile);
        }
    }

    public void changeKeymap(String profile, Map<ShortcutAction, Set<String>> actionToShortcuts) {
        profile = this.displayNameToName(profile);
        this.log("changeKeymap.actionToShortcuts", actionToShortcuts.entrySet());
        HashMap<ShortcutAction, Set<String>> m = new HashMap<ShortcutAction, Set<String>>(this.getKeymap(profile));
        m.putAll(actionToShortcuts);
        this.keyMaps.put(profile, m);
        this.log("changeKeymap.m", m.entrySet());
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            keymapManager.saveKeymap(profile, m);
        }
    }

    private void log(String name, Collection items) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        LOG.fine(name);
        for (Object item : items) {
            LOG.fine("  " + item);
        }
    }

    Set<ShortcutAction> mergeActions(Collection<ShortcutAction> res, Collection<ShortcutAction> adding, String name) {
        String id;
        HashSet<ShortcutAction> result = new HashSet<ShortcutAction>();
        HashMap<String, ShortcutAction> idToAction = new HashMap<String, ShortcutAction>();
        HashMap<String, ShortcutAction> delegateIdToAction = new HashMap<String, ShortcutAction>();
        for (ShortcutAction action : res) {
            id = action.getId();
            idToAction.put(id, action);
            String delegate = action.getDelegatingActionId();
            if (delegate == null) continue;
            delegateIdToAction.put(delegate, action);
        }
        for (ShortcutAction action : adding) {
            String delegatingId;
            id = action.getId();
            if (delegateIdToAction.containsKey(id)) {
                ShortcutAction origAction = (ShortcutAction)delegateIdToAction.remove(id);
                idToAction.remove(origAction.getId());
                KeymapManager origActionKeymapManager = this.findOriginator(origAction);
                HashMap<String, ShortcutAction> ss = new HashMap<String, ShortcutAction>();
                ss.put(origActionKeymapManager.getName(), origAction);
                ss.put(name, action);
                CompoundAction compoundAction = new CompoundAction(ss);
                result.add(compoundAction);
                this.sharedActions.put(origAction, compoundAction);
                this.sharedActions.put(action, compoundAction);
                result.add(compoundAction);
            }
            if (idToAction.containsKey(delegatingId = action.getDelegatingActionId())) {
                ShortcutAction origAction = (ShortcutAction)idToAction.remove(delegatingId);
                KeymapManager origActionKeymapManager = this.findOriginator(origAction);
                HashMap<String, ShortcutAction> ss = new HashMap<String, ShortcutAction>();
                ss.put(origActionKeymapManager.getName(), origAction);
                ss.put(name, action);
                CompoundAction compoundAction = new CompoundAction(ss);
                result.add(compoundAction);
                this.sharedActions.put(origAction, compoundAction);
                this.sharedActions.put(action, compoundAction);
                result.add(compoundAction);
            }
            if (this.sharedActions.containsKey(action)) continue;
            result.add(action);
        }
        result.addAll(idToAction.values());
        return result;
    }

    private KeymapManager findOriginator(ShortcutAction a) {
        for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
            if (a.getKeymapManagerInstance(keymapManager.getName()) == null) continue;
            return keymapManager;
        }
        return null;
    }

    private Map<ShortcutAction, Set<String>> mergeShortcuts(Map<ShortcutAction, Set<String>> res, Map<ShortcutAction, Set<String>> adding) {
        for (ShortcutAction action : adding.keySet()) {
            Set<String> shortcuts = adding.get(action);
            if (shortcuts.isEmpty()) continue;
            if (this.sharedActions.containsKey(action)) {
                action = this.sharedActions.get(action);
            }
            res.put(action, shortcuts);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Action='" + action.getId() + "' (" + KeymapModel.s2s(action) + ") shortcuts: " + shortcuts);
        }
        return res;
    }

    private void ensureActionsLoaded() {
        for (String c : this.getActionCategories()) {
            this.getActions(c);
        }
    }

    private String displayNameToName(String keymapDisplayName) {
        String name = this.getProfilesMap().get(keymapDisplayName);
        return name == null ? keymapDisplayName : name;
    }

    private Map<String, String> getProfilesMap() {
        if (this.profilesMap == null) {
            for (KeymapManager keymapManager : KeymapModel.getKeymapManagerInstances()) {
                List<String> l = keymapManager.getProfiles();
                if (l == null) continue;
                this.profilesMap = new HashMap<String, String>();
                for (String name : l) {
                    this.profilesMap.put(keymapManager.getProfileDisplayName(name), name);
                }
            }
        }
        return this.profilesMap;
    }

    public KeymapModel() {
        Iterator<String> it = this.getActionCategories().iterator();
        while (it.hasNext()) {
            this.getActions(it.next());
        }
    }

    private static String s2s(Object o) {
        return o == null ? "null" : o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }
}

