/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.http;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class SimpleX509TrustManager
implements X509TrustManager {
    private X509TrustManager _delegate;
    private boolean _allowAllCerts;
    private String _requireInCN;

    public SimpleX509TrustManager() throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        this(true);
    }

    public SimpleX509TrustManager(boolean bl) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        this._allowAllCerts = bl;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            this._delegate = (X509TrustManager)trustManagerArray[i];
            return;
        }
        throw new KeyStoreException("Couldn't initialize TrustManager");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this._delegate.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (this._allowAllCerts) {
            return;
        }
        this._delegate.checkServerTrusted(x509CertificateArray, string);
        if (this._requireInCN != null && !SimpleX509TrustManager.checkSubject(x509CertificateArray, this._requireInCN)) {
            throw new CertificateException("Invalid subject, required: " + this._requireInCN);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this._delegate.getAcceptedIssuers();
    }

    public boolean trustAllCerts() {
        return this._allowAllCerts;
    }

    public void setTrustAllCerts(boolean bl) {
        this._allowAllCerts = bl;
    }

    public String getRequireInCN() {
        return this._requireInCN;
    }

    public void setRequireInCN(String string) {
        this._requireInCN = string;
    }

    private static boolean checkSubject(X509Certificate[] x509CertificateArray, String string) {
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            String string2 = x509CertificateArray[0].getSubjectDN().getName();
            String string3 = SimpleX509TrustManager.getDNComponent("cn", string2);
            if (string3 == null) {
                return false;
            }
            return string3.endsWith(string);
        }
        return false;
    }

    private static String getDNComponent(String string, String string2) {
        String[] stringArray;
        for (String string3 : stringArray = string2.split(",")) {
            if (!string3.toLowerCase().startsWith(string + "=")) continue;
            return string3.substring(string.length() + 1);
        }
        return null;
    }
}

