/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.ui.CheckList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.TableColumnSelector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class EditableTableColumnSelector
extends TableColumnSelector {
    private ListMap<String, String> _selectableColumns;
    private ETable _table;
    private String[] _allColumns;

    public EditableTableColumnSelector(ETable eTable, String[] stringArray, String[] stringArray2) {
        this(eTable, stringArray, stringArray2, stringArray2);
    }

    public EditableTableColumnSelector(ETable eTable, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (stringArray2 == null || stringArray3 == null || stringArray2.length != stringArray3.length) {
            throw new IllegalArgumentException("Selectable and display name arrays must be non null and of equal length.");
        }
        this._table = eTable;
        this._allColumns = stringArray;
        this._selectableColumns = new ListMap();
        for (int i = 0; i < stringArray2.length; ++i) {
            this._selectableColumns.put((Object)stringArray2[i], (Object)stringArray3[i]);
        }
    }

    public String[] selectVisibleColumns(TableColumnSelector.TreeNode treeNode, String[] stringArray) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Not implemented"));
        return new String[0];
    }

    public String[] selectVisibleColumns(String[] stringArray, String[] stringArray2) {
        Object[] objectArray;
        JPanel jPanel = new JPanel(new BorderLayout(5, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 5, 5, 5));
        CheckList checkList = new CheckList(this.createColumnItems());
        checkList.setBackground(SystemColor.control);
        Object[] objectArray2 = this.createColumnItems(stringArray2);
        checkList.setSelectedItems(objectArray2);
        jPanel.add((Component)checkList, "Center");
        jPanel.add(Box.createHorizontalStrut(20), "West");
        jPanel.add((Component)new JLabel("Select the columns to display in the table:"), "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, "Select table columns");
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            objectArray = checkList.getSelectedItems();
            stringArray2 = this.getNames(objectArray);
        }
        objectArray = new LinkedList();
        Enumeration<TableColumn> enumeration = this._table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            String object = enumeration.nextElement().getHeaderValue().toString();
            if (!this.contains(stringArray2, object)) continue;
            objectArray.add(object);
        }
        for (String string : this._allColumns) {
            if (!this._selectableColumns.containsKey((Object)string) && !objectArray.contains(string)) {
                objectArray.add(string);
                continue;
            }
            if (!this.contains(stringArray2, string) || objectArray.contains(string)) continue;
            objectArray.add(string);
        }
        String[] stringArray3 = objectArray.toArray(new String[objectArray.size()]);
        return stringArray3;
    }

    private ColumnItem[] createColumnItems() {
        ColumnItem[] columnItemArray = new ColumnItem[this._selectableColumns.size()];
        int n = 0;
        for (Map.Entry entry : this._selectableColumns.entrySet()) {
            columnItemArray[n++] = new ColumnItem((String)entry.getKey(), (String)entry.getValue());
        }
        return columnItemArray;
    }

    private ColumnItem[] createColumnItems(String[] stringArray) {
        ColumnItem[] columnItemArray = new ColumnItem[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            columnItemArray[i] = new ColumnItem(stringArray[i], (String)this._selectableColumns.get((Object)stringArray[i]));
        }
        return columnItemArray;
    }

    private String[] getNames(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = ((ColumnItem)objectArray[i]).getName();
        }
        return stringArray;
    }

    private boolean contains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private class ColumnItem {
        private String _name;
        private String _displayName;

        public ColumnItem(String string) {
            this(string, null);
        }

        public ColumnItem(String string, String string2) {
            this._name = string;
            this._displayName = string2;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public boolean equals(ColumnItem columnItem) {
            if (columnItem == null) {
                return false;
            }
            return columnItem.getName().equals(this.getName());
        }

        public boolean equals(Object object) {
            if (object instanceof ColumnItem) {
                return this.equals((ColumnItem)object);
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 71 * n + (this._name != null ? this._name.hashCode() : 0);
            return n;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String string) {
            this._name = string;
        }

        public String getDisplayName() {
            if (this._displayName == null) {
                return this._name;
            }
            return this._displayName;
        }

        public void setDisplayName(String string) {
            this._displayName = string;
        }
    }
}

