/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.matching;

import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.util.SortedMap;
import java.util.TreeMap;

public interface MatchingRule {
    public static final int MATCH = 1;
    public static final int MISMATCH = -1;
    public static final int INDETERMINATE = 0;
    public static final MatchingRule Type = new Type();
    public static final MatchingRule Value = new Value();
    public static final MatchingRule Default = new Default();

    public int match(SpecRegistry var1, TypedPropertyBag var2, TypedPropertyBag var3);

    public static class Property
    implements MatchingRule {
        private String _property;

        public Property(String string) {
            this._property = string;
        }

        public int match(SpecRegistry specRegistry, TypedPropertyBag typedPropertyBag, TypedPropertyBag typedPropertyBag2) {
            Object object;
            Object object2;
            PropertyDescriptor propertyDescriptor;
            PropertyDescriptor propertyDescriptor2 = typedPropertyBag.getProperties().get(this._property);
            if (propertyDescriptor2 != null && (propertyDescriptor = typedPropertyBag2.getProperties().get(this._property)) != null && (object2 = typedPropertyBag.getValue(propertyDescriptor2)) != null && (object = typedPropertyBag2.getValue(propertyDescriptor)) != null) {
                return object2.equals(object) ? 1 : -1;
            }
            return 0;
        }
    }

    public static class Value
    implements MatchingRule {
        public int match(SpecRegistry specRegistry, TypedPropertyBag typedPropertyBag, TypedPropertyBag typedPropertyBag2) {
            Object object;
            Object object2 = InheritanceHelper.getValue((SpecRegistry)specRegistry, (TypedPropertyBag)typedPropertyBag);
            if (object2 != null && (object = InheritanceHelper.getValue((SpecRegistry)specRegistry, (TypedPropertyBag)typedPropertyBag2)) != null) {
                return object2.equals(object) ? 1 : -1;
            }
            return 0;
        }
    }

    public static class Default
    implements MatchingRule {
        public int match(SpecRegistry specRegistry, TypedPropertyBag typedPropertyBag, TypedPropertyBag typedPropertyBag2) {
            int n = Type.match(specRegistry, typedPropertyBag, typedPropertyBag2);
            if (n == 1) {
                return Value.match(specRegistry, typedPropertyBag, typedPropertyBag2);
            }
            return n;
        }
    }

    public static class And
    implements MatchingRule {
        private MatchingRule[] _rules;

        public And(MatchingRule ... matchingRuleArray) {
            this._rules = matchingRuleArray;
        }

        public int match(SpecRegistry specRegistry, TypedPropertyBag typedPropertyBag, TypedPropertyBag typedPropertyBag2) {
            boolean bl = false;
            for (MatchingRule matchingRule : this._rules) {
                int n = matchingRule.match(specRegistry, typedPropertyBag, typedPropertyBag2);
                if (n == 0) {
                    return 0;
                }
                if (n != -1) continue;
                bl = true;
            }
            if (bl) {
                return -1;
            }
            return 1;
        }
    }

    public static class Type
    implements MatchingRule {
        public int match(SpecRegistry specRegistry, TypedPropertyBag typedPropertyBag, TypedPropertyBag typedPropertyBag2) {
            return typedPropertyBag.getTypeName().equals(typedPropertyBag2.getTypeName()) ? 1 : -1;
        }
    }

    public static class TypeMap
    implements MatchingRule {
        private SortedMap<String, MatchingRule> _map;

        public void put(String string, MatchingRule matchingRule) {
            if (this._map == null) {
                this._map = new TreeMap<String, MatchingRule>();
            }
            this._map.put(string, matchingRule);
        }

        public MatchingRule get(String string) {
            return (MatchingRule)this._map.get(string);
        }

        public int match(SpecRegistry specRegistry, TypedPropertyBag typedPropertyBag, TypedPropertyBag typedPropertyBag2) {
            if (!typedPropertyBag.getTypeName().equals(typedPropertyBag2.getTypeName())) {
                return -1;
            }
            if (this._map == null) {
                return 0;
            }
            MatchingRule matchingRule = (MatchingRule)this._map.get(typedPropertyBag.getTypeName());
            if (matchingRule == null) {
                return 0;
            }
            return matchingRule.match(specRegistry, typedPropertyBag, typedPropertyBag2);
        }
    }

    public static class Layered
    implements MatchingRule {
        private MatchingRule[] _rules;

        public Layered(MatchingRule ... matchingRuleArray) {
            this._rules = matchingRuleArray;
        }

        public int match(SpecRegistry specRegistry, TypedPropertyBag typedPropertyBag, TypedPropertyBag typedPropertyBag2) {
            for (MatchingRule matchingRule : this._rules) {
                int n = matchingRule.match(specRegistry, typedPropertyBag, typedPropertyBag2);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
    }
}

