/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformSeedRepository;
import com.paterva.maltego.transform.repository.RepositoryUtils;
import com.paterva.maltego.util.FastURL;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class FSTransformSeedRepository
extends TransformSeedRepository {
    private static final String MALTEGO_FOLDER = "Maltego";
    private static final String SEED_FOLDER = "Seeds";
    private static final String EXTENSION = "seed";
    private static final String ATTR_DISPLAY_NAME = "displayName";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_URL = "url";
    private static final String ATTR_ENABLED = "enabled";

    public void add(TransformSeed transformSeed) {
        try {
            FileObject fileObject = FSTransformSeedRepository.getFile(transformSeed.getUrl());
            if (fileObject != null) {
                FSTransformSeedRepository.update(fileObject, transformSeed);
            } else {
                FileObject fileObject2 = FSTransformSeedRepository.getOrCreateSeedFolder();
                FSTransformSeedRepository.update(RepositoryUtils.createUniqueFile(fileObject2, RepositoryUtils.replaceIllegalChars(transformSeed.getName()), EXTENSION), transformSeed);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static FileObject getOrCreateSeedFolder() throws IOException {
        return FSTransformSeedRepository.getOrCreateFolder(FSTransformSeedRepository.getOrCreateMaltegoFolder(), SEED_FOLDER);
    }

    private static FileObject getOrCreateMaltegoFolder() throws IOException {
        FileObject fileObject = FileUtil.getConfigRoot();
        return FSTransformSeedRepository.getOrCreateFolder(fileObject, MALTEGO_FOLDER);
    }

    private static void update(FileObject fileObject, TransformSeed transformSeed) throws IOException {
        fileObject.setAttribute(ATTR_DISPLAY_NAME, (Object)transformSeed.getName());
        fileObject.setAttribute(ATTR_DESCRIPTION, (Object)transformSeed.getDescription());
        fileObject.setAttribute(ATTR_URL, (Object)transformSeed.getUrl().toString());
        fileObject.setAttribute(ATTR_ENABLED, (Object)transformSeed.isEnabled());
    }

    public void update(Iterable<TransformSeed> iterable) {
        FSTransformSeedRepository.deleteSeedFolder();
        for (TransformSeed transformSeed : iterable) {
            this.add(transformSeed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteSeedFolder() {
        FileObject fileObject = FSTransformSeedRepository.getSeedFolder();
        if (fileObject != null) {
            FileLock fileLock = null;
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FastURL fastURL) {
        for (FileObject fileObject : FSTransformSeedRepository.getSeedFiles()) {
            if (!fastURL.toString().equals(fileObject.getAttribute(ATTR_URL))) continue;
            FileLock fileLock = null;
            try {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
    }

    private static FileObject getOrCreateFolder(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createFolder(string);
        }
        return fileObject.getFileObject(string);
    }

    private static FileObject getSeedFolder() {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileObject fileObject2 = fileObject.getFileObject(MALTEGO_FOLDER);
        if (fileObject2 != null) {
            return fileObject2.getFileObject(SEED_FOLDER);
        }
        return null;
    }

    private static FileObject[] getSeedFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        FileObject fileObject = FSTransformSeedRepository.getSeedFolder();
        if (fileObject != null) {
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2.isFolder() || !EXTENSION.equals(fileObject2.getExt())) continue;
                arrayList.add(fileObject2);
            }
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public TransformSeed[] getAll() {
        ArrayList<TransformSeed> arrayList = new ArrayList<TransformSeed>();
        for (FileObject fileObject : FSTransformSeedRepository.getSeedFiles()) {
            try {
                arrayList.add(FSTransformSeedRepository.createSeed(fileObject));
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        return arrayList.toArray(new TransformSeed[arrayList.size()]);
    }

    private static TransformSeed createSeed(FileObject fileObject) throws MalformedURLException {
        String string = (String)fileObject.getAttribute(ATTR_DISPLAY_NAME);
        String string2 = (String)fileObject.getAttribute(ATTR_URL);
        TransformSeed transformSeed = new TransformSeed(new FastURL(string2), string);
        transformSeed.setDescription((String)fileObject.getAttribute(ATTR_DESCRIPTION));
        Object object = fileObject.getAttribute(ATTR_ENABLED);
        transformSeed.setEnabled(object == null ? true : (Boolean)object);
        return transformSeed;
    }

    public TransformSeed get(FastURL fastURL) {
        try {
            FileObject fileObject = FSTransformSeedRepository.getFile(fastURL);
            if (fileObject != null) {
                return FSTransformSeedRepository.createSeed(fileObject);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
        return null;
    }

    private static FileObject getFile(FastURL fastURL) {
        for (FileObject fileObject : FSTransformSeedRepository.getSeedFiles()) {
            if (!fastURL.toString().equals(fileObject.getAttribute(ATTR_URL))) continue;
            return fileObject;
        }
        return null;
    }

    public void set(TransformSeed[] transformSeedArray) throws IOException {
        if (transformSeedArray != null && transformSeedArray.length != 0) {
            FileObject fileObject = FSTransformSeedRepository.getSeedFolder();
            if (fileObject != null) {
                fileObject.delete();
            }
            this.update(Arrays.asList(transformSeedArray));
        }
    }

    public TransformSeed[] getEnabled() {
        ArrayList<TransformSeed> arrayList = new ArrayList<TransformSeed>();
        for (TransformSeed transformSeed : this.getAll()) {
            if (!transformSeed.isEnabled()) continue;
            arrayList.add(transformSeed);
        }
        return arrayList.toArray(new TransformSeed[arrayList.size()]);
    }
}

