/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz.graph;

import com.paterva.maltego.archive.mtz.graph.IOHelper;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import yguard.A.H.B.A.H;
import yguard.A.H.B.B.Z;

public class MaltegoLinkIO {
    public MaltegoLink read(Node node) throws Z {
        String string = IOHelper.getRequiredAttribute(node, "type");
        MaltegoLink maltegoLink = LinkFactory.createInstance((MaltegoLinkSpec)MaltegoLinkSpec.getSpec((String)string));
        Element element = IOHelper.findElement(node, "Properties");
        if (element != null) {
            this.attachProperties(maltegoLink, element);
        }
        return maltegoLink;
    }

    private void attachProperties(MaltegoLink maltegoLink, Node node) throws Z {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !"Property".equals(node2.getLocalName())) continue;
            String string = IOHelper.getRequiredAttribute(node2, "name");
            if (!maltegoLink.getProperties().contains(string)) {
                this.attachProperty(maltegoLink, node2);
            }
            String string2 = IOHelper.getValue(node2);
            PropertyDescriptor propertyDescriptor = maltegoLink.getProperties().get(string);
            try {
                Object object = Converter.convertFrom((String)string2, (Class)propertyDescriptor.getType());
                maltegoLink.setValue(propertyDescriptor, object);
                continue;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                TypeDescriptor typeDescriptor = TypeRegistry.getDefault().getType(propertyDescriptor.getType());
                if (typeDescriptor == null) continue;
                maltegoLink.setValue(propertyDescriptor, typeDescriptor.getDefaultValue());
            }
        }
    }

    private void attachProperty(MaltegoLink maltegoLink, Node node) throws Z {
        String string = IOHelper.getRequiredAttribute(node, "name");
        String string2 = IOHelper.getRequiredAttribute(node, "type");
        TypeDescriptor typeDescriptor = TypeRegistry.getDefault().getType(string2);
        if (typeDescriptor == null) {
            throw new Z("The data type " + string2 + " is not known.");
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(typeDescriptor.getType(), string, IOHelper.getStringAttribute(node, "displayName"));
        propertyDescriptor.setHidden(IOHelper.getBooleanAttribute(node, "hidden", false));
        propertyDescriptor.setNullable(IOHelper.getBooleanAttribute(node, "nullable", true));
        propertyDescriptor.setReadonly(IOHelper.getBooleanAttribute(node, "readonly", false));
        maltegoLink.getProperties().add(propertyDescriptor);
    }

    public void write(H h, MaltegoLink maltegoLink) {
        h.writeStartElement("mtg", "MaltegoLink", "http://maltego.paterva.com/xml/mtgx");
        h.writeAttribute("type", maltegoLink.getTypeName());
        this.writeProperties(h, maltegoLink);
        h.writeEndElement();
    }

    private void writeProperties(H h, MaltegoLink maltegoLink) {
        h.writeStartElement("mtg", "Properties", "http://maltego.paterva.com/xml/mtgx");
        for (PropertyDescriptor propertyDescriptor : maltegoLink.getProperties()) {
            IOHelper.writeProperty(h, (MaltegoPart)maltegoLink, propertyDescriptor);
        }
        h.writeEndElement();
    }
}

