/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.actions.CookieAction;

public class SaveAction
extends CookieAction {
    private static Class<? extends Node.Cookie> dataObject;
    private static Method getNodeDelegate;

    public SaveAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected Class[] cookieClasses() {
        return new Class[]{SaveCookie.class};
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new Delegate(this, actionContext);
    }

    final void performAction(Lookup context) {
        Collection cookieList = context.lookupAll(SaveCookie.class);
        LinkedList nodeList = new LinkedList(context.lookupAll(Node.class));
        block0: for (SaveCookie saveCookie : cookieList) {
            for (Node node : nodeList) {
                if (!saveCookie.equals(node.getCookie(SaveCookie.class))) continue;
                this.performAction(saveCookie, node);
                nodeList.remove(node);
                continue block0;
            }
            this.performAction(saveCookie, null);
        }
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            Node node = activatedNodes[i];
            SaveCookie sc = (SaveCookie)node.getCookie(SaveCookie.class);
            assert (sc != null) : "SaveCookie must be present on " + node + ". " + "See http://www.netbeans.org/issues/show_bug.cgi?id=68285 for details on overriding " + node.getClass().getName() + ".getCookie correctly.";
            if (sc == null) {
                return;
            }
            this.performAction(sc, node);
        }
    }

    private void performAction(SaveCookie sc, Node n) {
        UserQuestionException userEx = null;
        while (true) {
            try {
                if (userEx == null) {
                    sc.save();
                } else {
                    userEx.confirmed();
                }
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SaveAction.class, (String)"MSG_saved", (Object)this.getSaveMessage(sc, n)));
            }
            catch (UserQuestionException ex) {
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)ex.getLocalizedMessage(), 0);
                Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!NotifyDescriptor.OK_OPTION.equals(res)) break;
                userEx = ex;
                continue;
            }
            catch (IOException e) {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(SaveAction.class, (String)"EXC_notsaved", (Object)this.getSaveMessage(sc, n), (Object)e.getLocalizedMessage()));
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, null, e);
            }
            break;
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getSaveMessage(SaveCookie sc, Node n) {
        Node.Cookie obj;
        if (n == null) {
            return sc.toString();
        }
        if (dataObject == null) {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (l == null) {
                l = ((Object)((Object)this)).getClass().getClassLoader();
            }
            try {
                dataObject = Class.forName("org.openide.loaders.DataObject", true, l).asSubclass(Node.Cookie.class);
                getNodeDelegate = dataObject.getMethod("getNodeDelegate", new Class[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (getNodeDelegate != null && (obj = n.getCookie(dataObject)) != null) {
            try {
                n = (Node)getNodeDelegate.invoke((Object)obj, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return n.getDisplayName();
    }

    protected int mode() {
        return 7;
    }

    public String getName() {
        return NbBundle.getMessage(SaveAction.class, (String)"Save");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/save.png";
    }

    private static final class Delegate
    extends AbstractAction
    implements ContextAwareAction {
        final SaveAction sa;
        final Lookup context;

        public Delegate(SaveAction sa, Lookup context) {
            this.sa = sa;
            this.context = context;
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new Delegate(this.sa, actionContext);
        }

        @Override
        public Object getValue(String key) {
            return this.sa.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.sa.putValue(key, value);
        }

        @Override
        public boolean isEnabled() {
            return this.context.lookup(SaveCookie.class) != null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sa.performAction(this.context);
        }
    }
}

