/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess;

import com.sun.jna.platform.WindowUtils;
import java.awt.Shape;
import java.awt.Window;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.core.windows.nativeaccess.NativeWindowSystem;

public class NativeWindowSystemImpl
extends NativeWindowSystem {
    private static final Logger LOG = Logger.getLogger(NativeWindowSystemImpl.class.getName());

    public boolean isWindowAlphaSupported() {
        boolean res = false;
        try {
            res = WindowUtils.isWindowAlphaSupported();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (UnsatisfiedLinkError e) {
            LOG.log(Level.FINE, null, e);
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
        return res;
    }

    private static boolean is32Bit() {
        String osarch = System.getProperty("os.arch");
        for (String x : new String[]{"x86", "i386", "i486", "i586", "i686"}) {
            if (!x.equals(osarch)) continue;
            return true;
        }
        return false;
    }

    public void setWindowAlpha(Window w, float alpha) {
        try {
            WindowUtils.setWindowAlpha(w, alpha);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    public void setWindowMask(Window w, Shape mask) {
        try {
            WindowUtils.setWindowMask(w, mask);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    public void setWindowMask(Window w, Icon mask) {
        try {
            WindowUtils.setWindowMask(w, mask);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, null, e);
        }
    }
}

