/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.typing.PropertyDescriptor;

public class PropertyConstraint {
    private Class _type;
    private boolean _nullable;
    private String _name;

    public PropertyConstraint(Class clazz) {
        this(clazz, null);
    }

    public PropertyConstraint(String string) {
        this(null, string);
    }

    public PropertyConstraint(Class clazz, String string) {
        this(clazz, string, true);
    }

    public PropertyConstraint(Class clazz, String string, boolean bl) {
        this._type = clazz;
        this._name = string;
        this._nullable = bl;
    }

    public Class getType() {
        return this._type;
    }

    public void setType(Class clazz) {
        this._type = clazz;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    public void setNullable(boolean bl) {
        this._nullable = bl;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public boolean isSatisfiedBy(TypedPropertyBag typedPropertyBag) {
        for (PropertyDescriptor propertyDescriptor : typedPropertyBag.getProperties()) {
            if (this._type != null && propertyDescriptor.getType() != this._type || this._name != null && !this._name.equals(propertyDescriptor.getName())) continue;
            if (this._nullable) {
                return true;
            }
            Object object = typedPropertyBag.getValue(propertyDescriptor);
            boolean bl = object != null;
            return bl;
        }
        return false;
    }

    public String getDisplay() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._name != null) {
            stringBuilder.append(this._name);
        }
        if (this._name != null && this._type != null) {
            stringBuilder.append(" ");
        }
        if (this._type != null) {
            stringBuilder.append("(" + this._type + ")");
        }
        if (this._nullable) {
            stringBuilder.append("?");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getDisplay();
    }
}

