/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.AbstractRepository;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.util.FastURL;
import java.util.Collection;
import java.util.Set;
import org.openide.util.Lookup;

public abstract class TransformServerRegistry
extends AbstractRepository {
    public static TransformServerRegistry getDefault() {
        TransformServerRegistry transformServerRegistry = (TransformServerRegistry)Lookup.getDefault().lookup(TransformServerRegistry.class);
        if (transformServerRegistry == null) {
            transformServerRegistry = new DefaultTransformServerRegistry();
        }
        return transformServerRegistry;
    }

    public abstract Set<TransformServerInfo> findServers(String var1, boolean var2);

    public abstract boolean exists(String var1, boolean var2);

    public abstract void put(TransformServerInfo var1);

    public abstract TransformServerInfo get(FastURL var1);

    public abstract Collection<TransformServerInfo> getAll();

    public abstract void remove(FastURL var1);

    private static class DefaultTransformServerRegistry
    extends TransformServerRegistry {
        private DefaultTransformServerRegistry() {
        }

        @Override
        public Set<TransformServerInfo> findServers(String string, boolean bl) {
            throw new UnsupportedOperationException("No Server Registry has been registered.");
        }

        @Override
        public void put(TransformServerInfo transformServerInfo) {
            throw new UnsupportedOperationException("No Server Registry has been registered.");
        }

        @Override
        public TransformServerInfo get(FastURL fastURL) {
            throw new UnsupportedOperationException("No Server Registry has been registered.");
        }

        @Override
        public Collection<TransformServerInfo> getAll() {
            throw new UnsupportedOperationException("No Server Registry has been registered.");
        }

        @Override
        public void remove(FastURL fastURL) {
            throw new UnsupportedOperationException("No Server Registry has been registered.");
        }

        @Override
        public boolean exists(String string, boolean bl) {
            throw new UnsupportedOperationException("No Server Registry has been registered.");
        }
    }
}

