/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.masterfs.watcher.Notifier;

public class FAMNotifier
extends Notifier<Integer> {
    private final FAMLibrary.FAMConnection conn;
    private final FAMLibrary lib;
    private final Map<Integer, String> map = Collections.synchronizedMap(new HashMap());

    public FAMNotifier() {
        FAMLibrary library;
        try {
            library = (FAMLibrary)Native.loadLibrary((String)"gamin-1", FAMLibrary.class);
        }
        catch (LinkageError x) {
            library = (FAMLibrary)Native.loadLibrary((String)"fam", FAMLibrary.class);
        }
        this.lib = library;
        this.conn = new FAMLibrary.FAMConnection();
        if (this.lib.FAMOpen(this.conn) != 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Integer addWatch(String path) throws IOException {
        FAMLibrary.FAMRequest request = new FAMLibrary.FAMRequest();
        this.lib.FAMMonitorDirectory(this.conn, path, request, null);
        this.map.put(request.reqnum, path);
        return request.reqnum;
    }

    @Override
    public String nextEvent() throws IOException, InterruptedException {
        while (this.lib.FAMPending(this.conn) <= 0) {
            Thread.sleep(1000L);
        }
        FAMLibrary.FAMEvent evt = new FAMLibrary.FAMEvent();
        if (this.lib.FAMNextEvent(this.conn, evt) != -1) {
            String path = this.map.get(evt.fr.reqnum);
            return path;
        }
        return null;
    }

    @Override
    public void removeWatch(Integer key) throws IOException {
        this.lib.FAMCancelMonitor(this.conn, new FAMLibrary.FAMRequest(key));
        this.map.remove(key);
    }

    static interface FAMLibrary
    extends Library {
        public static final int PATH_MAX = 1024;
        public static final int FAMChanged = 1;
        public static final int FAMDeleted = 2;
        public static final int FAMStartExecuting = 3;
        public static final int FAMStopExecuting = 4;
        public static final int FAMCreated = 5;
        public static final int FAMMoved = 6;
        public static final int FAMAcknowledge = 7;
        public static final int FAMExists = 8;
        public static final int FAMEndExist = 9;

        public int FAMOpen(FAMConnection var1);

        public int FAMClose(FAMConnection var1);

        public int FAMMonitorDirectory(FAMConnection var1, String var2, FAMRequest var3, Pointer var4);

        public int FAMCancelMonitor(FAMConnection var1, FAMRequest var2);

        public int FAMPending(FAMConnection var1);

        public int FAMNextEvent(FAMConnection var1, FAMEvent var2);

        public static class FAMEvent
        extends Structure {
            public FAMConnection.Reference fc;
            public FAMRequest fr;
            public String hostname;
            public byte[] filename = new byte[1024];
            public Pointer userdata;
            public int code;
        }

        public static class FAMRequest
        extends Structure {
            public int reqnum;

            public FAMRequest() {
            }

            public FAMRequest(int reqnum) {
                this.reqnum = reqnum;
            }
        }

        public static class FAMConnection
        extends Structure {
            public int fd;
            public Pointer client;

            public static class Reference
            extends FAMConnection
            implements Structure.ByReference {
            }
        }
    }
}

