/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.Base64;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import sun.awt.image.BufferedImageGraphicsConfig;

public class ImageUtils {
    private ImageUtils() {
    }

    public static String getImageFile(String string, int n) {
        if (n == 16) {
            return string;
        }
        return ImageUtils.insertBeforeSuffix(string, n);
    }

    private static String insertBeforeSuffix(String string, int n) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        String string3 = "";
        if (string.lastIndexOf(46) >= 0) {
            string2 = string.substring(0, string.lastIndexOf(46));
            string3 = string.substring(string.lastIndexOf(46), string.length());
        }
        return string2 + n + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String base64Encode(Image image, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageUtils.base64Encode(image, string, byteArrayOutputStream);
            String string2 = byteArrayOutputStream.toString();
            return string2;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64Encode(Image image, String string, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = ImageUtils.createBufferedImage(image);
        Base64.OutputStream outputStream2 = null;
        try {
            outputStream2 = new Base64.OutputStream(outputStream);
            ImageIO.write((RenderedImage)bufferedImage, string, outputStream2);
        }
        finally {
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage base64Decode(InputStream inputStream) throws IOException {
        Base64.InputStream inputStream2 = null;
        try {
            inputStream2 = new Base64.InputStream(inputStream);
            BufferedImage bufferedImage = ImageIO.read(inputStream2);
            return bufferedImage;
        }
        finally {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage base64Decode(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            BufferedImage bufferedImage = ImageUtils.base64Decode(byteArrayInputStream);
            return bufferedImage;
        }
        finally {
            byteArrayInputStream.close();
        }
    }

    public static ImageIcon toImageIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        return new ImageIcon(ImageUtils.toImage(icon));
    }

    public static Image toImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = ImageUtils.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            headlessException.printStackTrace();
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = null;
        try {
            graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return bufferedImage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pixelGrabber.getColorModel().hasAlpha();
    }

    public static Image loadAndSize(File file, double d, double d2) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        return ImageUtils.smartSize(bufferedImage, d, d2);
    }

    public static Image loadAndSize(File file, double d) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        return ImageUtils.smartSize(bufferedImage, d);
    }

    private static BufferedImage resize(BufferedImage bufferedImage, double d, double d2) {
        int n = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
        BufferedImage bufferedImage2 = new BufferedImage((int)d, (int)d2, n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(bufferedImage, 0, 0, (int)d, (int)d2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage smartClip(BufferedImage bufferedImage, double d) {
        if ((double)bufferedImage.getWidth() > d || (double)bufferedImage.getHeight() > d) {
            return ImageUtils.smartSize(bufferedImage, d);
        }
        return bufferedImage;
    }

    public static BufferedImage smartClip(BufferedImage bufferedImage, double d, double d2) {
        if ((double)bufferedImage.getWidth() > d || (double)bufferedImage.getHeight() > d2) {
            return ImageUtils.smartSize(bufferedImage, d, d2);
        }
        return bufferedImage;
    }

    public static BufferedImage smartSize(BufferedImage bufferedImage, double d) {
        double d2;
        double d3;
        int n;
        int n2 = bufferedImage.getWidth();
        if (n2 > (n = bufferedImage.getHeight())) {
            d3 = d;
            double d4 = d / (double)n2;
            d2 = (double)n * d4;
        } else {
            d2 = d;
            double d5 = d / (double)n;
            d3 = (double)n2 * d5;
        }
        return ImageUtils.smartSize(bufferedImage, d3, d2);
    }

    public static BufferedImage smartSize(BufferedImage bufferedImage, double d, double d2) {
        bufferedImage = ImageUtils.createCompatibleImage(bufferedImage);
        bufferedImage = ImageUtils.resize(bufferedImage, d * 4.0, d2 * 4.0);
        bufferedImage = ImageUtils.blurImage(bufferedImage);
        return ImageUtils.resize(bufferedImage, d, d2);
    }

    private static BufferedImage blurImage(BufferedImage bufferedImage) {
        float f = 0.11111111f;
        float[] fArray = new float[]{f, f, f, f, f, f, f, f, f};
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RenderingHints renderingHints = new RenderingHints(hashMap);
        ConvolveOp convolveOp = new ConvolveOp(new Kernel(3, 3, fArray), 1, renderingHints);
        return convolveOp.filter(bufferedImage, null);
    }

    private static BufferedImage createCompatibleImage(BufferedImage bufferedImage) {
        BufferedImageGraphicsConfig bufferedImageGraphicsConfig = BufferedImageGraphicsConfig.getConfig(bufferedImage);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = bufferedImageGraphicsConfig.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawRenderedImage(bufferedImage, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFormatName(Object object) {
        block16: {
            String string;
            ImageInputStream imageInputStream = null;
            try {
                imageInputStream = ImageIO.createImageInputStream(object);
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                if (!iterator.hasNext()) {
                    String string2 = null;
                    return string2;
                }
                ImageReader imageReader = iterator.next();
                string = imageReader.getFormatName();
            }
            catch (IOException iOException) {
                break block16;
            }
            finally {
                if (imageInputStream != null) {
                    try {
                        imageInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return string;
        }
        return null;
    }
}

