/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import com.paterva.maltego.util.XmlSerializationException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Map;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;

public class XmlSerializer {
    public void write(Object object, OutputStream outputStream) throws XmlSerializationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Serializer.class.getClassLoader());
            Serializer serializer = XmlSerializer.createSerializer();
            serializer.write(object, outputStream);
        }
        catch (Exception exception) {
            throw new XmlSerializationException(exception.getMessage(), exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public <T> T read(Class<? extends T> clazz, InputStream inputStream) throws XmlSerializationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Serializer.class.getClassLoader());
            Serializer serializer = XmlSerializer.createSerializer();
            Object object = serializer.read(clazz, inputStream);
            return (T)object;
        }
        catch (Exception exception) {
            throw new XmlSerializationException(exception.getMessage(), exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public <T> T read(Class<? extends T> clazz, Reader reader) throws XmlSerializationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Serializer.class.getClassLoader());
            Serializer serializer = XmlSerializer.createSerializer();
            Object object = serializer.read(clazz, reader);
            return (T)object;
        }
        catch (Exception exception) {
            throw new XmlSerializationException(exception.getMessage(), exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static Serializer createSerializer() {
        return new Persister((Strategy)new RemoveClassStrategy());
    }

    private static class RemoveClassStrategy
    implements Strategy {
        private TreeStrategy _delegate = new TreeStrategy();

        private RemoveClassStrategy() {
        }

        public Value read(Type type, NodeMap<InputNode> nodeMap, Map map) throws Exception {
            return this._delegate.read(type, nodeMap, map);
        }

        public boolean write(Type type, Object object, NodeMap<OutputNode> nodeMap, Map map) throws Exception {
            boolean bl = this._delegate.write(type, object, nodeMap, map);
            nodeMap.remove("class");
            return bl;
        }
    }
}

