/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.merging;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.merging.EntityFilter;
import com.paterva.maltego.merging.GraphMatchStrategy;
import com.paterva.maltego.merging.GraphMergeCallback;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.util.HashMap;
import java.util.Map;
import yguard.A.A.D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface GraphMerger {
    public void setGraphs(GraphWrapper var1, MaltegoGraph var2, EntityFilter var3);

    public Map<MaltegoEntity, MaltegoEntity> getMatches();

    public void append();

    public Map<MaltegoEntity, MaltegoEntity> getMapping();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Strategic
    implements GraphMerger {
        private GraphWrapper _destGraph;
        private MaltegoGraph _srcGraph;
        private GraphMatchStrategy _graphMatchStrat;
        private GraphMergeStrategy _graphMergeStrat;
        private GraphMergeCallback _cb;
        private Map<MaltegoEntity, MaltegoEntity> _entityMatches;
        private Map<MaltegoEntity, MaltegoEntity> _entityMap;
        private EntityFilter _filter;

        public Strategic(GraphMatchStrategy graphMatchStrategy, GraphMergeStrategy graphMergeStrategy, GraphMergeCallback graphMergeCallback) {
            this._graphMatchStrat = graphMatchStrategy;
            this._graphMergeStrat = graphMergeStrategy;
            this._cb = graphMergeCallback;
        }

        @Override
        public void setGraphs(GraphWrapper graphWrapper, MaltegoGraph maltegoGraph, EntityFilter entityFilter) {
            this._destGraph = graphWrapper;
            this._srcGraph = maltegoGraph;
            this._entityMatches = null;
            this._entityMap = null;
            this._filter = entityFilter;
        }

        @Override
        public Map<MaltegoEntity, MaltegoEntity> getMatches() {
            if (this._entityMatches == null) {
                this._entityMatches = new HashMap<MaltegoEntity, MaltegoEntity>();
                for (MaltegoEntity maltegoEntity : this._srcGraph.entities()) {
                    MaltegoEntity maltegoEntity2 = this.findEntity(maltegoEntity);
                    if (maltegoEntity2 == null) continue;
                    this._entityMatches.put(maltegoEntity, maltegoEntity2);
                }
            }
            return this._entityMatches;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void append() {
            this._destGraph.beginUpdate();
            try {
                this.appendEntities();
                this.appendLinks();
            }
            finally {
                this._destGraph.endUpdate();
            }
        }

        @Override
        public Map<MaltegoEntity, MaltegoEntity> getMapping() {
            return this._entityMap;
        }

        private void appendEntities() {
            this._entityMap = new HashMap<MaltegoEntity, MaltegoEntity>(this._srcGraph.entityCount());
            for (MaltegoEntity maltegoEntity : this._srcGraph.entities()) {
                if (this._filter != null && !this._filter.accept(maltegoEntity)) continue;
                MaltegoEntity maltegoEntity2 = this.tryMergeEntity(maltegoEntity);
                if (maltegoEntity2 == null) {
                    maltegoEntity2 = this.transferEntity(maltegoEntity);
                }
                this._entityMap.put(maltegoEntity, maltegoEntity2);
            }
        }

        private void appendLinks() {
            for (MaltegoLink maltegoLink : this._srcGraph.links()) {
                MaltegoLink maltegoLink2 = this.tryMergeLink(maltegoLink);
                if (maltegoLink2 != null) continue;
                this.transferLink(maltegoLink);
            }
        }

        private MaltegoEntity tryMergeEntity(MaltegoEntity maltegoEntity) {
            PartMergeStrategy partMergeStrategy;
            MaltegoEntity maltegoEntity2 = this.getMatches().get(maltegoEntity);
            if (maltegoEntity2 != null && (partMergeStrategy = this._graphMergeStrat.getEntityMergeStrategy(maltegoEntity2, maltegoEntity)) != null) {
                partMergeStrategy.merge((MaltegoPart)maltegoEntity2, (MaltegoPart)maltegoEntity);
                if (this._cb != null) {
                    this._cb.onEntitiesMerged(maltegoEntity2, maltegoEntity);
                }
                return maltegoEntity2;
            }
            return null;
        }

        private MaltegoLink tryMergeLink(MaltegoLink maltegoLink) {
            PartMergeStrategy partMergeStrategy;
            MaltegoLink maltegoLink2 = this.findLink(maltegoLink);
            if (maltegoLink2 != null && (partMergeStrategy = this._graphMergeStrat.getLinkMergeStrategy(maltegoLink2, maltegoLink)) != null) {
                partMergeStrategy.merge((MaltegoPart)maltegoLink2, (MaltegoPart)maltegoLink);
                if (this._cb != null) {
                    this._cb.onLinksMerged(maltegoLink2, maltegoLink);
                }
                return maltegoLink2;
            }
            return null;
        }

        private MaltegoEntity transferEntity(MaltegoEntity maltegoEntity) {
            MaltegoEntity maltegoEntity2 = maltegoEntity.createCopy();
            this._destGraph.addAsNode(maltegoEntity2);
            if (this._cb != null) {
                this._cb.onEntityTransferred(maltegoEntity2, maltegoEntity);
            }
            return maltegoEntity2;
        }

        private MaltegoLink transferLink(MaltegoLink maltegoLink) {
            MaltegoLink maltegoLink2 = maltegoLink.createCopy();
            MaltegoEntity maltegoEntity = this._entityMap.get(this._srcGraph.source(maltegoLink));
            MaltegoEntity maltegoEntity2 = this._entityMap.get(this._srcGraph.target(maltegoLink));
            if (maltegoEntity != null && maltegoEntity2 != null && !maltegoEntity.equals(maltegoEntity2)) {
                this._destGraph.connect(maltegoEntity, maltegoEntity2, maltegoLink2);
                if (this._cb != null) {
                    this._cb.onLinkTransferred(maltegoLink2, maltegoLink);
                }
            }
            return maltegoLink2;
        }

        private MaltegoEntity findEntity(MaltegoEntity maltegoEntity) {
            MaltegoEntity maltegoEntity2 = this._destGraph.getEntity(maltegoEntity.getID());
            if (maltegoEntity2 != null) {
                return maltegoEntity2;
            }
            for (MaltegoEntity maltegoEntity3 : this._destGraph.entities()) {
                MatchingRule matchingRule;
                if (!this.isMatch((MaltegoPart)maltegoEntity3, (MaltegoPart)maltegoEntity, matchingRule = this._graphMatchStrat.getMatchingRule(maltegoEntity3, maltegoEntity))) continue;
                return maltegoEntity3;
            }
            return null;
        }

        private MaltegoLink findLink(MaltegoLink maltegoLink) {
            MaltegoEntity maltegoEntity = this._entityMap.get(this._srcGraph.source(maltegoLink));
            MaltegoEntity maltegoEntity2 = this._entityMap.get(this._srcGraph.target(maltegoLink));
            if (maltegoEntity != null && maltegoEntity2 != null) {
                for (MaltegoLink maltegoLink2 : this._destGraph.outgoing(maltegoEntity)) {
                    for (MaltegoLink maltegoLink3 : this._destGraph.incoming(maltegoEntity2)) {
                        MatchingRule matchingRule;
                        if (!maltegoLink2.equals(maltegoLink3) || !this.isMatch((MaltegoPart)maltegoLink2, (MaltegoPart)maltegoLink, matchingRule = this._graphMatchStrat.getMatchingRule(maltegoLink2, maltegoLink))) continue;
                        return maltegoLink2;
                    }
                }
            }
            return null;
        }

        private boolean isMatch(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, MatchingRule matchingRule) {
            SpecRegistry specRegistry;
            int n;
            return matchingRule != null && (n = matchingRule.match(specRegistry = this.getRegistry(maltegoPart), (TypedPropertyBag)maltegoPart, (TypedPropertyBag)maltegoPart2)) == 1;
        }

        private SpecRegistry getRegistry(MaltegoPart maltegoPart) {
            EntityRegistry entityRegistry = null;
            if (maltegoPart instanceof MaltegoEntity) {
                entityRegistry = EntityRegistry.forGraph((D)this._destGraph.getGraph());
            } else if (maltegoPart instanceof MaltegoLink) {
                entityRegistry = LinkRegistry.getDefault();
            }
            return entityRegistry;
        }
    }
}

