/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.merging;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import org.openide.util.Utilities;

public class MergeUtils {
    public static void addMissingProperties(MaltegoPart maltegoPart, MaltegoPart maltegoPart2) {
        for (PropertyDescriptor propertyDescriptor : maltegoPart2.getProperties()) {
            if (maltegoPart.getProperties().contains(propertyDescriptor)) continue;
            maltegoPart.addProperty(propertyDescriptor);
        }
    }

    public static void removeExtraProperties(MaltegoPart maltegoPart, MaltegoPart maltegoPart2) {
        for (PropertyDescriptor propertyDescriptor : maltegoPart.getProperties()) {
            if (maltegoPart2.getProperties().contains(propertyDescriptor)) continue;
            maltegoPart.removeProperty(propertyDescriptor);
        }
    }

    public static void replaceProperties(MaltegoPart maltegoPart, MaltegoPart maltegoPart2) {
        maltegoPart.getProperties().clear();
        maltegoPart.getProperties().addAll(maltegoPart2.getProperties());
    }

    public static void mergePropertyValues(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, boolean bl) {
        MergeUtils.copyCalculatedPropertyValues(maltegoPart, maltegoPart2, bl);
        MergeUtils.copyNonCalculatedPropertyValues(maltegoPart, maltegoPart2, bl, false);
    }

    public static void replacePropertyValues(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, boolean bl) {
        MergeUtils.copyCalculatedPropertyValues(maltegoPart, maltegoPart2, bl);
        MergeUtils.copyNonCalculatedPropertyValues(maltegoPart, maltegoPart2, bl, true);
    }

    public static void copyCalculatedPropertyValues(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, boolean bl) {
        for (PropertyDescriptor propertyDescriptor : maltegoPart2.getProperties()) {
            Object object;
            Object object2;
            if (!MergeUtils.isCalculated(propertyDescriptor) || MergeUtils.destIsBetter(object2 = maltegoPart2.getValue(propertyDescriptor), object = maltegoPart.getValue(propertyDescriptor)) || !bl && !MergeUtils.isNullOrEmpty(object)) continue;
            maltegoPart.setValue(propertyDescriptor, object2);
        }
    }

    public static void copyNonCalculatedPropertyValues(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, boolean bl, boolean bl2) {
        for (PropertyDescriptor propertyDescriptor : maltegoPart2.getProperties()) {
            Object object;
            Object object2;
            if (MergeUtils.isCalculated(propertyDescriptor) || MergeUtils.destIsBetter(object2 = maltegoPart2.getValue(propertyDescriptor), object = maltegoPart.getValue(propertyDescriptor))) continue;
            if (!bl2 && Attachments.class.equals((Object)propertyDescriptor.getType()) && object != null) {
                MergeUtils.mergeAttachments((Attachments)object, (Attachments)object2, bl);
                continue;
            }
            if (!bl && !MergeUtils.isNullOrEmpty(object)) continue;
            maltegoPart.setValue(propertyDescriptor, object2);
        }
    }

    private static void mergeAttachments(Attachments attachments, Attachments attachments2, boolean bl) {
        for (Attachment attachment : attachments2) {
            if (attachments.contains((Object)attachment)) continue;
            attachments.add((Object)attachment);
        }
        if (bl) {
            attachments.setPrimaryImage(attachments2.getPrimaryImage());
        }
    }

    public static void mergeSpecialPropertyMapping(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, boolean bl) {
        maltegoPart.setDisplayValueProperty(MergeUtils.nonNull(maltegoPart.getDisplayValueProperty(), maltegoPart2.getDisplayValueProperty(), bl));
        maltegoPart.setValueProperty(MergeUtils.nonNull(maltegoPart.getValueProperty(), maltegoPart2.getValueProperty(), bl));
        if (maltegoPart instanceof MaltegoEntity) {
            MaltegoEntity maltegoEntity = (MaltegoEntity)maltegoPart;
            MaltegoEntity maltegoEntity2 = (MaltegoEntity)maltegoPart2;
            maltegoEntity.setImageProperty(MergeUtils.nonNull(maltegoEntity.getImageProperty(), maltegoEntity2.getImageProperty(), bl));
        }
    }

    public static void copySpecialPropertyMapping(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, boolean bl) {
        maltegoPart.setDisplayValueProperty(maltegoPart2.getDisplayValueProperty());
        maltegoPart.setValueProperty(maltegoPart2.getValueProperty());
        if (maltegoPart instanceof MaltegoEntity) {
            MaltegoEntity maltegoEntity = (MaltegoEntity)maltegoPart;
            MaltegoEntity maltegoEntity2 = (MaltegoEntity)maltegoPart2;
            maltegoEntity.setImageProperty(maltegoEntity2.getImageProperty());
        }
    }

    public static void mergeDisplayInformation(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, boolean bl) {
        DisplayInformationCollection displayInformationCollection = maltegoPart2.getDisplayInformation();
        DisplayInformationCollection displayInformationCollection2 = maltegoPart.getDisplayInformation();
        for (DisplayInformation displayInformation : displayInformationCollection) {
            boolean bl2 = false;
            for (DisplayInformation displayInformation2 : displayInformationCollection2) {
                if (!displayInformation.getName().equals(displayInformation2.getName()) || !Utilities.compareObjects((Object)displayInformation.getValue(), (Object)displayInformation2.getValue())) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            displayInformationCollection2.add(displayInformation);
        }
        maltegoPart.setDisplayInformation(displayInformationCollection2);
    }

    public static void mergeNotes(MaltegoPart maltegoPart, MaltegoPart maltegoPart2, boolean bl) {
        String string = bl ? maltegoPart2.getNotes() : maltegoPart.getNotes();
        String string2 = bl ? maltegoPart.getNotes() : maltegoPart2.getNotes();
        String string3 = null;
        if (!MergeUtils.isNullOrEmpty(string)) {
            string3 = string;
        }
        if (!MergeUtils.isNullOrEmpty(string2)) {
            string3 = !MergeUtils.isNullOrEmpty(string3) ? string3 + "\n" + string2 : string2;
        }
        maltegoPart.setNotes(string3);
    }

    public static boolean isCalculated(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getLinkedProperties().size() > 0;
    }

    public static PropertyDescriptor nonNull(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2, boolean bl) {
        PropertyDescriptor propertyDescriptor3 = bl ? propertyDescriptor2 : propertyDescriptor;
        PropertyDescriptor propertyDescriptor4 = bl ? propertyDescriptor : propertyDescriptor2;
        return propertyDescriptor3 != null ? propertyDescriptor3 : propertyDescriptor4;
    }

    public static boolean destIsBetter(Object object, Object object2) {
        return object == null || MergeUtils.isEmpty(object) && object2 != null;
    }

    public static boolean isNullOrEmpty(Object object) {
        return object == null || MergeUtils.isEmpty(object);
    }

    public static boolean isEmpty(Object object) {
        if (object instanceof String) {
            return ((String)object).isEmpty();
        }
        return false;
    }
}

