/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.login;

import com.paterva.maltego.typing.editing.inputform.InputForm;
import com.paterva.maltego.typing.editing.inputform.InputFormSerializer;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.http.HttpAgent;
import com.paterva.maltego.welcome.login.ErrorPanel;
import com.paterva.maltego.welcome.login.LoginControl;
import com.paterva.maltego.welcome.login.LoginSegment;
import com.paterva.maltego.welcome.login.Utils;
import java.io.IOException;
import java.net.URL;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;

class LoginRequestController
extends PassFailProgressController<InputForm, LoginControl, ErrorPanel> {
    LoginRequestController() {
    }

    protected InputForm doProcessing(WizardDescriptor wizardDescriptor, ProgressHandle progressHandle) throws IOException {
        URL uRL = (URL)wizardDescriptor.getProperty("loginRequestUrl");
        HttpAgent httpAgent = new HttpAgent(uRL);
        httpAgent.setTrustAllCerts(false);
        httpAgent.setRequireCNSuffix(".paterva.com");
        httpAgent.doGet();
        String string = httpAgent.getContentAsString();
        string = Utils.stripMessageHeader(string);
        InputForm inputForm = new InputFormSerializer().readForm(string);
        String string2 = NbPreferences.forModule(LoginSegment.class).get("maltego.ce.username", "");
        inputForm.setValue("username", (Object)string2);
        return inputForm;
    }

    protected LoginControl createPassComponent() {
        return new LoginControl();
    }

    protected ErrorPanel createFailComponent() {
        return new ErrorPanel("Login server could not be contacted!");
    }

    protected void pass(WizardDescriptor wizardDescriptor, LoginControl loginControl, InputForm inputForm) {
        loginControl.setRegistrationUrl((URL)wizardDescriptor.getProperty("registrationUrl"));
        loginControl.setForm(inputForm);
        wizardDescriptor.putProperty("loginForm", (Object)inputForm);
    }

    protected void fail(ErrorPanel errorPanel, Exception exception) {
        if (exception == null) {
            errorPanel.setError(null);
        } else {
            errorPanel.setError(exception.getMessage());
        }
    }
}

