/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import org.officelaf.ribbon.CollapsedBandIcon;
import org.officelaf.ribbon.OfficeCommandButtonUI;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;

public class OfficeRibbonBandUI
extends BasicRibbonBandUI {
    protected static final Color borderColor1 = new Color(0xB6B7B7);
    protected static final Color borderColor2 = new Color(0x818181);
    protected static final Color highlightColor = new Color(255, 255, 255, 127);
    protected static final Color titleBg1 = new Color(0xB6B8B8);
    protected static final Color titleBg2 = new Color(0x9C9E9E);
    protected static final Color titleBg1_over = new Color(0xAAABAB);
    protected static final Color titleBg2_over = new Color(0x6D6E6E);
    boolean isUnderMouse = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OfficeRibbonBandUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.ribbonBand.setOpaque(Boolean.FALSE.booleanValue());
        this.ribbonBand.setForeground((Color)new ColorUIResource(Color.WHITE));
    }

    protected void installComponents() {
        super.installComponents();
        CollapsedBandIcon collapsedBandIcon = new CollapsedBandIcon((Icon)this.ribbonBand.getIcon());
        this.collapsedButton.setUI((CommandButtonUI)new CollapsedRibbonBandButtonUI());
        this.collapsedButton.setIcon((ResizableIcon)collapsedBandIcon);
        this.collapsedButton.setDisabledIcon((ResizableIcon)collapsedBandIcon);
    }

    protected void paintBandBackground(Graphics graphics, Rectangle rectangle) {
        if (this.ribbonBand.getCurrentResizePolicy() instanceof IconRibbonBandResizePolicy) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = rectangle.y;
        int n2 = rectangle.x;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = n + n4 - 1;
        int n6 = n2 + n3 - 2;
        int n7 = n6 - 3;
        int n8 = n2 + 3;
        int n9 = n + n4 - 2;
        int n10 = n9 - 3;
        int n11 = n + 3;
        if (this.isUnderMouse) {
            graphics2D.setColor(highlightColor);
            graphics2D.fillRect(n2 + 1, n + 1, n3 - 3, n4 - 3);
        }
        graphics2D.setPaint(new LinearGradientPaint(n2, n, n2, n9, new float[]{0.0f, 1.0f}, new Color[]{borderColor1, borderColor2}));
        graphics2D.drawLine(n8, n, n7, n);
        graphics2D.drawLine(n2, n11, n2, n10);
        graphics2D.drawLine(n8, n9, n7, n9);
        graphics2D.drawLine(n6, n11, n6, n10);
        graphics2D.drawLine(n2, n11 - 1, n8 - 1, n);
        graphics2D.drawLine(n7 + 1, n, n6, n11 - 1);
        graphics2D.drawLine(n6, n10 + 1, n7 + 1, n9);
        graphics2D.drawLine(n2, n10 + 1, n8 - 1, n9);
        graphics2D.setColor(highlightColor);
        graphics2D.drawLine(n8, n + 1, n7 + 1, n + 1);
        graphics2D.drawLine(n6 + 1, n11 - 1, n6 + 1, n9 - 2);
        graphics2D.drawLine(n2 + 1, n11, n2 + 1, n10 + 1);
        graphics2D.drawLine(n2 + 1, n11 - 1, n8 - 1, n + 1);
        graphics2D.drawLine(n6 + 1, n9 - 1, n6 - 1, n9 + 1);
        if (this.isUnderMouse) {
            graphics2D.drawLine(n8, n5, n7 + 1, n5);
        } else {
            graphics2D.drawLine((int)((double)(n7 + 1) * 0.25), n9 + 1, n7 + 1, n9 + 1);
        }
        int n12 = this.getBandTitleHeight();
        Rectangle rectangle2 = new Rectangle(n2 + 1, n + n4 - n12, n3 - 3, n12 - 2);
        Color color = this.isUnderMouse ? titleBg1_over : titleBg1;
        Color color2 = this.isUnderMouse ? titleBg2_over : titleBg2;
        graphics2D.setPaint(new GradientPaint(rectangle2.x, rectangle2.y, color, rectangle2.x, (float)rectangle2.getMaxY() - 1.0f, color2));
        graphics2D.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height - 1);
        graphics2D.drawLine(rectangle2.x + 1, (int)rectangle2.getMaxY() - 1, (int)rectangle2.getMaxX() - 2, (int)rectangle2.getMaxY() - 1);
        graphics2D.dispose();
    }

    public void trackMouseCrossing(boolean bl) {
        super.trackMouseCrossing(bl);
        this.isUnderMouse = bl;
    }

    protected void paintBandTitleBackground(Graphics graphics, Rectangle rectangle, String string) {
    }

    protected LayoutManager createLayoutManager() {
        return new RibbonBandLayout();
    }

    public static class CollapsedRibbonBandButtonUI
    extends OfficeCommandButtonUI {
        @Override
        protected void paintButtonBackground(Graphics graphics, Rectangle rectangle) {
            this.painter.paintCollapsedBandButtonBackground(graphics, rectangle);
        }

        protected boolean isPaintingBackground() {
            return true;
        }
    }

    private class RibbonBandLayout
    implements LayoutManager {
        private RibbonBandLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            AbstractBandControlPanel abstractBandControlPanel = OfficeRibbonBandUI.this.ribbonBand.getControlPanel();
            boolean bl = abstractBandControlPanel == null || !abstractBandControlPanel.isVisible();
            int n = bl ? ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getPreferredSize().width : abstractBandControlPanel.getPreferredSize().width;
            int n2 = (bl ? ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getPreferredSize().height : abstractBandControlPanel.getPreferredSize().height) + OfficeRibbonBandUI.this.getBandTitleHeight();
            return new Dimension(n + 2 + (!bl ? insets.left + insets.right : 0), n2 + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            AbstractBandControlPanel abstractBandControlPanel = OfficeRibbonBandUI.this.ribbonBand.getControlPanel();
            boolean bl = abstractBandControlPanel == null || !abstractBandControlPanel.isVisible();
            int n = bl ? ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getMinimumSize().width : abstractBandControlPanel.getMinimumSize().width;
            int n2 = bl ? ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getMinimumSize().height + OfficeRibbonBandUI.this.getBandTitleHeight() : abstractBandControlPanel.getMinimumSize().height + OfficeRibbonBandUI.this.getBandTitleHeight();
            return new Dimension(n + 2 + (!bl ? insets.left + insets.right : 0), n2 + insets.top + insets.bottom);
        }

        @Override
        public void layoutContainer(Container container) {
            AbstractBandControlPanel abstractBandControlPanel;
            if (!container.isVisible()) {
                return;
            }
            Insets insets = container.getInsets();
            int n = container.getHeight() - insets.top - insets.bottom;
            RibbonBandResizePolicy ribbonBandResizePolicy = ((AbstractRibbonBand)container).getCurrentResizePolicy();
            if (ribbonBandResizePolicy instanceof IconRibbonBandResizePolicy) {
                OfficeRibbonBandUI.this.collapsedButton.setVisible(true);
                int n2 = ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).collapsedButton.getPreferredSize().width;
                OfficeRibbonBandUI.this.collapsedButton.setBounds(0, 0, container.getWidth(), container.getHeight());
                if (OfficeRibbonBandUI.this.collapsedButton.getPopupCallback() == null) {
                    final AbstractRibbonBand abstractRibbonBand = OfficeRibbonBandUI.this.ribbonBand.cloneBand();
                    abstractRibbonBand.setControlPanel(OfficeRibbonBandUI.this.ribbonBand.getControlPanel());
                    List list = OfficeRibbonBandUI.this.ribbonBand.getResizePolicies();
                    abstractRibbonBand.setResizePolicies(list);
                    RibbonBandResizePolicy ribbonBandResizePolicy2 = (RibbonBandResizePolicy)list.get(0);
                    abstractRibbonBand.setCurrentResizePolicy(ribbonBandResizePolicy2);
                    final Dimension dimension = new Dimension(4 + ribbonBandResizePolicy2.getPreferredWidth(n, 4), insets.top + insets.bottom + Math.max(container.getHeight(), ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).ribbonBand.getControlPanel().getPreferredSize().height + OfficeRibbonBandUI.this.getBandTitleHeight()));
                    OfficeRibbonBandUI.this.collapsedButton.setPopupCallback(new PopupPanelCallback(){

                        public JPopupPanel getPopupPanel(JCommandButton jCommandButton) {
                            return new BasicRibbonBandUI.CollapsedButtonPopupPanel((Component)abstractRibbonBand, dimension);
                        }
                    });
                    OfficeRibbonBandUI.this.ribbonBand.setControlPanel(null);
                    OfficeRibbonBandUI.this.ribbonBand.setPopupRibbonBand(abstractRibbonBand);
                }
                if (OfficeRibbonBandUI.this.expandButton != null) {
                    OfficeRibbonBandUI.this.expandButton.setBounds(0, 0, 0, 0);
                }
                return;
            }
            if (OfficeRibbonBandUI.this.collapsedButton.isVisible()) {
                Object object = abstractBandControlPanel = OfficeRibbonBandUI.this.collapsedButton.getPopupCallback() != null ? (BasicRibbonBandUI.CollapsedButtonPopupPanel)OfficeRibbonBandUI.this.collapsedButton.getPopupCallback().getPopupPanel(OfficeRibbonBandUI.this.collapsedButton) : null;
                if (abstractBandControlPanel != null) {
                    AbstractRibbonBand abstractRibbonBand = (AbstractRibbonBand)abstractBandControlPanel.removeComponent();
                    OfficeRibbonBandUI.this.ribbonBand.setControlPanel(abstractRibbonBand.getControlPanel());
                    OfficeRibbonBandUI.this.ribbonBand.setPopupRibbonBand(null);
                    OfficeRibbonBandUI.this.collapsedButton.setPopupCallback(null);
                }
            }
            OfficeRibbonBandUI.this.collapsedButton.setVisible(false);
            abstractBandControlPanel = OfficeRibbonBandUI.this.ribbonBand.getControlPanel();
            abstractBandControlPanel.setVisible(true);
            abstractBandControlPanel.setBounds(insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - OfficeRibbonBandUI.this.getBandTitleHeight() - insets.top - insets.bottom);
            abstractBandControlPanel.doLayout();
            if (OfficeRibbonBandUI.this.expandButton != null) {
                int n3 = ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).expandButton.getPreferredSize().width;
                int n4 = ((OfficeRibbonBandUI)OfficeRibbonBandUI.this).expandButton.getPreferredSize().height;
                int n5 = OfficeRibbonBandUI.this.getBandTitleHeight() - 4;
                if (n4 > n5) {
                    n4 = n5;
                }
                int n6 = container.getHeight() - (OfficeRibbonBandUI.this.getBandTitleHeight() - n4) / 2;
                OfficeRibbonBandUI.this.expandButton.setBounds(container.getWidth() - insets.right - n3, n6 - n4, n3, n4);
            }
        }
    }
}

