/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.ribbon;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.officelaf.util.CommandButtonPainter;
import org.officelaf.util.HighlightFactory;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonTaskToggleButtonUI;

public class OfficeRibbonTaskToggleButtonUI
extends BasicRibbonTaskToggleButtonUI {
    private static final Color normalBackground = new Color(7433311);
    private static final Color normalBorder = new Color(0x969695);
    private static final Color normalBorderShadow = new Color(0x909090);
    private static final Color normalHighlight = new Color(15516456);
    private static final Color normalHighlight2 = new Color(0x989896);
    private static final Color selectedBackground1 = new Color(0xF1F2F2);
    private static final Color selectedBackground2 = new Color(14080479);
    private static final Color selectedHighlight1 = new Color(255, 255, 255, 104);
    private static final Color selectedHighlight2 = new Color(255, 255, 255, 41);
    private static final Color selectedBorder = new Color(0xBEBEBE);
    private static final Color selectedBorderShadow = new Color(0xC0C2C2);
    private static final Color selectedBorder2 = new Color(190, 190, 190, 127);
    private static final Color selectedBorder3 = new Color(190, 190, 190, 13);
    private static final Color cyan = new Color(13105918);
    private static final Color cyan_127 = OfficeRibbonTaskToggleButtonUI.getAlpha(cyan, 127);
    private static final Color cyan_0 = OfficeRibbonTaskToggleButtonUI.getAlpha(cyan, 0);
    private static final Color balck_17 = new Color(0, 0, 0, 17);
    private static final Color black_0 = new Color(0, 0, 0, 0);
    private PropertyChangeListener officePropertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OfficeRibbonTaskToggleButtonUI();
    }

    protected void installDefaults() {
        super.installDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        this.officePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("contextualGroupHueColor".equals(propertyChangeEvent.getPropertyName())) {
                    Color color = (Color)propertyChangeEvent.getNewValue();
                    OfficeRibbonTaskToggleButtonUI.this.commandButton.setBackground(color);
                }
            }
        };
        this.commandButton.addPropertyChangeListener(this.officePropertyChangeListener);
    }

    protected void uninstallListeners() {
        this.commandButton.removePropertyChangeListener(this.officePropertyChangeListener);
        this.officePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected Color getForegroundColor(boolean bl) {
        return bl ? CommandButtonPainter.TEXT_COLOR : CommandButtonPainter.DISABLED_TEXT_COLOR;
    }

    protected void paintButtonBackground(Graphics graphics, Rectangle rectangle) {
        ActionButtonModel actionButtonModel = this.commandButton.getActionModel();
        rectangle.height -= 10;
        if (actionButtonModel.isArmed() && actionButtonModel.isPressed() || actionButtonModel.isSelected()) {
            this.paintSelectedBackground(graphics, this.commandButton, rectangle);
            graphics.setColor(Color.BLACK);
        } else {
            this.paintNormalBackground(graphics, this.commandButton, rectangle);
            graphics.setColor(Color.WHITE);
        }
    }

    protected void paintNormalBackground(Graphics graphics, AbstractCommandButton abstractCommandButton, Rectangle rectangle) {
        if (!abstractCommandButton.getActionModel().isRollover()) {
            return;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(normalBackground);
        graphics2D.fillRect(n + 3, n2 + 1, rectangle.width - 6, rectangle.height - 2);
        this.drawBorder(graphics2D, normalBorder, normalBorderShadow, n, n2, n3, n4);
        int n5 = (int)((double)rectangle.height * 0.9);
        Shape shape = graphics2D.getClip();
        BufferedImage bufferedImage = HighlightFactory.createHighlight(normalHighlight, rectangle.width, n5);
        graphics2D.setClip(n + 2, n2, rectangle.width - 4, rectangle.height - 1);
        graphics2D.drawImage((Image)bufferedImage, n, n4 - n5 / 2, null);
        bufferedImage = HighlightFactory.createHighlight(normalHighlight2, rectangle.width + 16, n5);
        graphics2D.setClip(n + 3, n2 + 1, rectangle.width - 6, rectangle.height - 2);
        graphics2D.drawImage((Image)bufferedImage, n - 8, n2 - n5 / 2, null);
        graphics2D.setClip(shape);
    }

    protected void paintSelectedBackground(Graphics graphics, AbstractCommandButton abstractCommandButton, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        graphics2D.setPaint(new LinearGradientPaint(n, n2 + 1, n, n4, new float[]{0.0f, 1.0f}, new Color[]{selectedBackground1, selectedBackground2}));
        graphics2D.fillRect(n + 3, n2 + 1, rectangle.width - 6, rectangle.height - 2);
        graphics2D.drawLine(n + 2, n4, n3 - 2, n4);
        Color color = selectedHighlight1;
        Color color2 = selectedHighlight2;
        graphics2D.setColor(color);
        graphics2D.fillRect(n + 3, n2 + 1, rectangle.width - 6, 3);
        graphics2D.fillRect(n + 3, n2 + 4, 2, rectangle.height - 6);
        graphics2D.fillRect(n3 - 4, n2 + 4, 2, rectangle.height - 6);
        graphics2D.setColor(color2);
        graphics2D.drawLine(n + 3, n4 - 1, n + 4, n4 - 1);
        graphics2D.drawLine(n + 2, n4, n + 3, n4);
        graphics2D.drawLine(n3 - 3, n4 - 1, n3 - 4, n4 - 1);
        graphics2D.drawLine(n3 - 2, n4, n3 - 3, n4);
        this.drawBorder(graphics2D, selectedBorder, selectedBorderShadow, n, n2, n3, n4);
        Color color3 = selectedBorder2;
        Color color4 = selectedBorder3;
        graphics2D.setColor(color3);
        graphics2D.drawLine(n + 1, n4 - 1, n + 1, n4 - 1);
        graphics2D.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 - 1);
        graphics2D.setColor(color4);
        graphics2D.drawLine(n, n4 - 1, n, n4 - 1);
        graphics2D.drawLine(n3, n4 - 1, n3, n4 - 1);
        graphics2D.drawLine(n + 1, n4 - 2, n + 1, n4 - 2);
        graphics2D.drawLine(n3 - 1, n4 - 2, n3 - 1, n4 - 2);
        graphics2D.setColor(cyan);
        graphics2D.drawLine(n + 3, n2 + 3, n + 3, n4 - 2);
        graphics2D.setColor(cyan_127);
        graphics2D.drawLine(n + 3, n2 + 2, n + 3, n2 + 2);
        graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n2 + 7, new float[]{0.0f, 1.0f}, new Color[]{cyan_0, cyan}));
        graphics2D.drawLine(n3 - 3, n2 + 3, n3 - 3, n4 - 2);
        graphics2D.setColor(cyan_127);
        graphics2D.drawLine(n + 2, n4 - 1, n + 3, n4 - 1);
        graphics2D.drawLine(n + 1, n4, n + 2, n4);
        graphics2D.drawLine(n3 - 2, n4 - 1, n3 - 3, n4 - 1);
        graphics2D.drawLine(n3 - 1, n4, n3 - 2, n4);
        graphics2D.setPaint(new LinearGradientPaint(n + 3, n2 + 1, n3 - 3, n2 + 1, new float[]{0.0f, 1.0f}, new Color[]{cyan_127, cyan_0}));
        graphics2D.drawLine(n + 4, n2 + 1, n3 - 4, n2 + 1);
        graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n4, new float[]{0.0f, 0.5f}, new Color[]{black_0, balck_17}));
        graphics2D.drawLine(n + 1, n2, n + 1, n4 - 3);
        graphics2D.drawLine(n3 - 1, n2, n3 - 1, n4 - 3);
    }

    private void drawBorder(Graphics2D graphics2D, Color color, Color color2, int n, int n2, int n3, int n4) {
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{OfficeRibbonTaskToggleButtonUI.getAlpha(color, 0), color};
        graphics2D.setPaint(new LinearGradientPaint(n + 2, n2, n + 6, n2, fArray, colorArray));
        graphics2D.drawLine(n + 2, n2, n3 - 7, n2);
        graphics2D.setPaint(new LinearGradientPaint(n3 - 2, n2, n3 - 6, n2, fArray, colorArray));
        graphics2D.drawLine(n3 - 2, n2, n3 - 6, n2);
        graphics2D.setPaint(new LinearGradientPaint(n + 1, n2, n + 1, n2 + 4, fArray, colorArray));
        graphics2D.drawLine(n + 2, n2, n + 2, n4 - 1);
        graphics2D.drawLine(n3 - 2, n2, n3 - 2, n4 - 1);
        graphics2D.setColor(color2);
        graphics2D.drawLine(n + 3, n2 + 1, n + 3, n2 + 1);
        graphics2D.drawLine(n3 - 3, n2 + 1, n3 - 3, n2 + 1);
        graphics2D.setColor(OfficeRibbonTaskToggleButtonUI.getAlpha(color2, 127));
        graphics2D.drawLine(n + 3, n2 + 2, n + 3, n2 + 2);
        graphics2D.drawLine(n + 4, n2 + 1, n + 4, n2 + 1);
        graphics2D.drawLine(n3 - 3, n2 + 2, n3 - 3, n2 + 2);
        graphics2D.drawLine(n3 - 4, n2 + 1, n3 - 4, n2 + 1);
    }

    private static Color getAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }
}

