/*
 * Decompiled with CFR 0.152.
 */
package org.officelaf.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import org.officelaf.util.HighlightFactory;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;

public class CommandButtonPainter {
    public static final Color NORMAL_BORDER_COLOR = new Color(11911106);
    public static final Color TEXT_COLOR = new Color(0x464646);
    public static final Color DISABLED_TEXT_COLOR = Color.GRAY;
    private AbstractCommandButton commandButton;
    private boolean isRollover = false;
    private boolean isPressed = false;
    private boolean isSelected = false;
    private boolean isPopupRollover = false;
    private boolean isActionEnabled = false;
    private boolean isPopupEnabled = false;
    private boolean isPopupOnly = false;
    private boolean isInStrip = false;
    private boolean isFirstInStrip = false;
    private boolean isLastInStrip = false;
    private boolean isStripVertical = false;
    private boolean ignorePressed = false;
    private BufferedImage highlightImage;
    Object oldAa;
    Composite oldComposite;

    public CommandButtonPainter(AbstractCommandButton abstractCommandButton) {
        this(abstractCommandButton, false);
    }

    public CommandButtonPainter(AbstractCommandButton abstractCommandButton, boolean bl) {
        this.commandButton = abstractCommandButton;
        this.ignorePressed = bl;
    }

    protected void updateState() {
        JCommandButton jCommandButton;
        ActionButtonModel actionButtonModel = this.commandButton.getActionModel();
        PopupButtonModel popupButtonModel = null;
        if (this.commandButton instanceof JCommandButton) {
            jCommandButton = (JCommandButton)this.commandButton;
            popupButtonModel = jCommandButton.getPopupModel();
            this.isPopupOnly = jCommandButton.getCommandButtonKind() == JCommandButton.CommandButtonKind.POPUP_ONLY;
        }
        this.isActionEnabled = actionButtonModel != null && actionButtonModel.isEnabled();
        this.isPopupEnabled = popupButtonModel != null && popupButtonModel.isEnabled();
        this.isPressed = !this.ignorePressed && actionButtonModel != null && actionButtonModel.isPressed() || popupButtonModel != null && popupButtonModel.isPressed();
        this.isSelected = actionButtonModel != null && actionButtonModel.isSelected() || popupButtonModel != null && popupButtonModel.isSelected();
        this.isRollover = actionButtonModel != null && actionButtonModel.isRollover() || popupButtonModel != null && (popupButtonModel.isRollover() || popupButtonModel.isPopupShowing());
        boolean bl = this.isPopupRollover = popupButtonModel != null && popupButtonModel.isRollover();
        if (this.commandButton.getParent() instanceof JCommandButtonStrip) {
            jCommandButton = (JCommandButtonStrip)this.commandButton.getParent();
            this.isInStrip = true;
            this.isFirstInStrip = jCommandButton.isFirst(this.commandButton);
            this.isLastInStrip = jCommandButton.isLast(this.commandButton);
            this.isStripVertical = jCommandButton.getOrientation() == JCommandButtonStrip.StripOrientation.VERTICAL;
        }
    }

    public void paintBackground(Graphics graphics, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        this.updateState();
        if (this.isPressed) {
            this.paintPressedBackground(graphics2D, n, n2, n3, n4);
        } else if (this.isSelected) {
            this.paintSelectedBackground(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (this.isRollover) {
            this.paintRolloverBackground(graphics2D, n, n2, n3, n4);
        } else if (!this.commandButton.isFlat()) {
            this.paintNormalBackground(graphics2D, n, n2, n3, n4);
        }
        graphics2D.dispose();
    }

    protected void paintNormalBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        int n7 = this.isInStrip && !this.isStripVertical && !this.isFirstInStrip ? n : n + 1;
        int n8 = n2;
        int n9 = this.isInStrip && !this.isLastInStrip && !this.isStripVertical ? n5 : n5 - 1;
        int n10 = this.isInStrip && !this.isLastInStrip && this.isStripVertical ? n6 : n6 - 1;
        graphics2D.setPaint(new LinearGradientPaint(n7, n8, n7, n10, new float[]{0.0f, 0.4f, 0.41f, 1.0f}, new Color[]{new Color(14081759), new Color(14410468), new Color(13818331), new Color(14738919)}));
        graphics2D.fillRect(n7, n8, n9 - n7 + 1, n10 - n8 + 1);
        this.setAlpha(graphics2D, 0.3f);
        graphics2D.setColor(Color.WHITE);
        n7 = n + 1;
        n8 = this.isInStrip && this.isStripVertical && !this.isFirstInStrip ? n2 : n2 + 1;
        n9 = n5 - 1;
        n10 = n8;
        graphics2D.drawLine(n7, n8, n9, n10);
        if (!this.isInStrip || !this.isStripVertical || this.isLastInStrip && this.isStripVertical) {
            n7 = n + 1;
            n8 = n6 - 1;
            n9 = n5 - 1;
            n10 = n8;
            graphics2D.drawLine(n7, n8, n9, n10);
        }
        n7 = this.isInStrip && !this.isStripVertical && !this.isFirstInStrip ? n : n + 1;
        n8 = n2 + 1;
        n9 = n7;
        n10 = n6 - 1;
        graphics2D.drawLine(n7, n8, n9, n10);
        if (!this.isInStrip || this.isStripVertical || this.isLastInStrip && !this.isStripVertical) {
            n7 = n5 - 1;
            n8 = n2 + 1;
            n9 = n7;
            n10 = n6 - 1;
            graphics2D.drawLine(n7, n8, n9, n10);
        }
        this.resetAlpha(graphics2D);
        graphics2D.setColor(NORMAL_BORDER_COLOR);
        if (!this.isInStrip || !this.isStripVertical || this.isFirstInStrip && this.isStripVertical) {
            n7 = !this.isInStrip || this.isFirstInStrip ? n + 1 : n;
            n8 = n2;
            n9 = !this.isInStrip || this.isLastInStrip || this.isFirstInStrip && this.isStripVertical ? n5 - 1 : n5;
            n10 = n8;
            graphics2D.drawLine(n7, n8, n9, n10);
        }
        n7 = !this.isInStrip || this.isFirstInStrip ? n + 1 : n;
        n8 = n6;
        n9 = !this.isInStrip || this.isLastInStrip || this.isFirstInStrip && this.isStripVertical ? n5 - 1 : n5;
        n10 = n8;
        graphics2D.drawLine(n7, n8, n9, n10);
        if (!this.isInStrip || this.isStripVertical || this.isFirstInStrip && !this.isStripVertical) {
            n7 = n;
            n8 = !this.isInStrip || this.isFirstInStrip ? n2 + 1 : n2;
            n9 = n;
            n10 = !this.isInStrip || this.isFirstInStrip || this.isLastInStrip && this.isStripVertical ? n6 - 1 : n6;
            graphics2D.drawLine(n7, n8, n9, n10);
        }
        n7 = n5;
        n8 = !this.isInStrip || this.isLastInStrip && !this.isStripVertical || this.isFirstInStrip && this.isStripVertical ? n2 + 1 : n2;
        n9 = n5;
        int n11 = n10 = !this.isInStrip || this.isLastInStrip ? n6 - 1 : n6;
        if (!this.isLastInStrip && !this.isStripVertical) {
            this.setAlpha(graphics2D, 0.3f);
        }
        graphics2D.drawLine(n7, n8, n9, n10);
        if (!this.isLastInStrip && !this.isStripVertical) {
            this.resetAlpha(graphics2D);
        }
        this.setAlpha(graphics2D, 0.5f);
        if (!this.isInStrip || this.isFirstInStrip) {
            graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        }
        if (!this.isInStrip || this.isFirstInStrip && this.isStripVertical || this.isLastInStrip && !this.isStripVertical) {
            graphics2D.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
        }
        if (!this.isInStrip || this.isLastInStrip) {
            graphics2D.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
        }
        if (!this.isInStrip || this.isFirstInStrip && !this.isStripVertical || this.isLastInStrip && this.isStripVertical) {
            graphics2D.drawLine(n + 1, n6 - 1, n + 1, n6 - 1);
        }
        this.resetAlpha(graphics2D);
    }

    protected void paintSelectedBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        CommandButtonDisplayState commandButtonDisplayState = this.commandButton.getDisplayState();
        if (commandButtonDisplayState == CommandButtonDisplayState.BIG) {
            if (!this.isSplit()) {
                this.paintBigSelectedBackground(graphics2D, n, n2, n3, n4);
            } else {
                Rectangle rectangle = new Rectangle(this.commandButton.getUI().getLayoutInfo().actionClickArea);
                Rectangle rectangle2 = new Rectangle(this.commandButton.getUI().getLayoutInfo().popupClickArea);
                graphics2D.setClip(rectangle);
                this.paintBigSelectedBackground(graphics2D, n, n2, n3, n4);
                graphics2D.setClip(rectangle2);
                if (this.isRollover && !this.isPopupRollover) {
                    this.paintBigRolloverBackground(graphics2D, n, n2, n3, n4, true, this.isPopupEnabled);
                } else if (this.isPopupRollover) {
                    this.paintBigRolloverBackground(graphics2D, n, n2, n3, n4, false, this.isPopupEnabled);
                } else {
                    this.paintBigSelectedBackground(graphics2D, n, n2, n3, n4);
                }
            }
        } else {
            if (this.isInStrip) {
                this.paintNormalBackground(graphics2D, n, n2, n3, n4);
            }
            if (!this.isSplit()) {
                this.paintSmallSelectedBackground(graphics2D, n, n2, n3, n4);
            } else {
                Rectangle rectangle = new Rectangle(this.commandButton.getUI().getLayoutInfo().actionClickArea);
                Rectangle rectangle3 = new Rectangle(this.commandButton.getUI().getLayoutInfo().popupClickArea);
                graphics2D.setClip(rectangle);
                this.paintSmallSelectedBackground(graphics2D, n, n2, n3, n4);
                graphics2D.setClip(rectangle3);
                if (this.isRollover && !this.isPopupRollover) {
                    this.paintSmallRolloverBackground(graphics2D, n, n2, n3, n4, true, this.isPopupEnabled);
                } else if (this.isPopupRollover) {
                    this.paintSmallRolloverBackground(graphics2D, n, n2, n3, n4, false, this.isPopupEnabled);
                } else {
                    this.paintSmallSelectedBackground(graphics2D, n, n2, n3, n4);
                }
            }
        }
    }

    private void paintSmallSelectedBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        Color[] colorArray;
        Color[] colorArray2;
        Color[] colorArray3;
        float[] fArray;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n + n3 - 1;
        int n11 = n2 + n4 - 1;
        if (!this.isInStrip) {
            n9 = n + 2;
            n8 = n10 - 2;
            n7 = n2 + 4;
            n6 = n11 - 2;
            fArray = new float[]{0.0f, 0.499f, 0.5f, 1.0f};
        } else {
            float[] fArray2;
            n9 = this.isFirstInStrip ? n + 1 : n;
            n8 = n10 - 1;
            n7 = n2 + 1;
            n6 = n11 - 1;
            if (this.isRollover) {
                float[] fArray3 = new float[4];
                fArray3[0] = 0.0f;
                fArray3[1] = 0.35f;
                fArray3[2] = 0.351f;
                fArray2 = fArray3;
                fArray3[3] = 1.0f;
            } else {
                float[] fArray4 = new float[4];
                fArray4[0] = 0.0f;
                fArray4[1] = 0.3f;
                fArray4[2] = 0.31f;
                fArray2 = fArray4;
                fArray4[3] = 1.0f;
            }
            fArray = fArray2;
        }
        int n12 = n8 - n9 + 1;
        int n13 = n6 - n7 + 1;
        if (!this.isInStrip) {
            // empty if block
        }
        if (this.isRollover) {
            Color[] colorArray4 = new Color[4];
            colorArray4[0] = new Color(16165481);
            colorArray4[1] = new Color(15964500);
            colorArray4[2] = new Color(15761962);
            colorArray3 = colorArray4;
            colorArray4[3] = new Color(16029212);
        } else {
            Color[] colorArray5 = new Color[4];
            colorArray5[0] = new Color(16636593);
            colorArray5[1] = new Color(16499584);
            colorArray5[2] = new Color(16362312);
            colorArray3 = colorArray5;
            colorArray5[3] = new Color(16638612);
        }
        Color[] colorArray6 = colorArray3;
        graphics2D.setPaint(new LinearGradientPaint(n9, n7, n9, n6, fArray, colorArray6));
        graphics2D.fillRect(n9, n7, n12, n13);
        if (!this.isInStrip) {
            graphics2D.drawImage((Image)this.getHighlightImage(), n, n2 + 2, null);
        }
        if (!this.isInStrip) {
            graphics2D.setColor(new Color(10388053));
            graphics2D.drawLine(n, n2 + 1, n, n11 - 1);
            if (!this.isRollover) {
                graphics2D.setColor(new Color(10980966));
            }
            graphics2D.drawLine(n + 1, n2, n10 - 1, n2);
            graphics2D.drawLine(n10, n2 + 1, n10, n11 - 1);
        }
        if (!this.isInStrip) {
            if (!this.isRollover) {
                graphics2D.setPaint(new LinearGradientPaint(n + 1, n11, n10 - 1, n11, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(158, 130, 85, 127), new Color(197, 137, 37, 94), new Color(158, 130, 85, 127)}));
            } else {
                graphics2D.setColor(new Color(13944237));
            }
            graphics2D.drawLine(n + 1, n11, n10 - 1, n11);
        }
        if (this.isRollover) {
            Color[] colorArray7 = new Color[3];
            colorArray7[0] = new Color(12422214);
            colorArray7[1] = new Color(14591063);
            colorArray2 = colorArray7;
            colorArray7[2] = new Color(15837797);
        } else {
            Color[] colorArray8 = new Color[3];
            colorArray8[0] = new Color(13350041);
            colorArray8[1] = new Color(15389106);
            colorArray2 = colorArray8;
            colorArray8[2] = new Color(16309175);
        }
        Color[] colorArray9 = colorArray2;
        if (this.isRollover) {
            Color[] colorArray10 = new Color[3];
            colorArray10[0] = new Color(10388053);
            colorArray10[1] = new Color(13671509);
            colorArray = colorArray10;
            colorArray10[2] = new Color(15183455);
        } else {
            Color[] colorArray11 = new Color[3];
            colorArray11[0] = new Color(11704952);
            colorArray11[1] = new Color(14863538);
            colorArray = colorArray11;
            colorArray11[2] = new Color(15717296);
        }
        Color[] colorArray12 = colorArray;
        for (n5 = 0; n5 < colorArray9.length; ++n5) {
            int n14;
            if (!this.isInStrip) {
                n14 = n2 + 1 + n5;
                graphics2D.setColor(colorArray12[n5]);
                graphics2D.drawLine(n + 1, n14, n10 - 1, n14);
                graphics2D.setColor(colorArray9[n5]);
                graphics2D.drawLine(n + 2, n14, n10 - 2, n14);
                continue;
            }
            if (n5 == 2) break;
            n14 = n2 + n5;
            int n15 = this.isFirstInStrip ? n + 1 : n;
            graphics2D.setColor(colorArray9[n5]);
            graphics2D.drawLine(n15, n14, n10 - 1, n14);
        }
        if (!this.isInStrip) {
            Color[] colorArray13;
            if (this.isRollover) {
                Color[] colorArray14 = new Color[3];
                colorArray14[0] = new Color(16756026);
                colorArray14[1] = new Color(16762228);
                colorArray13 = colorArray14;
                colorArray14[2] = new Color(16757576);
            } else {
                Color[] colorArray15 = new Color[3];
                colorArray15[0] = new Color(16498499);
                colorArray15[1] = new Color(16573100);
                colorArray13 = colorArray15;
                colorArray15[2] = new Color(16500057);
            }
            Color[] colorArray16 = colorArray13;
            graphics2D.setPaint(new LinearGradientPaint(n + 1, n11 - 1, n10 - 1, n11 - 1, new float[]{0.0f, 0.5f, 1.0f}, colorArray16));
            graphics2D.drawLine(n + 1, n11 - 1, n10 - 1, n11 - 1);
        }
        if (!this.isInStrip) {
            if (!this.isRollover) {
                graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 4, n + 1, n11 - 1, new float[]{0.0f, 0.499f, 0.5f, 0.75f, 1.0f}, new Color[]{new Color(16044198), new Color(15839834), new Color(15839834), new Color(16170335), new Color(16564292)}));
            } else {
                graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 4, n + 1, n11 - 1, new float[]{0.0f, 0.499f, 0.5f, 1.0f}, new Color[]{new Color(15972710), new Color(16437639), new Color(16436091), new Color(16690744)}));
            }
            graphics2D.drawLine(n + 1, n2 + 4, n + 1, n11 - 1);
            graphics2D.drawLine(n10 - 1, n2 + 4, n10 - 1, n11 - 1);
        }
        if (!this.isInStrip) {
            if (!this.isRollover) {
                graphics2D.setColor(new Color(15118674));
                graphics2D.drawLine(n + 1, n11 - 2, n + 1, n11 - 2);
                graphics2D.drawLine(n10 - 1, n11 - 2, n10 - 1, n11 - 2);
            }
            graphics2D.setColor(new Color(13149032));
            graphics2D.drawLine(n + 1, n11 - 1, n + 1, n11 - 1);
            graphics2D.drawLine(n10 - 1, n11 - 1, n10 - 1, n11 - 1);
        }
        if (!this.isRollover && !this.isInStrip) {
            n5 = (int)((double)n3 * 0.08) - 2;
            graphics2D.setColor(new Color(251, 197, 89, 153));
            graphics2D.drawLine(n + 2, n11 - 2, n + 2 + n5, n11 - 2);
            graphics2D.drawLine(n10 - 2, n11 - 2, n10 - 2 - n5, n11 - 2);
        }
    }

    private void paintBigSelectedBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Color[] colorArray;
        float[] fArray;
        Color[] colorArray2;
        Color[] colorArray3;
        Color[] colorArray4;
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        if (this.isRollover) {
            Color[] colorArray5 = new Color[4];
            colorArray5[0] = new Color(16366209);
            colorArray5[1] = new Color(14912334);
            colorArray5[2] = new Color(14578988);
            colorArray4 = colorArray5;
            colorArray5[3] = new Color(16039003);
        } else {
            Color[] colorArray6 = new Color[4];
            colorArray6[0] = new Color(16768441);
            colorArray6[1] = new Color(16427099);
            colorArray6[2] = new Color(16289065);
            colorArray4 = colorArray6;
            colorArray6[3] = new Color(16639129);
        }
        Color[] colorArray7 = colorArray4;
        graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, new float[]{0.0f, 0.39f, 0.391f, 1.0f}, colorArray7));
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics2D.drawImage((Image)this.getHighlightImage(), n, n2 + 2, null);
        if (this.isRollover) {
            Color[] colorArray8 = new Color[2];
            colorArray8[0] = new Color(9339237);
            colorArray3 = colorArray8;
            colorArray8[1] = new Color(11641737);
        } else {
            Color[] colorArray9 = new Color[2];
            colorArray9[0] = new Color(9339237);
            colorArray3 = colorArray9;
            colorArray9[1] = new Color(13025458);
        }
        Color[] colorArray10 = colorArray3;
        graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n6 - 2, new float[]{0.67f, 1.0f}, colorArray10));
        graphics2D.drawLine(n, n2 + 1, n, n6 - 2);
        graphics2D.drawLine(n5, n2 + 1, n5, n6 - 2);
        graphics2D.drawLine(n + 1, n2, n5 - 1, n2);
        if (this.isRollover) {
            graphics2D.setColor(new Color(13944237));
            graphics2D.drawLine(n + 1, n6, n5 - 1, n6);
        }
        if (this.isRollover) {
            Color[] colorArray11 = new Color[3];
            colorArray11[0] = new Color(11044958);
            colorArray11[1] = new Color(13736805);
            colorArray2 = colorArray11;
            colorArray11[2] = new Color(15313515);
        } else {
            Color[] colorArray12 = new Color[3];
            colorArray12[0] = new Color(11967096);
            colorArray12[1] = new Color(14530697);
            colorArray2 = colorArray12;
            colorArray12[2] = new Color(16107930);
        }
        Color[] colorArray13 = colorArray2;
        for (int i = 0; i < colorArray13.length; ++i) {
            int n7 = n2 + 1 + i;
            graphics2D.setColor(colorArray13[i]);
            graphics2D.drawLine(n + 1, n7, n5 - 1, n7);
        }
        if (this.isRollover) {
            float[] fArray2 = new float[3];
            fArray2[0] = 0.0f;
            fArray2[1] = 0.5f;
            fArray = fArray2;
            fArray2[2] = 1.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = 0.0f;
            fArray = fArray3;
            fArray3[1] = 1.0f;
        }
        float[] fArray4 = fArray;
        if (this.isRollover) {
            Color[] colorArray14 = new Color[3];
            colorArray14[0] = new Color(239, 161, 49, 204);
            colorArray14[1] = new Color(16707795);
            colorArray = colorArray14;
            colorArray14[2] = new Color(16768881);
        } else {
            Color[] colorArray15 = new Color[2];
            colorArray15[0] = new Color(242, 173, 65, 204);
            colorArray = colorArray15;
            colorArray15[1] = new Color(16764717);
        }
        Color[] colorArray16 = colorArray;
        graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, fArray4, colorArray16));
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n6 - 1);
        graphics2D.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 1);
        int n8 = this.isRollover ? n6 - 1 : n6;
        graphics2D.setPaint(new LinearGradientPaint(n + 1, n6, n5 - 1, n6, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(0xFFCF2C), new Color(16771488), new Color(16764717)}));
        graphics2D.drawLine(n + 1, n8, n5 - 1, n8);
        graphics2D.setColor(this.isRollover ? new Color(9931117) : new Color(11904913));
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics2D.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
        graphics2D.setColor(this.isRollover ? new Color(13418149) : new Color(255, 220, 101, 92));
        graphics2D.drawLine(n, n6 - 1, n, n6 - 1);
        graphics2D.drawLine(n5, n6 - 1, n5, n6 - 1);
        if (this.isRollover) {
            graphics2D.setColor(new Color(14795377));
            graphics2D.drawLine(n + 1, n6 - 1, n + 1, n6 - 1);
            graphics2D.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
        } else {
            graphics2D.setColor(new Color(16635741));
            graphics2D.drawLine(n + 2, n6 - 1, n + 2, n6 - 1);
            graphics2D.drawLine(n5 - 2, n6 - 1, n5 - 2, n6 - 1);
        }
    }

    protected void paintPressedBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(this.commandButton.getUI().getLayoutInfo().actionClickArea);
        Rectangle rectangle2 = new Rectangle(this.commandButton.getUI().getLayoutInfo().popupClickArea);
        if (this.commandButton.getDisplayState() == CommandButtonDisplayState.BIG) {
            if (!this.isSplit()) {
                this.paintBigPressedBackground(graphics2D, n, n2, n3, n4);
            } else {
                rectangle.height += 2;
                rectangle2.y += 2;
                rectangle2.height -= 2;
                graphics2D.setClip(rectangle);
                if (this.isPopupRollover) {
                    this.paintBigRolloverBackground(graphics2D, n, n2, n3, n4, true, this.isActionEnabled);
                } else {
                    this.paintBigPressedBackground(graphics2D, n, n2, n3, n4);
                    graphics2D.setColor(new Color(-1711276033, true));
                    graphics2D.drawLine(n + 1, rectangle.height - 1, n + n3 - 2, rectangle.height - 1);
                }
                graphics2D.setClip(rectangle2);
                if (this.isPopupRollover) {
                    this.paintBigPressedBackground(graphics2D, n, n2, n3, n4);
                } else {
                    this.paintBigRolloverBackground(graphics2D, n, n2, n3, n4, true, this.isPopupEnabled);
                }
            }
        } else {
            if (this.isInStrip) {
                this.paintNormalBackground(graphics2D, n, n2, n3, n4);
            }
            if (!this.isSplit()) {
                this.paintSmallPressedBackground(graphics2D, n, n2, n3, n4);
            } else {
                graphics2D.setClip(rectangle);
                if (this.isPopupRollover) {
                    this.paintSmallRolloverBackground(graphics2D, n, n2, n3, n4, true, this.isActionEnabled);
                } else {
                    this.paintSmallPressedBackground(graphics2D, n, n2, n3, n4);
                }
                graphics2D.setClip(rectangle2);
                if (this.isPopupRollover) {
                    this.paintSmallPressedBackground(graphics2D, n, n2, n3, n4);
                } else {
                    this.paintSmallRolloverBackground(graphics2D, n, n2, n3, n4, true, this.isPopupEnabled);
                }
            }
        }
    }

    private void paintSmallPressedBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n + n3 - 1;
        int n7 = n2 + n4 - 1;
        int n8 = this.isInStrip && !this.isFirstInStrip ? n : n + 1;
        int n9 = n6 - 1;
        int n10 = n9 - n8 + 1;
        if (!this.isInStrip) {
            graphics2D.setPaint(new LinearGradientPaint(n8, n2 + 1, n8, n7 - 1, new float[]{0.0f, 0.6f, 0.61f, 1.0f}, new Color[]{new Color(16033648), new Color(15236672), new Color(14570762), new Color(16092479)}));
        } else {
            graphics2D.setPaint(new LinearGradientPaint(n8, n2 + 1, n8, n7 - 1, new float[]{0.2f, 0.4f, 0.41f, 1.0f}, new Color[]{new Color(16560493), new Color(16751139), new Color(16747781), new Color(16761936)}));
        }
        graphics2D.fillRect(n8, n2 + 1, n10, n4 - 2);
        if (!this.isInStrip) {
            graphics2D.drawImage((Image)this.getHighlightImage(), n, n2 + 2, null);
        }
        graphics2D.setPaint(new Color(8087109));
        if (!this.isInStrip) {
            graphics2D.drawLine(n + 1, n2, n6 - 1, n2);
            graphics2D.drawLine(n, n2 + 1, n, n7 - 1);
            graphics2D.drawLine(n6, n2 + 1, n6, n7 - 1);
        } else {
            int n11 = this.isFirstInStrip ? n + 2 : n;
            n5 = this.isLastInStrip ? n6 - 2 : n6 - 1;
            graphics2D.drawLine(n11, n2, n5, n2);
            graphics2D.drawLine(n11, n7, n5, n7);
        }
        int[] nArray = new int[]{153, 84, 22, 13};
        for (n5 = 0; n5 < nArray.length; ++n5) {
            int n12 = n2 + 1 + n5;
            int n13 = this.isFirstInStrip ? n + 1 : n;
            graphics2D.setColor(new Color(139, 118, 84, nArray[n5]));
            graphics2D.drawLine(n13, n12, n6 - 1, n12);
        }
        if (!this.isInStrip) {
            n5 = (int)((double)n3 * 0.08);
            graphics2D.setColor(new Color(253, 173, 3, 92));
            graphics2D.drawLine(n, n7 - 1, n + n5, n7 - 1);
            graphics2D.drawLine(n6, n7 - 1, n6 - n5, n7 - 1);
            graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n7, new float[]{0.0f, 1.0f}, new Color[]{new Color(253, 173, 3, 25), new Color(253, 173, 3)}));
            graphics2D.drawLine(n + 1, n2 + 1, n + 1, n7);
            graphics2D.drawLine(n6 - 1, n2 + 1, n6 - 1, n7);
            graphics2D.drawLine(n + 1, n7, n6 - 1, n7);
        } else {
            graphics2D.setColor(new Color(253, 173, 3));
            n5 = this.isFirstInStrip ? n + 1 : n;
            graphics2D.drawLine(n5, n7 - 1, n6 - 1, n7 - 1);
        }
        if (!this.isInStrip) {
            graphics2D.setColor(new Color(9137997));
            graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            graphics2D.drawLine(n6 - 1, n2 + 1, n6 - 1, n2 + 1);
        }
    }

    private void paintBigPressedBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, new float[]{0.0f, 0.409f, 0.41f, 1.0f}, new Color[]{new Color(16693100), new Color(16556128), new Color(16484924), new Color(16694112)}));
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics2D.drawImage((Image)this.getHighlightImage(), n, n2 + 2, null);
        graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n6 - 2, new float[]{0.5f, 1.0f}, new Color[]{new Color(9139796), new Color(12892584)}));
        graphics2D.drawLine(n + 1, n2, n5 - 1, n2);
        graphics2D.drawLine(n, n2 + 1, n, n6 - 2);
        graphics2D.drawLine(n5, n2 + 1, n5, n6 - 2);
        int[] nArray = new int[]{153, 84, 43, 22, 13};
        for (int i = 0; i < nArray.length; ++i) {
            int n7 = n2 + 1 + i;
            graphics2D.setColor(new Color(139, 118, 84, nArray[i]));
            graphics2D.drawLine(n + 1, n7, n5 - 1, n7);
        }
        graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n6 - 2, new float[]{0.5f, 1.0f}, new Color[]{new Color(139, 118, 84, 20), new Color(196, 185, 168, 20)}));
        graphics2D.drawLine(n + 2, n2 + 1, n + 2, n6 - 1);
        graphics2D.drawLine(n5 - 2, n2 + 1, n5 - 2, n6 - 1);
        graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6, new float[]{0.0f, 1.0f}, new Color[]{new Color(253, 173, 17, 25), new Color(253, 173, 17)}));
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n6);
        graphics2D.drawLine(n5 - 1, n2 + 1, n5 - 1, n6);
        graphics2D.drawLine(n + 1, n6, n5 - 1, n6);
        graphics2D.drawLine(n + 2, n6 - 1, n + 2, n6 - 1);
        graphics2D.drawLine(n5 - 2, n6 - 1, n5 - 2, n6 - 1);
        graphics2D.setColor(new Color(253, 173, 17, 127));
        graphics2D.drawLine(n, n6 - 1, n, n6 - 1);
        graphics2D.drawLine(n5, n6 - 1, n5, n6 - 1);
        graphics2D.setColor(new Color(11310708));
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics2D.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
    }

    protected void paintRolloverBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(this.commandButton.getUI().getLayoutInfo().actionClickArea);
        Rectangle rectangle2 = new Rectangle(this.commandButton.getUI().getLayoutInfo().popupClickArea);
        if (CommandButtonDisplayState.BIG == this.commandButton.getDisplayState()) {
            if (!this.isSplit()) {
                this.paintBigRolloverBackground(graphics2D, n, n2, n3, n4, false, this.isActionEnabled || this.isPopupOnly && this.isPopupEnabled);
            } else {
                if (this.isPopupRollover) {
                    rectangle.height += 2;
                    rectangle2.y += 2;
                    rectangle2.height -= 2;
                }
                graphics2D.setClip(rectangle);
                this.paintBigRolloverBackground(graphics2D, n, n2, n3, n4, this.isPopupRollover, this.isActionEnabled);
                graphics2D.setClip(rectangle2);
                this.paintBigRolloverBackground(graphics2D, n, n2, n3, n4, !this.isPopupRollover, this.isPopupEnabled);
            }
        } else {
            if (this.isInStrip) {
                this.paintNormalBackground(graphics2D, n, n2, n3, n4);
            }
            if (!this.isSplit()) {
                this.paintSmallRolloverBackground(graphics2D, n, n2, n3, n4, false, this.isActionEnabled || this.isPopupOnly && this.isPopupEnabled);
            } else {
                graphics2D.setClip(rectangle);
                this.paintSmallRolloverBackground(graphics2D, n, n2, n3, n4, this.isPopupRollover, this.isActionEnabled);
                graphics2D.setClip(rectangle2);
                this.paintSmallRolloverBackground(graphics2D, n, n2, n3, n4, !this.isPopupRollover, this.isPopupEnabled);
            }
        }
    }

    protected void paintBigRolloverBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Graphics2D graphics2D2 = graphics2D;
        BufferedImage bufferedImage = null;
        if (!bl2) {
            bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(n3, n4, 3);
            graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.setClip(graphics2D.getClip());
        }
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        graphics2D2.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, RolloverColors.BG_FRACTIONS_BIG, RolloverColors.BG));
        graphics2D2.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics2D2.drawImage((Image)this.getHighlightImage(), n, n2 + 2, null);
        if (bl && bl2) {
            graphics2D2.setPaint(new Color(-1711276033, true));
            graphics2D2.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        }
        graphics2D2.setPaint(new LinearGradientPaint(n, n2, n, n6, RolloverColors.BORDER_FRACTIONS, RolloverColors.BORDER_BIG));
        graphics2D2.drawLine(n + 1, n2, n5 - 1, n2);
        graphics2D2.drawLine(n5, n2 + 1, n5, n6 - 1);
        graphics2D2.drawLine(n + 1, n6, n5 - 1, n6);
        graphics2D2.drawLine(n, n2 + 1, n, n6 - 1);
        graphics2D2.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, RolloverColors.HIGHLIGHT1_FRACTIONS, RolloverColors.HIGHLIGHT1));
        graphics2D2.drawLine(n + 2, n2 + 1, n5 - 2, n2 + 1);
        graphics2D2.drawLine(n + 1, n2 + 2, n + 1, n6 - 2);
        graphics2D2.drawLine(n5 - 1, n2 + 2, n5 - 1, n6 - 2);
        graphics2D2.setPaint(new LinearGradientPaint(n + 2, n6 - 1, n5 - 2, n6 - 1, RolloverColors.HIGHLIGHT2_FRACTIONS, RolloverColors.HIGHLIGHT2));
        graphics2D2.drawLine(n + 2, n6 - 1, n5 - 2, n6 - 1);
        graphics2D2.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, RolloverColors.HIGHLIGHT3_FRACTIONS, RolloverColors.HIGHLIGHT3));
        graphics2D2.drawLine(n + 1, n2 + 1, n + 1, n6 - 1);
        graphics2D2.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 1);
        graphics2D2.setPaint(new LinearGradientPaint(n + 1, n6 - 1, n5 - 1, n6 - 1, RolloverColors.HIGHLIGHT4_FRACTIONS, RolloverColors.HIGHLIGHT4));
        graphics2D2.drawLine(n + 1, n6 - 1, n5 - 1, n6 - 1);
        graphics2D2.setColor(RolloverColors.CORNER1);
        graphics2D2.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
        graphics2D2.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
        graphics2D2.setColor(RolloverColors.CORNER2);
        graphics2D2.drawLine(n + 1, n6 - 1, n + 1, n6 - 1);
        graphics2D2.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
        if (!bl2) {
            graphics2D2.dispose();
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
            graphics2D.drawImage(bufferedImage, colorConvertOp, n, n2);
        }
    }

    protected void paintSmallRolloverBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Graphics2D graphics2D2 = graphics2D;
        BufferedImage bufferedImage = null;
        if (!bl2) {
            bufferedImage = graphics2D.getDeviceConfiguration().createCompatibleImage(n3, n4, 3);
            graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.setClip(graphics2D.getClip());
        }
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        int n7 = this.isInStrip && !this.isFirstInStrip ? n : n + 1;
        int n8 = n5 - 1;
        int n9 = n2 + 1;
        int n10 = n6 - 1;
        int n11 = n8 - n7 + 1;
        int n12 = n10 - n9 + 1;
        graphics2D2.setPaint(new LinearGradientPaint(n7, n9, n7, n10, RolloverColors.BG_FRACTIONS_SMALL, RolloverColors.BG));
        graphics2D2.fillRect(n7, n9, n11, n12);
        Shape shape = graphics2D2.getClip();
        graphics2D2.setClip(n7, n9, n11, n12);
        graphics2D2.drawImage((Image)this.getHighlightImage(), n, n2 + 2, null);
        graphics2D2.setClip(shape);
        if (bl && bl2) {
            graphics2D2.setPaint(new Color(-1711276033, true));
            graphics2D2.fillRect(n7, n9, n11, n12);
        }
        if (!this.isInStrip) {
            graphics2D2.setPaint(new LinearGradientPaint(n, n2, n, n6, RolloverColors.BORDER_FRACTIONS, RolloverColors.BORDER_SMALL));
            graphics2D2.drawLine(n + 1, n2, n5 - 1, n2);
            graphics2D2.drawLine(n5, n2 + 1, n5, n6 - 1);
            graphics2D2.drawLine(n + 1, n6, n5 - 1, n6);
            graphics2D2.drawLine(n, n2 + 1, n, n6 - 1);
        }
        graphics2D2.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, RolloverColors.HIGHLIGHT1_FRACTIONS, RolloverColors.HIGHLIGHT1));
        graphics2D2.drawLine(n7, n9, n8, n9);
        graphics2D2.drawLine(n7, n9 + 1, n7, n10 - 1);
        graphics2D2.drawLine(n8, n9 + 1, n8, n10 - 1);
        graphics2D2.setPaint(new LinearGradientPaint(n + 2, n6 - 1, n5 - 2, n6 - 1, RolloverColors.HIGHLIGHT2_FRACTIONS, RolloverColors.HIGHLIGHT2));
        graphics2D2.drawLine(n7, n10, n8, n10);
        if (this.isInStrip) {
            this.setAlpha(graphics2D2, 0.5f);
            graphics2D2.setColor(NORMAL_BORDER_COLOR);
            if (this.isFirstInStrip) {
                graphics2D2.drawLine(n7, n9, n7, n9);
                graphics2D2.drawLine(n7, n10, n7, n10);
            }
            if (this.isLastInStrip) {
                graphics2D2.drawLine(n8, n9, n8, n9);
                graphics2D2.drawLine(n8, n10, n8, n10);
            }
            this.resetAlpha(graphics2D2);
        } else {
            graphics2D2.setColor(RolloverColors.CORNER1);
            graphics2D2.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            graphics2D2.drawLine(n5 - 1, n2 + 1, n5 - 1, n2 + 1);
            graphics2D2.setColor(RolloverColors.CORNER2);
            graphics2D2.drawLine(n + 1, n6 - 1, n + 1, n6 - 1);
            graphics2D2.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 - 1);
        }
        if (!bl2) {
            graphics2D2.dispose();
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
            graphics2D.drawImage(bufferedImage, colorConvertOp, n, n2);
        }
    }

    protected boolean isSplit() {
        JCommandButton.CommandButtonKind commandButtonKind = this.commandButton instanceof JCommandButton ? ((JCommandButton)this.commandButton).getCommandButtonKind() : JCommandButton.CommandButtonKind.ACTION_ONLY;
        return commandButtonKind.hasAction() && commandButtonKind.hasPopup();
    }

    protected BufferedImage getHighlightImage() {
        if (this.highlightImage == null || this.highlightImage.getWidth() != this.commandButton.getWidth()) {
            this.highlightImage = HighlightFactory.createHighlight(this.commandButton.getWidth(), (int)((double)this.commandButton.getHeight() * 1.5));
        }
        return this.highlightImage;
    }

    public void paintCollapsedBandButtonBackground(Graphics graphics, Rectangle rectangle) {
        this.updateState();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isPressed) {
            this.paintPressedCollapsedBandButtonBackground(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.paintNormalCollapsedBandButtonBackground(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected void paintPressedCollapsedBandButtonBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        Color[] colorArray = new Color[]{new Color(0xF3F3F3), new Color(13159892), new Color(12173513), new Color(0xECECEC)};
        graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, new float[]{0.0f, 0.17f, 0.171f, 1.0f}, colorArray));
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
        graphics2D.setColor(new Color(0xAAAAAA));
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics2D.setComposite(composite);
        graphics2D.setColor(CollapsedBandColors.border1_pressed_140);
        graphics2D.drawLine(n + 1, n2 + 1, n5 - 1, n2 + 1);
        graphics2D.setColor(CollapsedBandColors.border1_pressed_90);
        graphics2D.drawLine(n + 1, n2 + 1, n + 1, n6 - 1);
        graphics2D.drawLine(n + 1, n2 + 2, n5 - 1, n2 + 2);
        graphics2D.setColor(CollapsedBandColors.border1_pressed_45);
        graphics2D.drawLine(n + 2, n2 + 1, n + 2, n6 - 1);
        graphics2D.drawLine(n + 1, n2 + 3, n5 - 1, n2 + 3);
        graphics2D.setColor(CollapsedBandColors.highlight1_pressed);
        graphics2D.drawLine(n5 - 1, n2 + 1, n5 - 1, n6 - 1);
        graphics2D.drawLine(n + 1, n6 - 1, n5 - 1, n6 - 1);
        graphics2D.setColor(CollapsedBandColors.highlight2_pressed);
        graphics2D.drawLine(n5 - 2, n2 + 1, n5 - 2, n6 - 1);
        graphics2D.drawLine(n + 1, n6 - 2, n5 - 1, n6 - 2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n6, new float[]{0.0f, 0.95f, 1.0f}, new Color[]{CollapsedBandColors.border1_pressed, CollapsedBandColors.border2_pressed, CollapsedBandColors.border3_pressed}));
        this.drawRoundedRect(graphics2D, n, n2, n5, n6);
        graphics2D.setPaint(paint);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void paintNormalCollapsedBandButtonBackground(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        Color[] colorArray;
        Color color;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        Color color2 = this.isRollover ? CollapsedBandColors.border1_over : CollapsedBandColors.border1;
        Color color3 = color = this.isRollover ? CollapsedBandColors.border1_over : CollapsedBandColors.border1;
        if (this.isRollover) {
            Color[] colorArray2 = new Color[4];
            colorArray2[0] = new Color(0xFFFFFF);
            colorArray2[1] = new Color(13685977);
            colorArray2[2] = new Color(12634063);
            colorArray = colorArray2;
            colorArray2[3] = new Color(0xF0F0F0);
        } else {
            Color[] colorArray3 = new Color[4];
            colorArray3[0] = new Color(0xF3F3F3);
            colorArray3[1] = new Color(13159892);
            colorArray3[2] = new Color(12173513);
            colorArray = colorArray3;
            colorArray3[3] = new Color(0xECECEC);
        }
        Color[] colorArray4 = colorArray;
        graphics2D.setPaint(new LinearGradientPaint(n + 1, n2 + 1, n + 1, n6 - 1, new float[]{0.0f, 0.16f, 0.161f, 1.0f}, colorArray4));
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n6, new float[]{0.0f, 1.0f}, new Color[]{color2, color}));
        this.drawRoundedRect(graphics2D, n, n2, n5, n6);
        graphics2D.setPaint(paint);
        graphics2D.setColor(CollapsedBandColors.highlight1);
        graphics2D.drawLine(n + 2, n2 + 1, n5 - 2, n2 + 1);
        graphics2D.drawLine(n + 1, n2 + 2, n + 1, n6 - 2);
        if (!this.isRollover) {
            graphics2D.setColor(CollapsedBandColors.highlight2);
        }
        graphics2D.drawLine(n5 - 1, n2 + 2, n5 - 1, n6 - 2);
        graphics2D.drawLine(n + 2, n6 - 1, n5 - 2, n6 - 1);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void drawRoundedRect(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.drawLine(n + 2, n2, n3 - 2, n2);
        graphics2D.drawLine(n, n2 + 2, n, n4 - 2);
        graphics2D.drawLine(n + 2, n4, n3 - 2, n4);
        graphics2D.drawLine(n3, n2 + 2, n3, n4 - 2);
        graphics2D.drawLine(n, n2 + 2, n + 2, n2);
        graphics2D.drawLine(n3 - 2, n2, n3, n2 + 2);
        graphics2D.drawLine(n3, n4 - 2, n3 - 2, n4);
        graphics2D.drawLine(n, n4 - 2, n + 2, n4);
    }

    protected void enableAA(Graphics2D graphics2D) {
        this.oldAa = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void resetAA(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.oldAa);
    }

    protected void setAlpha(Graphics2D graphics2D, float f) {
        this.oldComposite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
    }

    protected void resetAlpha(Graphics2D graphics2D) {
        graphics2D.setComposite(this.oldComposite);
    }

    static class CollapsedBandColors {
        protected static final Color border1 = new Color(0xB6B7B7);
        protected static final Color border2 = new Color(0x707070);
        protected static final Color border1_over = new Color(12370390);
        protected static final Color border2_over = new Color(7638459);
        protected static final Color border1_pressed = new Color(0x7C7D7D);
        protected static final Color border2_pressed = new Color(0x949494);
        protected static final Color border3_pressed = new Color(0xBABABA);
        protected static final Color border1_pressed_140 = new Color(border1_pressed.getRed(), border1_pressed.getGreen(), border1_pressed.getBlue(), 140);
        protected static final Color border1_pressed_90 = new Color(border1_pressed.getRed(), border1_pressed.getGreen(), border1_pressed.getBlue(), 90);
        protected static final Color border1_pressed_45 = new Color(border1_pressed.getRed(), border1_pressed.getGreen(), border1_pressed.getBlue(), 45);
        protected static final Color highlight1 = new Color(255, 255, 255, 127);
        protected static final Color highlight2 = new Color(220, 220, 220, 127);
        protected static final Color highlight1_pressed = new Color(255, 255, 255, 50);
        protected static final Color highlight2_pressed = new Color(255, 255, 255, 30);
        protected static final Color background = new Color(207, 215, 229, 60);
        protected static final Color background_pressed = new Color(125, 125, 125, 30);

        CollapsedBandColors() {
        }
    }

    static class RolloverColors {
        protected static final Color[] BG = new Color[]{new Color(16776409), new Color(16770959), new Color(16766794), new Color(16770964)};
        protected static final Color[] BORDER_BIG = new Color[]{new Color(14536603), new Color(12625782), new Color(14603963)};
        protected static final Color[] BORDER_SMALL = new Color[]{new Color(14405273), new Color(12033651), new Color(12628374)};
        protected static final Color[] HIGHLIGHT1 = new Color[]{new Color(255, 255, 255, 222), new Color(254, 247, 201, 222)};
        protected static final Color[] HIGHLIGHT2 = new Color[]{new Color(0xFFFACF), Color.WHITE, new Color(0xFFFACF)};
        protected static final Color[] HIGHLIGHT3 = new Color[]{new Color(16773981, true), new Color(16773981)};
        protected static final Color[] HIGHLIGHT4 = new Color[]{new Color(16775058), new Color(16775058, true), new Color(16775058, true), new Color(16775058)};
        protected static final Color CORNER1 = new Color(15393448);
        protected static final Color CORNER2 = new Color(15786940);
        protected static final float[] BG_FRACTIONS_BIG = new float[]{0.0f, 0.375f, 0.376f, 1.0f};
        protected static final float[] BG_FRACTIONS_SMALL = new float[]{0.0f, 0.49f, 0.5f, 1.0f};
        protected static final float[] BORDER_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
        protected static final float[] HIGHLIGHT1_FRACTIONS = new float[]{0.0f, 1.0f};
        protected static final float[] HIGHLIGHT2_FRACTIONS = new float[]{0.0f, 0.5f, 1.0f};
        protected static final float[] HIGHLIGHT3_FRACTIONS = new float[]{0.5f, 1.0f};
        protected static final float[] HIGHLIGHT4_FRACTIONS = new float[]{0.0f, 0.45f, 0.55f, 1.0f};

        RolloverColors() {
        }
    }
}

