/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class SyncSelectionAction
extends SystemAction
implements PropertyChangeListener {
    private GraphEditorRegistry _editors;
    private TopComponent.Registry _topComponents;

    public SyncSelectionAction() {
        this(GraphEditorRegistry.getDefault(), TopComponent.getRegistry());
    }

    public SyncSelectionAction(GraphEditorRegistry graphEditorRegistry, TopComponent.Registry registry) {
        this._editors = graphEditorRegistry;
        this._topComponents = registry;
        this._editors.addPropertyChangeListener((PropertyChangeListener)this);
        this._topComponents.addPropertyChangeListener((PropertyChangeListener)this);
        this.checkEnabled(this._editors.getTopmost(), this._topComponents.getActivated());
    }

    protected void checkEnabled(TopComponent topComponent, TopComponent topComponent2) {
        ExplorerManager explorerManager = SyncSelectionAction.find(topComponent2);
        ExplorerManager explorerManager2 = null;
        if (explorerManager != null) {
            explorerManager2 = SyncSelectionAction.find(topComponent);
        }
        this.setEnabled(explorerManager2 != null && explorerManager != null && explorerManager2 != explorerManager);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("topmost".equals(propertyChangeEvent.getPropertyName())) {
            this.checkEnabled((TopComponent)propertyChangeEvent.getNewValue(), this._topComponents.getActivated());
        } else if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.checkEnabled(this._editors.getTopmost(), (TopComponent)propertyChangeEvent.getNewValue());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TopComponent topComponent = this._topComponents.getActivated();
        TopComponent topComponent2 = this._editors.getTopmost();
        ExplorerManager explorerManager = SyncSelectionAction.find(topComponent);
        ExplorerManager explorerManager2 = null;
        if (explorerManager != null && (explorerManager2 = SyncSelectionAction.find(topComponent2)) != null) {
            this.perform(explorerManager2, explorerManager);
            topComponent2.requestActive();
            ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).zoomToSelection();
        }
    }

    protected void perform(ExplorerManager explorerManager, ExplorerManager explorerManager2) {
        Node[] nodeArray = explorerManager2.getSelectedNodes();
        try {
            explorerManager.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            Exceptions.printStackTrace((Throwable)propertyVetoException);
        }
    }

    protected static ExplorerManager find(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        if (topComponent instanceof ExplorerManager.Provider) {
            return ((ExplorerManager.Provider)topComponent).getExplorerManager();
        }
        return (ExplorerManager)topComponent.getLookup().lookup(ExplorerManager.class);
    }

    public String getName() {
        return "Sync";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

