/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.GenericEntity;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecFactory;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import org.openide.util.Lookup;
import yguard.A.A.D;

public abstract class EntityFactory
extends SpecFactory<MaltegoEntitySpec, MaltegoEntity> {
    public static EntityFactory getDefault() {
        EntityFactory entityFactory = (EntityFactory)((Object)Lookup.getDefault().lookup(EntityFactory.class));
        if (entityFactory == null) {
            entityFactory = new Registry(EntityRegistry.getDefault());
        }
        return entityFactory;
    }

    public static EntityFactory forGraph(D d) {
        EntityRegistry entityRegistry = EntityRegistry.forGraph(d);
        if (entityRegistry == null) {
            return null;
        }
        return new Registry(entityRegistry);
    }

    public MaltegoEntity createInstance(MaltegoEntitySpec maltegoEntitySpec, boolean bl) throws TypeInstantiationException {
        GenericEntity genericEntity;
        if (maltegoEntitySpec.getInstanceClass() == null) {
            genericEntity = new GenericEntity(maltegoEntitySpec.getTypeName());
        } else {
            try {
                genericEntity = (MaltegoEntity)maltegoEntitySpec.getInstanceClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new TypeInstantiationException("Could not instantiate class " + maltegoEntitySpec.getInstanceClass(), (Exception)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TypeInstantiationException("Could not instantiate class " + maltegoEntitySpec.getInstanceClass(), (Exception)illegalAccessException);
            }
        }
        DisplayDescriptorCollection displayDescriptorCollection = this.getProperties(maltegoEntitySpec);
        if (displayDescriptorCollection != null) {
            for (DisplayDescriptor displayDescriptor : displayDescriptorCollection) {
                genericEntity.addProperty((PropertyDescriptor)displayDescriptor);
            }
            for (DisplayDescriptor displayDescriptor : displayDescriptorCollection) {
                if (!displayDescriptor.getLinkedProperties().isEmpty()) continue;
                if (bl && displayDescriptor.getSampleValue() != null) {
                    genericEntity.setValue((PropertyDescriptor)displayDescriptor, displayDescriptor.getSampleValue());
                    continue;
                }
                genericEntity.setValue((PropertyDescriptor)displayDescriptor, displayDescriptor.getDefaultValue());
            }
        }
        return genericEntity;
    }

    protected abstract DisplayDescriptorCollection getProperties(MaltegoEntitySpec var1);

    public static class Registry
    extends EntityFactory {
        private EntityRegistry _registry;

        public Registry(EntityRegistry entityRegistry) {
            this._registry = entityRegistry;
        }

        public MaltegoEntity createInstance(String string, boolean bl) throws TypeInstantiationException {
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)this._registry.get(string);
            if (maltegoEntitySpec == null) {
                MaltegoEntitySpec maltegoEntitySpec2 = (MaltegoEntitySpec)this._registry.get("maltego.Unknown");
                if (maltegoEntitySpec2 != null) {
                    MaltegoEntity maltegoEntity = this.createInstance(maltegoEntitySpec2, bl);
                    maltegoEntity.setTypeName(string);
                    return maltegoEntity;
                }
                return new GenericEntity(string);
            }
            return this.createInstance(maltegoEntitySpec, bl);
        }

        @Override
        protected DisplayDescriptorCollection getProperties(MaltegoEntitySpec maltegoEntitySpec) {
            return InheritanceHelper.getAggregatedProperties(this._registry, maltegoEntitySpec.getTypeName());
        }
    }
}

