/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import java.awt.Component;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;

public abstract class NodeEditor {
    public static NodeEditor getDefault() {
        NodeEditor nodeEditor = (NodeEditor)Lookup.getDefault().lookup(NodeEditor.class);
        if (nodeEditor == null) {
            nodeEditor = new DefaultEntityEditor();
        }
        return nodeEditor;
    }

    public abstract boolean edit(Node var1);

    public boolean edit(Y y) {
        return this.edit(GraphNodeManager.getInstance(y.H()).getNode(y));
    }

    public boolean edit(H h) {
        return this.edit(GraphNodeManager.getInstance(h.a()).getNode(h));
    }

    private static class DefaultEntityEditor
    extends NodeEditor {
        private DefaultEntityEditor() {
        }

        @Override
        public boolean edit(Node node) {
            MaltegoPart maltegoPart = (MaltegoPart)node.getLookup().lookup(MaltegoPart.class);
            if (maltegoPart != null) {
                SpecRegistry specRegistry = this.getRegistry(node);
                DisplayDescriptorCollection displayDescriptorCollection = InheritanceHelper.getAggregatedProperties((SpecRegistry)specRegistry, (String)maltegoPart.getTypeName());
                GroupDefinitions groupDefinitions = InheritanceHelper.getAggregatedPropertyGroups((SpecRegistry)specRegistry, (String)maltegoPart.getTypeName());
                Component component = ComponentFactories.form().createEditingComponent((DataSource)maltegoPart, (DisplayDescriptorEnumeration)displayDescriptorCollection, groupDefinitions);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, "Properties", true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, HelpCtx.DEFAULT_HELP, null);
                return DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == DialogDescriptor.OK_OPTION;
            }
            return false;
        }

        private SpecRegistry getRegistry(Node node) {
            Y y = (Y)node.getLookup().lookup(Y.class);
            LinkRegistry linkRegistry = null;
            if (y != null) {
                D d2 = y.H();
                if (d2 != null) {
                    linkRegistry = EntityRegistry.forGraph((D)d2);
                }
            } else {
                linkRegistry = LinkRegistry.getDefault();
            }
            return linkRegistry;
        }
    }
}

