/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraph;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.matching.MatchingRule;
import com.paterva.maltego.merging.EntityFilter;
import com.paterva.maltego.merging.GraphMatchStrategy;
import com.paterva.maltego.merging.GraphMergeCallback;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.GraphMerger;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.ui.graph.clipboard.MergeOptionsController;
import com.paterva.maltego.ui.graph.clipboard.MouseLocationGraphPasteAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.I.QA;
import yguard.A.J.M;

public class MergeGraphPasteAction
extends MouseLocationGraphPasteAction {
    private GraphMerger _graphMerger;
    private Map<MaltegoEntity, PartMergeStrategy> _mergeStrats;
    private boolean _cancelled;
    private Set<MaltegoEntity> _skipped;

    public String getName() {
        return "Paste";
    }

    @Override
    protected void prePasteGraph(QA qA, QA qA2) {
        this._cancelled = false;
        super.prePasteGraph(qA, qA2);
        GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)qA);
        GraphWrapper graphWrapper2 = MaltegoGraphManager.getWrapper((D)qA2);
        this._graphMerger = this.createGraphMerger(graphWrapper, graphWrapper2);
        this._mergeStrats = this.getEntityMergeStrategies(graphWrapper, graphWrapper2);
    }

    @Override
    protected void pasteGraph(QA qA, QA qA2) {
        if (!this._cancelled) {
            this._graphMerger.append();
        }
    }

    @Override
    protected void postPasteGraph(QA qA, QA qA2) {
        Map map;
        if (!this._cancelled && (map = this._graphMerger.getMapping()) != null) {
            qA.B(false);
            GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)qA);
            for (MaltegoEntity maltegoEntity : map.values()) {
                Y y = graphWrapper.node(maltegoEntity);
                qA.A(y, true);
            }
        }
    }

    protected GraphMerger createGraphMerger(GraphWrapper graphWrapper, GraphWrapper graphWrapper2) {
        GraphMatchStrategy.Simple simple = new GraphMatchStrategy.Simple(MatchingRule.Default, MatchingRule.Default);
        PasteGraphMergeStrategy pasteGraphMergeStrategy = new PasteGraphMergeStrategy();
        PasteGraphMergeCallback pasteGraphMergeCallback = new PasteGraphMergeCallback(graphWrapper, graphWrapper2);
        GraphMerger.Strategic strategic = new GraphMerger.Strategic((GraphMatchStrategy)simple, (GraphMergeStrategy)pasteGraphMergeStrategy, (GraphMergeCallback)pasteGraphMergeCallback);
        strategic.setGraphs(graphWrapper, (MaltegoGraph)graphWrapper2, (EntityFilter)new PasteEntityFilter());
        return strategic;
    }

    protected Map<MaltegoEntity, PartMergeStrategy> getEntityMergeStrategies(GraphWrapper graphWrapper, GraphWrapper graphWrapper2) {
        this._skipped = new HashSet<MaltegoEntity>();
        PartMergeStrategy partMergeStrategy = null;
        boolean bl = false;
        HashMap<MaltegoEntity, PartMergeStrategy> hashMap = new HashMap<MaltegoEntity, PartMergeStrategy>();
        Map map = this._graphMerger.getMatches();
        int n = 0;
        for (MaltegoEntity maltegoEntity : map.keySet()) {
            ++n;
            MaltegoEntity maltegoEntity2 = (MaltegoEntity)map.get(maltegoEntity);
            PartMergeStrategy partMergeStrategy2 = partMergeStrategy;
            if (bl) {
                this._skipped.add(maltegoEntity);
            } else if (partMergeStrategy2 == null) {
                MergeOptionsController mergeOptionsController = new MergeOptionsController(graphWrapper, graphWrapper2, maltegoEntity2, maltegoEntity, map.size() - n);
                if (mergeOptionsController.showMergeOptions()) {
                    if (mergeOptionsController.isMergeEntities()) {
                        partMergeStrategy2 = mergeOptionsController.getMergeStrategy();
                    } else if (mergeOptionsController.isSkipEntity()) {
                        this._skipped.add(maltegoEntity);
                    }
                    if (mergeOptionsController.isDoForAll()) {
                        if (partMergeStrategy2 != null) {
                            partMergeStrategy = partMergeStrategy2;
                        } else {
                            if (!mergeOptionsController.isSkipEntity()) break;
                            bl = true;
                        }
                    }
                } else {
                    this._cancelled = true;
                    return null;
                }
            }
            if (partMergeStrategy2 == null) continue;
            hashMap.put(maltegoEntity, partMergeStrategy2);
        }
        return hashMap;
    }

    private class PasteEntityFilter
    implements EntityFilter {
        private PasteEntityFilter() {
        }

        public boolean accept(MaltegoEntity maltegoEntity) {
            return !MergeGraphPasteAction.this._skipped.contains(maltegoEntity);
        }
    }

    private class PasteGraphMergeCallback
    implements GraphMergeCallback {
        private GraphWrapper _destGraph;
        private GraphWrapper _srcGraph;

        public PasteGraphMergeCallback(GraphWrapper graphWrapper, GraphWrapper graphWrapper2) {
            this._destGraph = graphWrapper;
            this._srcGraph = graphWrapper2;
        }

        public void onEntityTransferred(MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2) {
            this.setCenter(this._destGraph, maltegoEntity, this.getCenter(this._srcGraph, maltegoEntity2));
        }

        public void onEntitiesMerged(MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2) {
            M m = this.getCenter(this._destGraph, maltegoEntity);
            this._destGraph.reAdd(maltegoEntity);
            this.setCenter(this._destGraph, maltegoEntity, m);
        }

        private M getCenter(GraphWrapper graphWrapper, MaltegoEntity maltegoEntity) {
            QA qA = (QA)graphWrapper.getGraph();
            Y y = graphWrapper.node(maltegoEntity);
            return qA.P(y);
        }

        private void setCenter(GraphWrapper graphWrapper, MaltegoEntity maltegoEntity, M m) {
            QA qA = (QA)graphWrapper.getGraph();
            Y y = graphWrapper.node(maltegoEntity);
            qA.B(y, m);
        }

        public void onLinkTransferred(MaltegoLink maltegoLink, MaltegoLink maltegoLink2) {
        }

        public void onLinksMerged(MaltegoLink maltegoLink, MaltegoLink maltegoLink2) {
        }
    }

    private class PasteGraphMergeStrategy
    implements GraphMergeStrategy {
        private PasteGraphMergeStrategy() {
        }

        public PartMergeStrategy getEntityMergeStrategy(MaltegoEntity maltegoEntity, MaltegoEntity maltegoEntity2) {
            return (PartMergeStrategy)MergeGraphPasteAction.this._mergeStrats.get(maltegoEntity2);
        }

        public PartMergeStrategy getLinkMergeStrategy(MaltegoLink maltegoLink, MaltegoLink maltegoLink2) {
            return PartMergeStrategy.PreferNew;
        }
    }
}

