/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.RecentFiles;
import com.paterva.maltego.ui.graph.impl.GraphViewFactory;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.Action;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.util.Exceptions;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

class GraphOpenSupport
extends OpenSupport
implements OpenCookie,
CloseCookie {
    public GraphOpenSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    protected String messageOpened() {
        return "Opened";
    }

    protected String messageOpening() {
        return "Opening...";
    }

    protected GraphDataObject getGraphDataObject() {
        return (GraphDataObject)this.entry.getDataObject();
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        CloneableTopComponent cloneableTopComponent;
        if (!this.entry.getDataObject().isTemplate()) {
            try {
                RecentFiles.getInstance().addFile(this.entry.getFile().getURL().toString());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        if ((cloneableTopComponent = GraphViewFactory.createViews((DataObject)this.entry.getDataObject(), new CloseHandler())) != null) {
            cloneableTopComponent.putClientProperty((Object)"selection", (Object)"always");
            cloneableTopComponent.setDisplayName(this.entry.getDataObject().getName());
            TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("MaltegoDetailViewsGroup");
            if (topComponentGroup != null) {
                topComponentGroup.open();
            }
            return cloneableTopComponent;
        }
        return null;
    }

    protected boolean canClose() {
        return !this.entry.getDataObject().isModified();
    }

    private static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CloseHandler() {
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            LinkedList<CloseOperationState> linkedList = new LinkedList<CloseOperationState>(Arrays.asList(closeOperationStateArray));
            while (!linkedList.isEmpty()) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)"Save before closing?");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (confirmation.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    CloseOperationState[] closeOperationStateArray2 = linkedList.iterator();
                    while (closeOperationStateArray2.hasNext()) {
                        CloseOperationState closeOperationState = (CloseOperationState)closeOperationStateArray2.next();
                        Action action = closeOperationState.getProceedAction();
                        action.actionPerformed(new ActionEvent(this, 1001, "dirty"));
                        if (action.isEnabled()) continue;
                        closeOperationStateArray2.remove();
                    }
                    continue;
                }
                if (confirmation.getValue().equals(NotifyDescriptor.NO_OPTION)) {
                    for (CloseOperationState closeOperationState : closeOperationStateArray) {
                        closeOperationState.getDiscardAction().actionPerformed(new ActionEvent(this, 1001, "dirty"));
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

