/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import com.paterva.maltego.ui.graph.actions.UpdateViewAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import yguard.A.A.C;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.A._;
import yguard.A.I.H;
import yguard.A.I.QA;

class GraphViewUpdateManager {
    public static final String PROP_MODEL_CHANGED = "modelDirty";
    public static final String PROP_VIEW_CHANGED = "viewDirty";
    public static final String PROP_FREEZE_CHANGED = "freezeChanged";
    private D _viewGraph;
    private D _modelGraph;
    private UpdateHandler _modelUpdater;
    private UpdateHandler _viewUpdater;
    private boolean _viewDirty;
    private boolean _modelDirty;
    private PropertyChangeSupport _changeSupport;
    private boolean _updateViewOnShow = false;
    private boolean _updateViewOnModelChange = true;
    private boolean _updateModelOnViewChange = true;
    private Action _freezeAction;
    private Action _updateViewAction;
    private Action _updateAndUnfreezeAction;
    private ViewUpdateCallback _cb;
    private Set<Y> _newNodes = new HashSet<Y>();
    private boolean _relayoutSelected = true;
    private boolean _blockViewUpdate = false;
    private boolean _blockModelUpdate = false;

    public GraphViewUpdateManager() {
        this(null);
    }

    public GraphViewUpdateManager(ViewUpdateCallback viewUpdateCallback) {
        this._cb = viewUpdateCallback;
    }

    public Action getUpdateViewAction() {
        if (this._updateViewAction == null) {
            this._updateViewAction = new AbstractAction(null, ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/reload.png", (boolean)false)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GraphViewUpdateManager.this.updateView();
                        }
                    });
                }
            };
            this._updateViewAction.putValue("ShortDescription", "Update this graph with recent changes");
            this._updateViewAction.setEnabled(this.isViewChanged());
        }
        return this._updateViewAction;
    }

    public Action getUpdateAndUnfreezeAction() {
        if (this._updateAndUnfreezeAction == null) {
            this._updateAndUnfreezeAction = new AbstractAction(null, ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/reload.png", (boolean)false)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GraphViewUpdateManager.this.setUpdateViewOnModelChange(true);
                            GraphViewUpdateManager.this.updateView();
                        }
                    });
                }
            };
            this._updateAndUnfreezeAction.putValue("ShortDescription", "Update this graph with recent changes");
            this._updateAndUnfreezeAction.setEnabled(this.isViewChanged());
        }
        return this._updateAndUnfreezeAction;
    }

    public Action getToggleFreezeAction() {
        if (this._freezeAction == null) {
            this._freezeAction = new AbstractAction(null, ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FreezeBlue.png", (boolean)false)){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GraphViewUpdateManager.this.setUpdateViewOnModelChange(!GraphViewUpdateManager.this.isUpdateViewOnModelChange());
                    if (GraphViewUpdateManager.this.isUpdateModelOnViewChange() && GraphViewUpdateManager.this._viewDirty) {
                        GraphViewUpdateManager.this.updateView();
                    }
                }
            };
            this._freezeAction.putValue("ShortDescription", "Freeze/unfreeze this view");
        }
        return this._freezeAction;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void setViewDirty(boolean bl) {
        if (this._updateViewAction != null) {
            this._updateViewAction.setEnabled(bl);
        }
        if (this._updateAndUnfreezeAction != null) {
            this._updateAndUnfreezeAction.setEnabled(bl);
        }
        if (!bl) {
            UpdateViewAction.setNotification(null);
        }
        if (this._viewDirty != bl) {
            this._viewDirty = bl;
            if (this._changeSupport != null) {
                this._changeSupport.firePropertyChange(PROP_VIEW_CHANGED, !bl, bl);
            }
        }
    }

    protected void setModelDirty(boolean bl) {
        if (this._updateViewAction != null) {
            this._updateViewAction.setEnabled(bl);
        }
        if (this._updateAndUnfreezeAction != null) {
            this._updateAndUnfreezeAction.setEnabled(bl);
        }
        if (this._modelDirty != bl) {
            this._modelDirty = bl;
            if (this._changeSupport != null) {
                this._changeSupport.firePropertyChange(PROP_MODEL_CHANGED, !bl, bl);
            }
        }
    }

    public boolean isViewChanged() {
        return this._viewDirty;
    }

    public boolean isModelChanged() {
        return this._modelDirty;
    }

    public void setGraphs(D d2, D d3) {
        this._modelDirty = false;
        this._viewDirty = false;
        if (this._modelUpdater != null && this._viewGraph != null) {
            this._viewGraph.B((_)this._modelUpdater);
        }
        if (this._viewUpdater != null && this._modelGraph != null) {
            this._modelGraph.B((_)this._viewUpdater);
        }
        if (this._modelUpdater == null) {
            this._modelUpdater = new ModelUpdateHandler();
        }
        if (this._viewUpdater == null) {
            this._viewUpdater = new ViewUpdateHandler();
        }
        d3.A((_)this._modelUpdater);
        d2.A((_)this._viewUpdater);
        this._viewGraph = d3;
        this._modelGraph = d2;
    }

    public D getModelGraph() {
        return this._modelGraph;
    }

    public D getViewGraph() {
        return this._viewGraph;
    }

    public void viewShowing() {
        if (this.isUpdateViewOnShow()) {
            System.out.println("UPDATE - View showing");
            this.updateView();
        }
        UpdateViewAction.setAction(this.getUpdateAndUnfreezeAction());
        UpdateViewAction.setNotification(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateView() {
        D d2 = this.getModelGraph();
        D d3 = this.getViewGraph();
        if (d2 != null && d3 != null) {
            H h = H.F((D)d2);
            d3.\u00e3();
            try {
                if (this._cb != null) {
                    this._cb.updateStarted();
                }
                h.M(d3);
                if (this._cb != null) {
                    this._cb.performUpdate(this._newNodes, this._relayoutSelected);
                }
            }
            finally {
                this._newNodes.clear();
                this._relayoutSelected = true;
                d3.\u00d0();
                if (this._cb != null) {
                    this._cb.updateCompleted();
                }
            }
        }
        this.setViewDirty(false);
    }

    private void updateModel() {
        D d2 = this.getModelGraph();
        D d3 = this.getViewGraph();
        if (d2 != null && d3 != null) {
            H h = H.F((D)d2);
            d2.\u00e3();
            h.C(d3);
            d2.\u00d0();
        }
        this.setModelDirty(false);
    }

    public void viewHidden() {
    }

    public void viewClosed() {
    }

    public boolean isUpdateViewOnShow() {
        return this._updateViewOnShow;
    }

    public void setUpdateViewOnShow(boolean bl) {
        this._updateViewOnShow = bl;
    }

    public boolean isUpdateViewOnModelChange() {
        return this._updateViewOnModelChange;
    }

    public void setUpdateViewOnModelChange(boolean bl) {
        if (this._updateViewOnModelChange != bl) {
            this._updateViewOnModelChange = bl;
            if (this._updateViewAction != null) {
                this._updateViewAction.setEnabled(this.isViewChanged() && !bl);
            }
            if (this._updateAndUnfreezeAction != null) {
                this._updateAndUnfreezeAction.setEnabled(this.isViewChanged() && !bl);
            }
            this._changeSupport.firePropertyChange(PROP_FREEZE_CHANGED, null, null);
        }
    }

    public boolean isUpdateModelOnViewChange() {
        return this._updateModelOnViewChange;
    }

    public void setUpdateModelOnViewChange(boolean bl) {
        this._updateModelOnViewChange = bl;
    }

    public static interface ViewUpdateCallback {
        public void updateStarted();

        public void performUpdate(Set<Y> var1, boolean var2);

        public void updateCompleted();
    }

    private class ViewUpdateHandler
    extends UpdateHandler {
        private ViewUpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void structureChanged(D d2) {
            try {
                GraphViewUpdateManager.this._blockModelUpdate = true;
                GraphViewUpdateManager.this.setViewDirty(true);
                if (GraphViewUpdateManager.this.isUpdateViewOnModelChange() && !GraphViewUpdateManager.this._blockViewUpdate) {
                    System.out.println("UPDATE - Model change");
                    GraphViewUpdateManager.this.updateView();
                }
            }
            finally {
                GraphViewUpdateManager.this._blockModelUpdate = false;
            }
        }
    }

    private class ModelUpdateHandler
    extends UpdateHandler {
        private Timer _labelPlaceTimer;
        private boolean _needToPlaceLabels;
        private long _lastUpdate;

        public ModelUpdateHandler() {
            this._needToPlaceLabels = false;
            this._lastUpdate = 0L;
            this._labelPlaceTimer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ModelUpdateHandler.this._block == 0 && ModelUpdateHandler.this._needToPlaceLabels && System.currentTimeMillis() - ModelUpdateHandler.this._lastUpdate > 1000L) {
                        ModelUpdateHandler.this.placeLabels(GraphViewUpdateManager.this._viewGraph);
                    }
                }
            });
            this._labelPlaceTimer.start();
        }

        @Override
        public void onGraphEvent(C c2) {
            if (GraphViewUpdateManager.this._blockModelUpdate) {
                switch (c2.C()) {
                    case 0: {
                        Y y = (Y)c2.A();
                        if (y == null) break;
                        GraphViewUpdateManager.this._newNodes.add(y);
                        break;
                    }
                    case 3: {
                        Y y = (Y)c2.A();
                        if (y == null) break;
                        GraphViewUpdateManager.this._newNodes.remove(y);
                        break;
                    }
                }
            }
            super.onGraphEvent(c2);
            this._lastUpdate = System.currentTimeMillis();
            this._needToPlaceLabels = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void structureChanged(D d2) {
            try {
                GraphViewUpdateManager.this._blockViewUpdate = true;
                GraphViewUpdateManager.this.setModelDirty(true);
                if (GraphViewUpdateManager.this.isUpdateModelOnViewChange() && !GraphViewUpdateManager.this._blockModelUpdate) {
                    System.out.println("UPDATE - View change");
                    GraphViewUpdateManager.this.updateModel();
                }
            }
            finally {
                GraphViewUpdateManager.this._blockViewUpdate = false;
            }
        }

        private void placeLabels(D d2) {
            PlaceLabelsAction placeLabelsAction = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
            if (placeLabelsAction != null && d2 instanceof QA) {
                placeLabelsAction.perform((QA)d2, new Runnable(){

                    @Override
                    public void run() {
                        ModelUpdateHandler.this._needToPlaceLabels = false;
                    }
                });
            }
        }
    }

    private abstract class UpdateHandler
    implements _ {
        protected int _block;
        private boolean _structureChanged = false;

        private UpdateHandler() {
        }

        public void onGraphEvent(C c2) {
            switch (c2.C()) {
                case 12: {
                    ++this._block;
                    break;
                }
                case 13: {
                    Boolean bl;
                    --this._block;
                    Object object = c2.A();
                    if (!(object instanceof Boolean) || !(bl = (Boolean)object).booleanValue()) break;
                    GraphViewUpdateManager.this._relayoutSelected = false;
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 5: 
                case 10: 
                case 11: {
                    this._structureChanged = true;
                    break;
                }
            }
            if (this._block == 0 && this._structureChanged) {
                this._structureChanged = false;
                this.structureChanged(c2.B());
            }
        }

        protected abstract void structureChanged(D var1);
    }
}

