/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.nodes.ChangeTypePanel;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.ui.graph.view2d.LegendBackgroundRenderer;
import javax.swing.JComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;
import yguard.A.A.D;
import yguard.A.A.Y;
import yguard.A.I.LA;
import yguard.A.I.S;

public class ChangeTypeAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        Node[] nodeArray2 = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        D d2 = this.getGraph(nodeArray2[0]);
        MaltegoEntitySpec maltegoEntitySpec = this.getNewSpec(d2, this.getSpec(nodeArray2[0]));
        if (maltegoEntitySpec != null) {
            EntityRegistry entityRegistry = EntityRegistry.forGraph((D)d2);
            for (Node node : nodeArray2) {
                MaltegoEntity maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
                PropertyDescriptor propertyDescriptor = InheritanceHelper.getValueProperty((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
                PropertyDescriptor propertyDescriptor2 = InheritanceHelper.getDisplayValueProperty((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
                Object object = maltegoEntity.getValue(propertyDescriptor);
                Object object2 = maltegoEntity.getValue(propertyDescriptor2);
                this.addTypeProperties(entityRegistry, maltegoEntitySpec, maltegoEntity);
                maltegoEntity.setTypeName(maltegoEntitySpec.getTypeName());
                this.resetSpecialPropertyMappings(maltegoEntity);
                this.transferValueProperty(entityRegistry, maltegoEntity, propertyDescriptor, object);
                if (!propertyDescriptor.equals(propertyDescriptor2)) {
                    this.transferDisplayValueProperty(entityRegistry, maltegoEntity, propertyDescriptor2, object2);
                }
                this.updateSloppyLegend();
            }
        }
    }

    private MaltegoEntitySpec getNewSpec(D d2, MaltegoEntitySpec maltegoEntitySpec) {
        ChangeTypePanel changeTypePanel = new ChangeTypePanel(d2);
        changeTypePanel.setEntitySpec(maltegoEntitySpec);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)changeTypePanel, "Choose New Entity Type", true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            return changeTypePanel.getEntitySpec();
        }
        return null;
    }

    private MaltegoEntitySpec getSpec(Node node) {
        MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)node.getLookup().lookup(MaltegoEntitySpec.class);
        return maltegoEntitySpec;
    }

    private D getGraph(Node node) {
        Y y = (Y)node.getLookup().lookup(Y.class);
        D d2 = y.H();
        return d2;
    }

    private void addTypeProperties(EntityRegistry entityRegistry, MaltegoEntitySpec maltegoEntitySpec, MaltegoEntity maltegoEntity) {
        DisplayDescriptorCollection displayDescriptorCollection = InheritanceHelper.getAggregatedProperties((SpecRegistry)entityRegistry, (String)maltegoEntitySpec.getTypeName());
        for (DisplayDescriptor displayDescriptor : displayDescriptorCollection) {
            if (maltegoEntity.getProperties().contains((PropertyDescriptor)displayDescriptor)) continue;
            maltegoEntity.addProperty((PropertyDescriptor)displayDescriptor);
            maltegoEntity.setValue((PropertyDescriptor)displayDescriptor, displayDescriptor.getDefaultValue());
        }
    }

    private void transferValueProperty(EntityRegistry entityRegistry, MaltegoEntity maltegoEntity, PropertyDescriptor propertyDescriptor, Object object) {
        PropertyDescriptor propertyDescriptor2 = InheritanceHelper.getValueProperty((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        if (!propertyDescriptor2.equals(propertyDescriptor) && propertyDescriptor2.getType().equals(propertyDescriptor.getType())) {
            maltegoEntity.setValue(propertyDescriptor2, object);
        }
    }

    private void transferDisplayValueProperty(EntityRegistry entityRegistry, MaltegoEntity maltegoEntity, PropertyDescriptor propertyDescriptor, Object object) {
        PropertyDescriptor propertyDescriptor2 = InheritanceHelper.getDisplayValueProperty((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity);
        if (!propertyDescriptor2.equals(propertyDescriptor) && propertyDescriptor2.getType().equals(propertyDescriptor.getType())) {
            maltegoEntity.setValue(propertyDescriptor2, object);
        }
    }

    private void resetSpecialPropertyMappings(MaltegoEntity maltegoEntity) {
        maltegoEntity.setDisplayValueProperty(null);
        maltegoEntity.setValueProperty(null);
    }

    protected boolean enable(Node[] nodeArray) {
        Node[] nodeArray2 = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        return nodeArray2 != null && nodeArray2.length > 0;
    }

    public String getName() {
        return "Change Type";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private void updateSloppyLegend() {
        S s;
        LA lA;
        JComponent jComponent;
        GraphViewCookie graphViewCookie;
        TopComponent topComponent = GraphEditorRegistry.getDefault().getActive();
        if (topComponent != null && (graphViewCookie = (GraphViewCookie)topComponent.getLookup().lookup(GraphViewCookie.class)) != null && (jComponent = graphViewCookie.getGraphView().getViewControl()) instanceof S && (lA = (s = (S)jComponent).\u00b5()) instanceof LegendBackgroundRenderer) {
            ((LegendBackgroundRenderer)lA).setNeedsRecalc();
        }
    }
}

