/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.imgfactory.ImageCache;
import com.paterva.maltego.ui.graph.nodes.GraphNodeManager;
import com.paterva.maltego.util.FastURL;
import java.util.HashSet;
import java.util.Set;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import yguard.A.A.D;
import yguard.A.A.Y;

public class ClearCacheAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        ImageCache imageCache = ImageCache.getDefault();
        Set<FastURL> set = this.getImagesToRefresh(imageCache);
        for (FastURL fastURL : set) {
            imageCache.remove((Object)fastURL);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        Node[] nodeArray2 = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        return nodeArray2 != null && nodeArray2.length > 0;
    }

    public String getName() {
        return "Clear/Refresh Images";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private Set<FastURL> getImagesToRefresh(ImageCache imageCache) {
        HashSet<FastURL> hashSet = new HashSet<FastURL>();
        Node[] nodeArray = GraphNodeManager.getEntityNodes(this.getActivatedNodes());
        EntityRegistry entityRegistry = null;
        for (Node node : nodeArray) {
            MaltegoEntity maltegoEntity;
            Object object;
            if (entityRegistry == null) {
                entityRegistry = this.getRegistry(node);
            }
            if (!((object = InheritanceHelper.getImage((EntityRegistry)entityRegistry, (MaltegoEntity)(maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class)))) instanceof FastURL) || !imageCache.contains(object)) continue;
            hashSet.add((FastURL)object);
        }
        return hashSet;
    }

    private EntityRegistry getRegistry(Node node) {
        EntityRegistry entityRegistry = null;
        Y y = (Y)node.getLookup().lookup(Y.class);
        if (y != null) {
            entityRegistry = EntityRegistry.forGraph((D)y.H());
        }
        return entityRegistry;
    }
}

