/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.ui.graph.nodes.EntityNode;
import com.paterva.maltego.ui.graph.nodes.GraphNode;
import org.openide.util.lookup.InstanceContent;

class NodeToEntitySpecConverter
implements InstanceContent.Convertor<EntityNode, MaltegoEntitySpec> {
    private static NodeToEntitySpecConverter _instance;

    private NodeToEntitySpecConverter() {
    }

    public static NodeToEntitySpecConverter instance() {
        if (_instance == null) {
            _instance = new NodeToEntitySpecConverter();
        }
        return _instance;
    }

    public MaltegoEntitySpec convert(EntityNode entityNode) {
        GraphNode graphNode = entityNode.findGraphNode();
        if (graphNode == null) {
            NodeToEntitySpecConverter.log("No graph node found for entity node " + (Object)((Object)entityNode));
        } else {
            EntityRegistry entityRegistry = (EntityRegistry)graphNode.getLookup().lookup(EntityRegistry.class);
            if (entityRegistry == null) {
                NodeToEntitySpecConverter.log("No entity registry found for graph node " + (Object)((Object)graphNode));
            } else {
                MaltegoEntity maltegoEntity = (MaltegoEntity)entityNode.getLookup().lookup(MaltegoEntity.class);
                if (maltegoEntity == null) {
                    NodeToEntitySpecConverter.log("No entity found in entity node " + (Object)((Object)entityNode));
                } else {
                    MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(maltegoEntity.getTypeName());
                    if (maltegoEntitySpec == null) {
                        NodeToEntitySpecConverter.log("No entity spec found for type " + maltegoEntity.getTypeName());
                    }
                    return maltegoEntitySpec;
                }
            }
        }
        return null;
    }

    private static void log(String string) {
    }

    public Class<? extends MaltegoEntitySpec> type(EntityNode entityNode) {
        return MaltegoEntitySpec.class;
    }

    public String id(EntityNode entityNode) {
        return entityNode.toString();
    }

    public String displayName(EntityNode entityNode) {
        return entityNode.getDisplayName();
    }
}

