/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.find.SearchProvider;
import com.paterva.maltego.ui.graph.find.ShowFindBarAction;
import com.paterva.maltego.ui.graph.view2d.BookmarkHoverViewMode;
import com.paterva.maltego.ui.graph.view2d.EditNotesViewMode;
import com.paterva.maltego.ui.graph.view2d.Graph2DViewAdapter;
import com.paterva.maltego.ui.graph.view2d.GraphViewActions;
import com.paterva.maltego.ui.graph.view2d.GraphViewOptions;
import com.paterva.maltego.ui.graph.view2d.LabelEditMode;
import com.paterva.maltego.ui.graph.view2d.LegendBackgroundRenderer;
import com.paterva.maltego.ui.graph.view2d.LinkHighlighter;
import com.paterva.maltego.ui.graph.view2d.NotesHoverViewMode;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.color.ColorUtil;
import org.openide.actions.FindAction;
import org.openide.awt.StatusDisplayer;
import org.openide.util.actions.SystemAction;
import yguard.A.A.D;
import yguard.A.A.X;
import yguard.A.I.LA;
import yguard.A.I.QA;
import yguard.A.I.S;
import yguard.A.I.fB;
import yguard.A.I.rA;

public class DefaultGraph2DViewAdapter
extends Graph2DViewAdapter {
    private LinkHighlighter _highlighter;
    private LegendBackgroundRenderer _backgroundRenderer;

    @Override
    protected void onGraphChanged(QA qA, QA qA2) {
        if (qA != null) {
            this.linkHighlighter().disconnect(qA);
            if (this._backgroundRenderer != null) {
                this._backgroundRenderer.disconnect((D)qA);
            }
        }
        if (qA2 != null) {
            this.linkHighlighter().connect(qA2);
            if (this._backgroundRenderer != null) {
                this._backgroundRenderer.connect((D)qA2);
            }
        }
    }

    @Override
    protected S createView() {
        S s = super.createView();
        GraphViewActions graphViewActions = new GraphViewActions(s);
        ActionMap actionMap = graphViewActions.createActionMap();
        InputMap inputMap = graphViewActions.createDefaultInputMap(actionMap);
        FindAction findAction = (FindAction)SystemAction.get(FindAction.class);
        actionMap.put(findAction.getActionMapKey(), new ShowFindBarAction(this, new Graph2DSearchProvider()));
        s.setActionMap(actionMap);
        s.setInputMap(1, inputMap);
        this._backgroundRenderer = this.createBackground(s);
        s.B((LA)this._backgroundRenderer);
        s.D((fB)this.linkHighlighter());
        s.D((fB)new BookmarkHoverViewMode());
        s.D((fB)new NotesHoverViewMode());
        s.D((fB)new EditNotesViewMode());
        s.J(true);
        MaltegoLAF.Safe safe = new MaltegoLAF.Safe();
        Color color = safe.getColor("graph-selectionbox-line-color");
        Color color2 = ColorUtil.setAlpha((Color)safe.getColor("graph-selectionbox-fill-color"), (int)safe.getInt("graph-selectionbox-fill-alpha"));
        s.putClientProperty((Object)"selectionbox.linecolor", (Object)color);
        s.putClientProperty((Object)"selectionbox.fillcolor", (Object)color2);
        return s;
    }

    private LinkHighlighter linkHighlighter() {
        if (this._highlighter == null) {
            this._highlighter = this.createLinkHighlighter();
        }
        return this._highlighter;
    }

    protected LinkHighlighter createLinkHighlighter() {
        return new LinkHighlighter();
    }

    @Override
    protected rA createEditMode() {
        rA rA2 = super.createEditMode();
        rA2.setEditNodeMode((fB)new LabelEditMode());
        return rA2;
    }

    private static void showActionMap(ActionMap actionMap, InputMap inputMap) {
        System.out.println("---- Actions -----");
        for (Object object : actionMap.allKeys()) {
            System.out.println(object + "->" + actionMap.get(object).getClass().getName());
        }
        System.out.println("---- Keys ------");
        for (KeyStroke keyStroke : inputMap.allKeys()) {
            System.out.println(keyStroke + "->" + inputMap.get(keyStroke));
        }
        System.out.println("--------------");
    }

    protected LegendBackgroundRenderer createBackground(S s) {
        LegendBackgroundRenderer legendBackgroundRenderer = new LegendBackgroundRenderer(s, EntityColorFactory.getDefault());
        legendBackgroundRenderer.setMode((byte)0);
        legendBackgroundRenderer.setLegendPosition(1);
        legendBackgroundRenderer.setImage(GraphViewOptions.getDefault().getBackground());
        return legendBackgroundRenderer;
    }

    private class Graph2DSearchProvider
    implements SearchProvider {
        private Graph2DSearchProvider() {
        }

        @Override
        public void search(String string, Map<String, Object> map) {
            string = string.toLowerCase();
            boolean bl = false;
            if (string.startsWith("!")) {
                string = string.substring(1);
                bl = true;
            }
            this.search(DefaultGraph2DViewAdapter.this.getView().H(), string, bl, map);
        }

        public void search(QA qA, String string, boolean bl, Map<String, Object> map) {
            StatusDisplayer.getDefault().setStatusText("Searching for entities...");
            X x = new X();
            String string2 = null;
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)map.get("type");
            if (maltegoEntitySpec != null) {
                string2 = maltegoEntitySpec.getTypeName();
            }
            boolean bl2 = this.getBoolean(map, "allProperties", false);
            boolean bl3 = this.getBoolean(map, "notes", false);
            boolean bl4 = this.getBoolean(map, "displayInfo", false);
            EntityRegistry entityRegistry = EntityRegistry.forGraph((D)qA);
            GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)qA);
            for (MaltegoEntity maltegoEntity : graphWrapper.entities()) {
                boolean bl5 = true;
                if (string2 != null) {
                    if (entityRegistry != null) {
                        List list = InheritanceHelper.getInheritanceList((SpecRegistry)entityRegistry, (String)maltegoEntity.getTypeName());
                        bl5 = list.contains(string2);
                    } else {
                        string2.equals(maltegoEntity.getTypeName());
                    }
                }
                if (!bl5) continue;
                boolean bl6 = this.matches(entityRegistry, maltegoEntity, string, bl2, bl3, bl4);
                if (bl) {
                    boolean bl7 = bl6 = !bl6;
                }
                if (!bl6) continue;
                x.add((Object)graphWrapper.node(maltegoEntity));
            }
            String string3 = x.size() > 0 ? "Found " + x.size() + " entities" : "No results were found";
            StatusDisplayer.getDefault().setStatusText(string3);
            this.select(qA, x);
            boolean bl8 = this.getBoolean(map, "zoomToResult", true);
            if (bl8) {
                ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).zoomToSelection();
            }
            qA.\u011b();
            DefaultGraph2DViewAdapter.this.getView().requestFocusInWindow();
        }

        private boolean getBoolean(Map<String, Object> map, String string, boolean bl) {
            Boolean bl2 = (Boolean)map.get(string);
            if (bl2 == null) {
                return bl;
            }
            return bl2;
        }

        private boolean matches(EntityRegistry entityRegistry, MaltegoEntity maltegoEntity, String string, boolean bl, boolean bl2, boolean bl3) {
            if (this.matches(string, InheritanceHelper.getValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity)) || this.matches(string, InheritanceHelper.getDisplayValue((SpecRegistry)entityRegistry, (TypedPropertyBag)maltegoEntity))) {
                return true;
            }
            if (bl && this.findInProperties(maltegoEntity, string)) {
                return true;
            }
            if (bl2 && this.findInNotes(maltegoEntity, string)) {
                return true;
            }
            return bl3 && this.findInDisplayInfo(maltegoEntity, string);
        }

        private boolean matches(String string, Object object) {
            if (object == null) {
                return false;
            }
            return object.toString().toLowerCase().contains(string);
        }

        private boolean findInProperties(MaltegoEntity maltegoEntity, String string) {
            PropertyDescriptorCollection propertyDescriptorCollection = maltegoEntity.getProperties();
            if (propertyDescriptorCollection != null) {
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorCollection) {
                    Object object = maltegoEntity.getValue(propertyDescriptor);
                    if (!this.matches(string, object)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean findInNotes(MaltegoEntity maltegoEntity, String string) {
            return this.matches(string, maltegoEntity.getNotes());
        }

        private boolean findInDisplayInfo(MaltegoEntity maltegoEntity, String string) {
            DisplayInformationCollection displayInformationCollection = maltegoEntity.getDisplayInformation();
            if (displayInformationCollection != null) {
                for (DisplayInformation displayInformation : displayInformationCollection) {
                    if (!this.matches(string, displayInformation.getValue())) continue;
                    return true;
                }
            }
            return false;
        }

        private void select(QA qA, X x) {
            qA.\u00e3();
            qA.A(qA.\u00d1(), false);
            qA.A(x.t(), true);
            qA.\u00d0();
        }
    }
}

