/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphWrapper;
import com.paterva.maltego.graph.MaltegoGraphManager;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.EntityImageFactory;
import com.paterva.maltego.ui.graph.view2d.EntitySloppyPainter;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ui.GraphicsUtils;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import org.openide.util.NbPreferences;
import yguard.A.A.D;
import yguard.A.I.;
import yguard.A.I.F;

class EntityImagePainter
extends F {
    private static boolean _paintTypeOverlay;
    private static boolean _paintAttachmentsOverlay;
    private static ImageCallback _imgCallback;
    private static long _lastUpdate;
    private EntitySloppyPainter _sloppyPainter = new EntitySloppyPainter();

    protected void paintNode(.A a2, Graphics2D graphics2D, boolean bl) {
        if (bl) {
            this._sloppyPainter.paintSloppy(a2, graphics2D);
        } else {
            Object object;
            double d2 = a2.getX();
            double d3 = a2.getY();
            double d4 = a2.getWidth();
            double d5 = a2.getHeight();
            GraphWrapper graphWrapper = MaltegoGraphManager.getWrapper((D)a2.getNode().H());
            MaltegoEntity maltegoEntity = graphWrapper.entity(a2.getNode());
            EntityImageFactory entityImageFactory = EntityImageFactory.forGraph(a2.getNode().H());
            Image image = entityImageFactory.getImage(maltegoEntity, -1, -1, _imgCallback);
            Dimension dimension = this.calcScaledSize(image.getWidth(null), image.getHeight(null), 48.0f);
            d2 = (d4 - dimension.getWidth()) / 2.0 + d2;
            d3 = (d5 - dimension.getHeight()) / 2.0 + d3;
            graphics2D.drawImage(image, (int)d2, (int)d3, (int)dimension.getWidth(), (int)dimension.getHeight(), null);
            if (System.currentTimeMillis() - _lastUpdate > 3000L) {
                _paintTypeOverlay = NbPreferences.forModule(EntityImagePainter.class).getBoolean("showTypeOverlayIcons", true);
                _paintAttachmentsOverlay = NbPreferences.forModule(EntityImagePainter.class).getBoolean("showAttachmentsOverlayIcons", true);
                _lastUpdate = System.currentTimeMillis();
            }
            if (_paintTypeOverlay && entityImageFactory.hasImage(maltegoEntity) && (object = entityImageFactory.getTypeImage(maltegoEntity.getTypeName(), _imgCallback)) != null) {
                int n = Math.max(dimension.width / 3, dimension.height / 3);
                graphics2D.drawImage((Image)object, (int)d2, (int)(dimension.getHeight() - (double)n + d3), n, n, null);
            }
            if (_paintAttachmentsOverlay) {
                for (PropertyDescriptor propertyDescriptor : maltegoEntity.getProperties()) {
                    Attachments attachments;
                    if (!Attachments.class.equals((Object)propertyDescriptor.getType()) || (attachments = (Attachments)maltegoEntity.getValue(propertyDescriptor)) == null || attachments.isEmpty()) continue;
                    GraphicsUtils.drawPaperClip((Graphics2D)graphics2D, (double)(d2 + 2.0), (double)(d3 + 2.0));
                    break;
                }
            }
        }
    }

    private Dimension calcScaledSize(int n, int n2, float f) {
        Dimension dimension = new Dimension((int)f, (int)f);
        double d2 = (double)n / (double)n2;
        if (d2 > 1.0) {
            dimension.setSize(f, (double)f / d2);
        } else if (d2 < 1.0) {
            dimension.setSize((double)f * d2, f);
        }
        return dimension;
    }

    static {
        _imgCallback = new NodeRealizerImageCallback();
        _lastUpdate = 0L;
    }

    private static class NodeRealizerImageCallback
    implements ImageCallback {
        public void imageReady(Object object, Object object2) {
        }

        public void imageFailed(Object object, Exception exception) {
        }

        public boolean needAwtThread() {
            return true;
        }
    }
}

